// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: uint32.h 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/05/1997  
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The UINT32 class is used to represent 32 bit unsigned integers
independently of the operating system or hardware platform used.
It works by separating a 32-bit value into four separate byte
values and reordering the bytes lowest-order to highest-order.
An UINT32 type has a base 10 limit of 4,294,967,295.
*/
// ----------------------------------------------------------- //   
#ifndef __UINT32_HPP
#define __UINT32_HPP

#include "dtypes.h"

// Data structure for unsigned 32 bit integer values.
class UINT32
{
public:
  UINT32(__ULWORD__ val = 0);
  UINT32(const UINT32& ob);
  UINT32& operator=(const UINT32& ob);
  UINT32& operator=(const __ULWORD__ ob);

public:
  void UnPackBits(__ULWORD__ val);
  __ULWORD__ PackBits() const;

public:
  operator __ULWORD__() const;
  
public: // Arithmetic operators that modify their operand
  UINT32 operator++(int);  // Postfix
  UINT32 operator--(int);  // Postfix
  UINT32 &operator++() { operator=(*this + 1); return *this; } // Prefix
  UINT32 &operator--() { operator=(*this - 1); return *this; } // Prefix
  void operator+=(const UINT32 &i) { operator=(*this + i); }
  void operator-=(const UINT32 &i) { operator=(*this - i); }
  void operator*=(const UINT32 &i) { operator=(*this * i); }
  void operator/=(const UINT32 &i);

  void operator+=(const __LWORD__ &i) { operator=(*this + i); }
  void operator-=(const __LWORD__ &i) { operator=(*this - i); }
  void operator*=(const __LWORD__ &i) { operator=(*this * i); }
  void operator/=(const __LWORD__ &i);

  void operator+=(const __ULWORD__ &i) { operator=(*this + i); }
  void operator-=(const __ULWORD__ &i) { operator=(*this - i); }
  void operator*=(const __ULWORD__ &i) { operator=(*this * i); }
  void operator/=(const __ULWORD__ &i);

  void operator+=(const __WORD__ &i) { operator=(*this + i); }
  void operator-=(const __WORD__ &i) { operator=(*this - i); }
  void operator*=(const __WORD__ &i) { operator=(*this * i); }
  void operator/=(const __WORD__ &i);

  void operator+=(const __SWORD__ &i) { operator=(*this + i); }
  void operator-=(const __SWORD__ &i) { operator=(*this - i); }
  void operator*=(const __SWORD__ &i) { operator=(*this * i); }
  void operator/=(const __SWORD__ &i);

  void operator+=(const __UWORD__ &i) { operator=(*this + i); }
  void operator-=(const __UWORD__ &i) { operator=(*this - i); }
  void operator*=(const __UWORD__ &i) { operator=(*this * i); }
  void operator/=(const __UWORD__ &i);

  void operator+=(const __USWORD__ &i) { operator=(*this + i); }
  void operator-=(const __USWORD__ &i) { operator=(*this - i); }
  void operator*=(const __USWORD__ &i) { operator=(*this * i); }
  void operator/=(const __USWORD__ &i);

  void operator+=(const __SBYTE__ &i) { operator=(*this + (__ULWORD__)i); }
  void operator-=(const __SBYTE__ &i) { operator=(*this - (__ULWORD__)i); }
  void operator*=(const __SBYTE__ &i) { operator=(*this * (__ULWORD__)i); }
  void operator/=(const __SBYTE__ &i);

  void operator+=(const __UBYTE__ &i) { operator=(*this + (__ULWORD__)i); }
  void operator-=(const __UBYTE__ &i) { operator=(*this - (__ULWORD__)i); }
  void operator*=(const __UBYTE__ &i) { operator=(*this * (__ULWORD__)i); }
  void operator/=(const __UBYTE__ &i);

public: // Comparison operators
  friend int operator==(const UINT32 &a, const UINT32 &b);
  friend int operator==(const UINT32 &a, const __LWORD__ &bl);
  friend int operator==(const __LWORD__ &al, const UINT32 &b);
  friend int operator==(const UINT32 &a, const __ULWORD__ &bl);
  friend int operator==(const __ULWORD__ &al, const UINT32 &b);
  friend int operator==(const UINT32 &a, const __WORD__ &bl);
  friend int operator==(const __WORD__ &al, const UINT32 &b);
  friend int operator==(const UINT32 &a, const __SWORD__ &bl);
  friend int operator==(const __SWORD__ &al, const UINT32 &b);
  friend int operator==(const UINT32 &a, const __UWORD__ &bl);
  friend int operator==(const __UWORD__ &al, const UINT32 &b);
  friend int operator==(const UINT32 &a, const __USWORD__ &bl);
  friend int operator==(const __USWORD__ &al, const UINT32 &b);
  friend int operator==(const UINT32 &a, const __SBYTE__ &bl);
  friend int operator==(const __SBYTE__ &al, const UINT32 &b);
  friend int operator==(const UINT32 &a, const __UBYTE__ &bl);
  friend int operator==(const __UBYTE__ &al, const UINT32 &b);

  friend int operator!=(const UINT32 &a, const UINT32 &b);
  friend int operator!=(const UINT32 &a, const __LWORD__ &bl);
  friend int operator!=(const __LWORD__ &al, const UINT32 &b);
  friend int operator!=(const UINT32 &a, const __ULWORD__ &bl);
  friend int operator!=(const __ULWORD__ &al, const UINT32 &b);
  friend int operator!=(const UINT32 &a, const __WORD__ &bl);
  friend int operator!=(const __WORD__ &al, const UINT32 &b);
  friend int operator!=(const UINT32 &a, const __SWORD__ &bl);
  friend int operator!=(const __SWORD__ &al, const UINT32 &b);
  friend int operator!=(const UINT32 &a, const __UWORD__ &bl);
  friend int operator!=(const __UWORD__ &al, const UINT32 &b);
  friend int operator!=(const UINT32 &a, const __USWORD__ &bl);
  friend int operator!=(const __USWORD__ &al, const UINT32 &b);
  friend int operator!=(const UINT32 &a, const __SBYTE__ &bl);
  friend int operator!=(const __SBYTE__ &al, const UINT32 &b);
  friend int operator!=(const UINT32 &a, const __UBYTE__ &bl);
  friend int operator!=(const __UBYTE__ &al, const UINT32 &b);

  friend int operator<(const UINT32 &a, const UINT32 &b);
  friend int operator<(const UINT32 &a, const __LWORD__ &bl);
  friend int operator<(const __LWORD__ &al, const UINT32 &b);
  friend int operator<(const UINT32 &a, const __ULWORD__ &bl);
  friend int operator<(const __ULWORD__ &al, const UINT32 &b);
  friend int operator<(const UINT32 &a, const __WORD__ &bl);
  friend int operator<(const __WORD__ &al, const UINT32 &b);
  friend int operator<(const UINT32 &a, const __SWORD__ &bl);
  friend int operator<(const __SWORD__ &al, const UINT32 &b);
  friend int operator<(const UINT32 &a, const __UWORD__ &bl);
  friend int operator<(const __UWORD__ &al, const UINT32 &b);
  friend int operator<(const UINT32 &a, const __USWORD__ &bl);
  friend int operator<(const __USWORD__ &al, const UINT32 &b);
  friend int operator<(const UINT32 &a, const __SBYTE__ &bl);
  friend int operator<(const __SBYTE__ &al, const UINT32 &b);
  friend int operator<(const UINT32 &a, const __UBYTE__ &bl);
  friend int operator<(const __UBYTE__ &al, const UINT32 &b);

  friend int operator>(const UINT32 &a, const UINT32 &b);
  friend int operator>(const UINT32 &a, const __LWORD__ &bl);
  friend int operator>(const __LWORD__ &al, const UINT32 &b);
  friend int operator>(const UINT32 &a, const __ULWORD__ &bl);
  friend int operator>(const __ULWORD__ &al, const UINT32 &b);
  friend int operator>(const UINT32 &a, const __WORD__ &bl);
  friend int operator>(const __WORD__ &al, const UINT32 &b);
  friend int operator>(const UINT32 &a, const __SWORD__ &bl);
  friend int operator>(const __SWORD__ &al, const UINT32 &b);
  friend int operator>(const UINT32 &a, const __UWORD__ &bl);
  friend int operator>(const __UWORD__ &al, const UINT32 &b);
  friend int operator>(const UINT32 &a, const __USWORD__ &bl);
  friend int operator>(const __USWORD__ &al, const UINT32 &b);
  friend int operator>(const UINT32 &a, const __SBYTE__ &bl);
  friend int operator>(const __SBYTE__ &al, const UINT32 &b);
  friend int operator>(const UINT32 &a, const __UBYTE__ &bl);
  friend int operator>(const __UBYTE__ &al, const UINT32 &b);

  friend int operator<=(const UINT32 &a, const UINT32 &b);
  friend int operator<=(const UINT32 &a, const __LWORD__ &bl);
  friend int operator<=(const __LWORD__ &al, const UINT32 &b);
  friend int operator<=(const UINT32 &a, const __ULWORD__ &bl);
  friend int operator<=(const __ULWORD__ &al, const UINT32 &b);
  friend int operator<=(const UINT32 &a, const __WORD__ &bl);
  friend int operator<=(const __WORD__ &al, const UINT32 &b);
  friend int operator<=(const UINT32 &a, const __SWORD__ &bl);
  friend int operator<=(const __SWORD__ &al, const UINT32 &b);
  friend int operator<=(const UINT32 &a, const __UWORD__ &bl);
  friend int operator<=(const __UWORD__ &al, const UINT32 &b);
  friend int operator<=(const UINT32 &a, const __USWORD__ &bl);
  friend int operator<=(const __USWORD__ &al, const UINT32 &b);
  friend int operator<=(const UINT32 &a, const __SBYTE__ &bl);
  friend int operator<=(const __SBYTE__ &al, const UINT32 &b);
  friend int operator<=(const UINT32 &a, const __UBYTE__ &bl);
  friend int operator<=(const __UBYTE__ &al, const UINT32 &b);

  friend int operator>=(const UINT32 &a, const UINT32 &b);
  friend int operator>=(const UINT32 &a, const __LWORD__ &bl);
  friend int operator>=(const __LWORD__ &al, const UINT32 &b);
  friend int operator>=(const UINT32 &a, const __ULWORD__ &bl);
  friend int operator>=(const __ULWORD__ &al, const UINT32 &b);
  friend int operator>=(const UINT32 &a, const __WORD__ &bl);
  friend int operator>=(const __WORD__ &al, const UINT32 &b);
  friend int operator>=(const UINT32 &a, const __SWORD__ &bl);
  friend int operator>=(const __SWORD__ &al, const UINT32 &b);
  friend int operator>=(const UINT32 &a, const __UWORD__ &bl);
  friend int operator>=(const __UWORD__ &al, const UINT32 &b);
  friend int operator>=(const UINT32 &a, const __USWORD__ &bl);
  friend int operator>=(const __USWORD__ &al, const UINT32 &b);
  friend int operator>=(const UINT32 &a, const __SBYTE__ &bl);
  friend int operator>=(const __SBYTE__ &al, const UINT32 &b);
  friend int operator>=(const UINT32 &a, const __UBYTE__ &bl);
  friend int operator>=(const __UBYTE__ &al, const UINT32 &b);
  
private:
  __UBYTE__ byte[4];
};

#endif // __UINT32_HPP
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
