// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: treeprt.h
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 01/23/1997 
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Tree printing functions used to debug the code that works with
(R)ed (B)lack binary search trees.   
*/
// ----------------------------------------------------------- //   
#ifndef __TREEPRT_HPP
#define __TREEPRT_HPP

#include "bnodeb.h"
#include "bnode.h"
#include "rbnode.h"

// PrtFunc is a pointer to void(BNodeBase *Node) which
// points to a function used for the print action
typedef void (*PrtFunc)(BNodeBase *n);

// NodeWidthFunc is a pointer to int(BNodeBase *Node) which 
// points to a function used to return the printing width
// of a node
typedef int (*NodeWidthFunc)(BNodeBase *n);

template<class TYPE>
class PrtClass
{
public:
  static void PrtNode(BNodeBase *n) { cout << ((BNode<TYPE> *)n)->Data; }

  static void PrtNodeWSpace(BNodeBase *n) {
    cout << ((BNode<TYPE> *)n)->Data << ' ';
  }

  static void PrtRBNodeWSpace(BNodeBase *n) {
    cout << ((RBNode<TYPE> *)n)->Data << ' '; }
 
  static void PrtRBNode(BNodeBase *n);
  static int NodeWidth(BNodeBase *n);
  static int RBNodeWidth(BNodeBase *n);

private:
  // No Data
};

class BNodeXY : public BNodeBase
{
public:
  BNodeXY *GetLeft() { return (BNodeXY *)Left; }
  BNodeXY *GetRight() { return (BNodeXY *)Right; }

public:
  int x, y;
};

template<class TYPE>
inline void PrtClass<TYPE>::PrtRBNode(BNodeBase *n)
{
  RBNode<TYPE> *p = (RBNode<TYPE> *)n;
  cout << p->Data;
  if (p->color == RedNode) cout << "-RED"; else cout << "-BLACK";
}

// Standalone functions that operate on BNodeBase pointers.
// This implementation provides maximum code sharing.
void PrintUp(BNodeBase *root, PrtFunc PrtNode, NodeWidthFunc NodeWidth);
void PrintSideWays(BNodeBase *t, PrtFunc PrtNode, int inc, int space=0);
void TestTraversals(BNodeBase *root, VisitFunc Visit);
void TestTraversalsII(BNodeBase *root, VisitFunc Visit);

#endif // __TREEPRT_HPP
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
