// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: persist.h 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer    
// File Creation Date: 09/18/1997  
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The (P)ersistent base class is used to define the interface 
that makes the object persistent. 

Changes: 
================================================================
01/20/1998 - Added overloaded versions of the StringFileLength(),
WriteString(), and ReadString() functions used to operate on
low level c strings.
Added by: Doug Gaer

02/04/1998: Added pure virtual functions Delete() and Remove.
These functions must be defined in the derived class.
Added by: Doug Gaer

02/04/1998: Modifed DeleteObject and RemoveObject functions to
work with the Delete() and Remove() functions defined in the
derived class.
Changed by: Doug Gaer

02/04/1998: Added new functions to work with index files.
Added by: Doug Gaer

09/21/1998: Changed null_byte in all versions of WriteString()
to 0 instead of '\0' because the null character is not a valid
binary number.
Changed by: Doug Gaer

10/02/1998: Modified WriteObjHeader(), ReadObjHeader(),
WriteString(), and ReadString() functions to use the
current file address as a default argument.
Changed by: Doug Gaer

10/09/1998: Modified the AddKey() and RemoveKey() functions to
flush the Btree cache after each insertion or deletion by
default.
Changed by: Doug Gaer
================================================================
*/
// ----------------------------------------------------------- //   
#ifndef __PERSIST_HPP
#define __PERSIST_HPP

#include "pod.h"

// (O)bject (H)eader (8 bytes total)
struct ObjectHeader
{
  INT32 ClassID;    // Class Identification number (4 bytes)
  FAU ObjectID;     // Object Identification number (4 bytes)
};

// (P)ersistent base class
class Persistent
{
public:
  Persistent(POD *DB) { Connect(DB); objectaddress = 0; }
  Persistent(const POD *DB) { Connect(DB); objectaddress = 0; }
  Persistent() { pod = 0; } 

private:
  Persistent(const Persistent &ob) { } // Disallow coping
  void operator=(const Persistent &ob) { } // Disallow assignment
  
protected: // Derived class interface
  virtual INT32 GetClassID() const = 0;
  virtual const char *GetClassName() = 0;
  virtual FAU Write() = 0;
  virtual void Read(FAU Address) = 0;
  virtual FAU Find() = 0;
  virtual __UWORD__ ObjectLength() = 0;
  virtual FAU GetObjectAddress() = 0;
  virtual void SetObjectAddress(FAU addr) = 0;

  // 02/04/1998: Added to work with index files
  virtual FAU Delete() = 0; // Mark object deleted keeping data intact
  virtual FAU Remove() = 0; // Permanently remove object from data file 
  
public:
  // Override these functions only if an index file is used
  virtual int CompareIndex();
  virtual int RebuildIndexFile(const char *fname);
  
protected:
  void WriteObjHeader(const ObjectHeader &oh, FAU addr = CurrAddress);
  void ReadObjHeader(ObjectHeader &oh, FAU addr = CurrAddress);
  void Connect(POD *DB); // Connects persistent class to open database
  void Connect(const POD *DB);
  __UWORD__ StringFileLength(const UString &s); // Length of string in file
  __UWORD__ StringFileLength(const char *s);
  __UWORD__ StringFileLength(char *s); 
  void WriteString(const UString &s, FAU addr = CurrAddress);
  void WriteString(const char *s, FAU addr = CurrAddress);
  void WriteString(char *s, FAU addr = CurrAddress);
  void ReadString(UString &s, FAU addr = CurrAddress);
  char *ReadString(FAU addr = CurrAddress);

protected: // Index file functions
  int AddKey(EntryKey &key, int flush = 1);
  int Persistent::FindKey(EntryKey &key, int full_search = 0);
  int Persistent::RemoveKey(EntryKey &key, int flush = 1);
  
public: // User interface
  FAU AddObject(int find = 1);
  void ReadObject(FAU addr) { Read(addr); }
  FAU FindObject() { return Find(); }
  FAU ObjectAddress(int find = 1);
  void DeleteObject(FAU addr);
  void RemoveObject(FAU addr);
  
  // 02/04/1998: These functions have been modified to
  // work with index files. The Delete() and Remove()
  // functions must be defined in the derived class.
  FAU DeleteObject() { return Delete(); }
  FAU RemoveObject() { return Remove(); }

public: // Index file functions
  int UsingIndex() { return pod->UsingIndex(); }
  int UsingIndex() const { return pod->UsingIndex(); }
  int RebuildIndex() { return pod->RebuildIndex(); }
  int RebuildIndex() const { return pod->RebuildIndex(); }
  
protected:
  POD *pod;
  FAU objectaddress;
};

#endif // __PERSIST_HPP
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
