// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: float64.h 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/12/1997  
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The FLOAT64 class is used to represent 64 bit signed double
precision floating point values independently of the operating
system or hardware platform used. It works by separating a 64-bit
value into eight separate byte values and reordering the bytes
highest-order to lowest-order. A FLOAT64 type has a positive
limit of 1.7E+308 and a negative limit of 1.7E-308 with 15-digit
precision. NOTE: In order to maintain the correct byte ordering
on PC based, Intel x86 family, systems the __X86__ macro must be
defined at compile time.

In a double precision floating point number, the binary info is
stored within a total of 64 bits. The first bit contains the sign
of the mantissa (0 for positive and 1 for negative). The next 11
bits store the exponent, and the remaining 52 bits provide the
mantissa, giving an approximate decimal precision of 15 digits.
*/
// ----------------------------------------------------------- //   
#ifndef __FLOAT64_HPP
#define __FLOAT64_HPP

#include "dtypes.h"

// Data structure for signed double precision floating point values.
class FLOAT64
{
public:
  FLOAT64(__DPFLOAT__ val = 0);
  FLOAT64(const FLOAT64& ob);
  FLOAT64& operator=(const FLOAT64& ob);
  FLOAT64& operator=(const __DPFLOAT__ ob);

public:
  void UnPackBits(__DPFLOAT__ val);
  __DPFLOAT__ PackBits() const;
  
public:
  operator __DPFLOAT__() const;

public: // Arithmetic operators that modify their operand
  FLOAT64 operator++(int);  // Postfix
  FLOAT64 operator--(int);  // Postfix
  FLOAT64 &operator++() { operator=(*this + 1); return *this; } // Prefix
  FLOAT64 &operator--() { operator=(*this - 1); return *this; } // Prefix
  void operator+=(const FLOAT64 &fp) { operator=(*this + fp); }
  void operator-=(const FLOAT64 &fp) { operator=(*this - fp); }
  void operator*=(const FLOAT64 &fp) { operator=(*this * fp); }
  void operator/=(const FLOAT64 &fp);

  void operator+=(const __DPFLOAT__ &fp) { operator=(*this + fp); }
  void operator-=(const __DPFLOAT__ &fp) { operator=(*this - fp); }
  void operator*=(const __DPFLOAT__ &fp) { operator=(*this * fp); }
  void operator/=(const __DPFLOAT__ &fp);
  
  void operator+=(const __LWORD__ &i) { operator=(*this + i); }
  void operator-=(const __LWORD__ &i) { operator=(*this - i); }
  void operator*=(const __LWORD__ &i) { operator=(*this * i); }
  void operator/=(const __LWORD__ &i);

  void operator+=(const __ULWORD__ &i) { operator=(*this + i); }
  void operator-=(const __ULWORD__ &i) { operator=(*this - i); }
  void operator*=(const __ULWORD__ &i) { operator=(*this * i); }
  void operator/=(const __ULWORD__ &i);

  void operator+=(const __WORD__ &i) { operator=(*this + i); }
  void operator-=(const __WORD__ &i) { operator=(*this - i); }
  void operator*=(const __WORD__ &i) { operator=(*this * i); }
  void operator/=(const __WORD__ &i);

  void operator+=(const __SWORD__ &i) { operator=(*this + i); }
  void operator-=(const __SWORD__ &i) { operator=(*this - i); }
  void operator*=(const __SWORD__ &i) { operator=(*this * i); }
  void operator/=(const __SWORD__ &i);

  void operator+=(const __UWORD__ &i) { operator=(*this + i); }
  void operator-=(const __UWORD__ &i) { operator=(*this - i); }
  void operator*=(const __UWORD__ &i) { operator=(*this * i); }
  void operator/=(const __UWORD__ &i);

  void operator+=(const __USWORD__ &i) { operator=(*this + i); }
  void operator-=(const __USWORD__ &i) { operator=(*this - i); }
  void operator*=(const __USWORD__ &i) { operator=(*this * i); }
  void operator/=(const __USWORD__ &i);

  void operator+=(const __SBYTE__ &i) { operator=(*this + (__DPFLOAT__)i); }
  void operator-=(const __SBYTE__ &i) { operator=(*this - (__DPFLOAT__)i); }
  void operator*=(const __SBYTE__ &i) { operator=(*this * (__DPFLOAT__)i); }
  void operator/=(const __SBYTE__ &i);

  void operator+=(const __UBYTE__ &i) { operator=(*this + (__DPFLOAT__)i); }
  void operator-=(const __UBYTE__ &i) { operator=(*this - (__DPFLOAT__)i); }
  void operator*=(const __UBYTE__ &i) { operator=(*this * (__DPFLOAT__)i); }
  void operator/=(const __UBYTE__ &i);

public: // Comparison operators
  friend int operator==(const FLOAT64 &a, const FLOAT64 &b);
  friend int operator==(const FLOAT64 &a, const __DPFLOAT__ &bf);
  friend int operator==(const __DPFLOAT__ &af, const FLOAT64 &b);
  friend int operator==(const FLOAT64 &a, const __LWORD__ &bl);
  friend int operator==(const __LWORD__ &al, const FLOAT64 &b);
  friend int operator==(const FLOAT64 &a, const __ULWORD__ &bl);
  friend int operator==(const __ULWORD__ &al, const FLOAT64 &b);
  friend int operator==(const FLOAT64 &a, const __WORD__ &bl);
  friend int operator==(const __WORD__ &al, const FLOAT64 &b);
  friend int operator==(const FLOAT64 &a, const __SWORD__ &bl);
  friend int operator==(const __SWORD__ &al, const FLOAT64 &b);
  friend int operator==(const FLOAT64 &a, const __UWORD__ &bl);
  friend int operator==(const __UWORD__ &al, const FLOAT64 &b);
  friend int operator==(const FLOAT64 &a, const __USWORD__ &bl);
  friend int operator==(const __USWORD__ &al, const FLOAT64 &b);
  friend int operator==(const FLOAT64 &a, const __SBYTE__ &bl);
  friend int operator==(const __SBYTE__ &al, const FLOAT64 &b);
  friend int operator==(const FLOAT64 &a, const __UBYTE__ &bl);
  friend int operator==(const __UBYTE__ &al, const FLOAT64 &b);

  friend int operator!=(const FLOAT64 &a, const FLOAT64 &b);
  friend int operator!=(const FLOAT64 &a, const __DPFLOAT__ &bf);
  friend int operator!=(const __DPFLOAT__ &af, const FLOAT64 &b);
  friend int operator!=(const FLOAT64 &a, const __LWORD__ &bl);
  friend int operator!=(const __LWORD__ &al, const FLOAT64 &b);
  friend int operator!=(const FLOAT64 &a, const __ULWORD__ &bl);
  friend int operator!=(const __ULWORD__ &al, const FLOAT64 &b);
  friend int operator!=(const FLOAT64 &a, const __WORD__ &bl);
  friend int operator!=(const __WORD__ &al, const FLOAT64 &b);
  friend int operator!=(const FLOAT64 &a, const __SWORD__ &bl);
  friend int operator!=(const __SWORD__ &al, const FLOAT64 &b);
  friend int operator!=(const FLOAT64 &a, const __UWORD__ &bl);
  friend int operator!=(const __UWORD__ &al, const FLOAT64 &b);
  friend int operator!=(const FLOAT64 &a, const __USWORD__ &bl);
  friend int operator!=(const __USWORD__ &al, const FLOAT64 &b);
  friend int operator!=(const FLOAT64 &a, const __SBYTE__ &bl);
  friend int operator!=(const __SBYTE__ &al, const FLOAT64 &b);
  friend int operator!=(const FLOAT64 &a, const __UBYTE__ &bl);
  friend int operator!=(const __UBYTE__ &al, const FLOAT64 &b);

  friend int operator<(const FLOAT64 &a, const FLOAT64 &b);
  friend int operator<(const FLOAT64 &a, const __DPFLOAT__ &bf);
  friend int operator<(const __DPFLOAT__ &af, const FLOAT64 &b);
  friend int operator<(const FLOAT64 &a, const __LWORD__ &bl);
  friend int operator<(const __LWORD__ &al, const FLOAT64 &b);
  friend int operator<(const FLOAT64 &a, const __ULWORD__ &bl);
  friend int operator<(const __ULWORD__ &al, const FLOAT64 &b);
  friend int operator<(const FLOAT64 &a, const __WORD__ &bl);
  friend int operator<(const __WORD__ &al, const FLOAT64 &b);
  friend int operator<(const FLOAT64 &a, const __SWORD__ &bl);
  friend int operator<(const __SWORD__ &al, const FLOAT64 &b);
  friend int operator<(const FLOAT64 &a, const __UWORD__ &bl);
  friend int operator<(const __UWORD__ &al, const FLOAT64 &b);
  friend int operator<(const FLOAT64 &a, const __USWORD__ &bl);
  friend int operator<(const __USWORD__ &al, const FLOAT64 &b);
  friend int operator<(const FLOAT64 &a, const __SBYTE__ &bl);
  friend int operator<(const __SBYTE__ &al, const FLOAT64 &b);
  friend int operator<(const FLOAT64 &a, const __UBYTE__ &bl);
  friend int operator<(const __UBYTE__ &al, const FLOAT64 &b);

  friend int operator>(const FLOAT64 &a, const FLOAT64 &b);
  friend int operator>(const FLOAT64 &a, const __DPFLOAT__ &bf);
  friend int operator>(const __DPFLOAT__ &af, const FLOAT64 &b);
  friend int operator>(const FLOAT64 &a, const __LWORD__ &bl);
  friend int operator>(const __LWORD__ &al, const FLOAT64 &b);
  friend int operator>(const FLOAT64 &a, const __ULWORD__ &bl);
  friend int operator>(const __ULWORD__ &al, const FLOAT64 &b);
  friend int operator>(const FLOAT64 &a, const __WORD__ &bl);
  friend int operator>(const __WORD__ &al, const FLOAT64 &b);
  friend int operator>(const FLOAT64 &a, const __SWORD__ &bl);
  friend int operator>(const __SWORD__ &al, const FLOAT64 &b);
  friend int operator>(const FLOAT64 &a, const __UWORD__ &bl);
  friend int operator>(const __UWORD__ &al, const FLOAT64 &b);
  friend int operator>(const FLOAT64 &a, const __USWORD__ &bl);
  friend int operator>(const __USWORD__ &al, const FLOAT64 &b);
  friend int operator>(const FLOAT64 &a, const __SBYTE__ &bl);
  friend int operator>(const __SBYTE__ &al, const FLOAT64 &b);
  friend int operator>(const FLOAT64 &a, const __UBYTE__ &bl);
  friend int operator>(const __UBYTE__ &al, const FLOAT64 &b);

  friend int operator<=(const FLOAT64 &a, const FLOAT64 &b);
  friend int operator<=(const FLOAT64 &a, const __DPFLOAT__ &bf);
  friend int operator<=(const __DPFLOAT__ &af, const FLOAT64 &b);
  friend int operator<=(const FLOAT64 &a, const __LWORD__ &bl);
  friend int operator<=(const __LWORD__ &al, const FLOAT64 &b);
  friend int operator<=(const FLOAT64 &a, const __ULWORD__ &bl);
  friend int operator<=(const __ULWORD__ &al, const FLOAT64 &b);
  friend int operator<=(const FLOAT64 &a, const __WORD__ &bl);
  friend int operator<=(const __WORD__ &al, const FLOAT64 &b);
  friend int operator<=(const FLOAT64 &a, const __SWORD__ &bl);
  friend int operator<=(const __SWORD__ &al, const FLOAT64 &b);
  friend int operator<=(const FLOAT64 &a, const __UWORD__ &bl);
  friend int operator<=(const __UWORD__ &al, const FLOAT64 &b);
  friend int operator<=(const FLOAT64 &a, const __USWORD__ &bl);
  friend int operator<=(const __USWORD__ &al, const FLOAT64 &b);
  friend int operator<=(const FLOAT64 &a, const __SBYTE__ &bl);
  friend int operator<=(const __SBYTE__ &al, const FLOAT64 &b);
  friend int operator<=(const FLOAT64 &a, const __UBYTE__ &bl);
  friend int operator<=(const __UBYTE__ &al, const FLOAT64 &b);

  friend int operator>=(const FLOAT64 &a, const FLOAT64 &b);
  friend int operator>=(const FLOAT64 &a, const __DPFLOAT__ &bf);
  friend int operator>=(const __DPFLOAT__ &af, const FLOAT64 &b);
  friend int operator>=(const FLOAT64 &a, const __LWORD__ &bl);
  friend int operator>=(const __LWORD__ &al, const FLOAT64 &b);
  friend int operator>=(const FLOAT64 &a, const __ULWORD__ &bl);
  friend int operator>=(const __ULWORD__ &al, const FLOAT64 &b);
  friend int operator>=(const FLOAT64 &a, const __WORD__ &bl);
  friend int operator>=(const __WORD__ &al, const FLOAT64 &b);
  friend int operator>=(const FLOAT64 &a, const __SWORD__ &bl);
  friend int operator>=(const __SWORD__ &al, const FLOAT64 &b);
  friend int operator>=(const FLOAT64 &a, const __UWORD__ &bl);
  friend int operator>=(const __UWORD__ &al, const FLOAT64 &b);
  friend int operator>=(const FLOAT64 &a, const __USWORD__ &bl);
  friend int operator>=(const __USWORD__ &al, const FLOAT64 &b);
  friend int operator>=(const FLOAT64 &a, const __SBYTE__ &bl);
  friend int operator>=(const __SBYTE__ &al, const FLOAT64 &b);
  friend int operator>=(const FLOAT64 &a, const __UBYTE__ &bl);
  friend int operator>=(const __UBYTE__ &al, const FLOAT64 &b);
  
private:
  __SBYTE__ byte[8];
};

#endif // __FLOAT64_HPP
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
