// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: ehandler.h
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer    
// File Creation Date: 02/14/1996  
// Date Last Modified: 03/30/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The Ehandler class is used to catch program exceptions that
occur at run-time. This implementation can be used with or
without C++ built-in exception handling. If C++ exception
handling is not enabled with the CPP_EXCEPTIONS macro, then
the EHandler class can be used to display program errors,
exit the program, or trap a program error with a user defined
Action Function.

Changes: 
================================================================
12/16/1997 - Combined the Console, Curses, and wxWindows version,
using the CONSOLE, CURSES, and wxWINDOWS macros to conditionally
compile.
Added by: Doug Gaer

12/16/1997 - Added the wxincs.h file for wxWindows include files.
Added by: Doug Gaer

02/04/1998 - Added CParseError, CNoObjectsExist and CBadClassID
exceptions.
Added by: Doug Gaer

02/06/1998 - Added CSyncError exception.
Added by: Doug Gaer

03/13/1998 - Added CAccessViolation exception.
Added by: Doug Gaer

03/13/1998 - Added CAccessViolation exception.
Added by: Doug Gaer

09/01/1998 - Added CChecksumError exception.
Added by: Doug Gaer

03/30/1999 - Changed the __wxWINDOWS__ macro to __wxWIN168B and
added the __wxWIN201__ macro for wxWindows version 2.0.1
Changed by: Doug Gaer
================================================================
*/
// ----------------------------------------------------------- //   
#ifndef __EHANDLER_HPP
#define __EHANDLER_HPP

// Macro used turn on C++'s exception handling in applications
// #ifndef CPP_EXCEPTIONS
// #define CPP_EXCEPTIONS
// #endif

// Macros used to select display types for error messaging
// ===========================================================
// #ifndef __wxWIN168B__ 
// #define __wxWIN168B__ // wxWindows 1.68B GUI 
// #endif

// #ifndef __wxWIN201__ 
// #define __wxWIN201__ // wxWindows 2.0.1 GUI 
// #endif

// #ifndef __CONSOLE__ 
// #define __CONSOLE__   // Console (stdout) display
// #endif

// #ifndef __CURSES__
// #define __CURSES__    // Curses port for terminal sessions
// #endif
// ===========================================================

const int FatalErrorLevel = 1; // Return value to Operating System
const int DisplayOn = 1;       // Display the exception
const int DisplayOff = 0;      // Do not display the exception
const int MessageCount = 36;   // Number of exception messages

typedef void (*AF)(); // Function pointer for action function

class EHandler
{
public:
  enum { // Exception Handler error codes
    None,              // No exception 
    FileNotReady,      // File not ready (failed or closed file)
    FileNotWriteable,  // Could not write to file 
    ReadOnlyFile,      // Trying to write to read-only file
    FileNotOpenError,  // Trying to use a closed file
    FileCreationError, // Error creating file
    FileOpenError,     // Error opening file
    FileCloseError,    // Error closing file
    FileSeekError,     // Error seeking in file
    FileReadError,     // Error reading file
    FileWriteError,    // Error writing to file
    EOFError,          // Unexpected end of file
    WrongFileType,     // Wrong file type
    FileCorrupt,       // File corrupted
    FileExists,        // File already exists
    NoFileExists,      // No such file exists
    PathError,         // Invalid path
    DanglingPtr,       // Dangling reference counted pointer
    NullPtr,           // Accessing a null pointer 
    CacheFull,         // Cache full
    StkFull,           // Stack full
    StkEmpty,          // Stack empty
    AssertError,       // Assertion failed
    NoDatabaseOpen,    // No database open
    ObjectExists,      // Object already exists
    BadObjectAddress,  // Bad object address
    BadReference,      // Bad Reference
    DivideByZero,      // Divide By Zero Error
    OverFlow,          // Math overflow
    UnderFlow,         // Math under-flow
    ParseError,        // Parse error
    NoObjectsExist,    // No objects exist
    BadClassID,        // Wrong object type
    SyncError,         // Synchronization Error
    AccessViolation,   // Access Violation
    ChecksumError      // Checksum Error
  };

  enum { // Exception Handler error levels
    FATAL = 0x0010,    // Fatal error, terminate program immediately
    DISPLAY = 0x0020   // Dummy handler that does nothing
  };
    
public:
  EHandler() { ExceptionCode = None; }
  virtual ~EHandler();

public:
  virtual void DisplayException();
  virtual void DisplayException(int ECode);

  // Display exception, exit the program, do nothing, or handle exception
  virtual void SignalException 
  (int ECode, int Level = FATAL, int DisplayError = DisplayOn);

  // Display a program message
  virtual void Message
  (const char *mesg1=" ", const char *mesg2=" ", const char *mesg3=" ");
  
  // Exception handler used to handle user defined routines to trap
  // a program error 
  void TrapException(AF ActionFunction);
  
  void SetException(int ECode) { ExceptionCode = ECode; }
  int Exception() { return ExceptionCode; }
  void ClearException() { ExceptionCode = None; }

protected:
  virtual void Terminate();
  int ExceptionCode;  
};

extern EHandler ExceptionHandler;
extern EHandler *Error; // Global exception handler pointer

#ifdef CPP_EXCEPTIONS
// Class declarations for exceptions representing program errors. 
// This implementation is provided for use C++'s built-in exception
// handling routines.
class CNone : public EHandler { };              // No exception
class CFileNotReady : public EHandler { };      // File not ready
class CFileNotWriteable : public EHandler { };  // Could not write to file
class CReadOnlyFile : public EHandler { };      // Writing to read-only file
class CFileNotOpenError : public EHandler { };  // Using a closed file
class CFileCreationError : public EHandler { }; // Error creating file
class CFileOpenError : public EHandler { };     // Error opening file
class CFileCloseError : public EHandler { };    // Error closing file
class CFileSeekError : public EHandler { };     // Error seeking in file
class CFileReadError : public EHandler { };     // Error reading file
class CFileWriteError : public EHandler { };    // Error writing to file
class CEOFError : public EHandler { };          // Unexpected end of file
class CWrongFileType : public EHandler { };     // Wrong file type
class CFileCorrupt : public EHandler { };       // File corrupted
class CFileExists : public EHandler { };        // File already exists
class CNoFileExists : public EHandler { };      // No such file exists
class CPathError : public EHandler { };         // Invalid path
class CDanglingPtr : public EHandler { };       // Dangling ref counted ptr
class CNullPtr : public EHandler { };           // Accessing a Null pointer 
class CCacheFull : public EHandler { };         // Cache full
class CStkFull : public EHandler { };           // Stack full
class CStkEmpty : public EHandler { };          // Stack empty
class CAssertError : public EHandler { };       // Assertion failed
class CNoDatabaseOpen : public EHandler { };    // No database
class CObjectExists : public EHandler { };      // ObjectExists
class CBadObjectAddress : public EHandler { };  // Bad object address
class CBadReference : public EHandler { };      // Bad Reference
class CDivideByZero : public EHandler { };      // Divide By Zero Error
class COverFlow : public EHandler { };          // Math overflow
class CUnderFlow : public EHandler { };         // Math under-flow
class CParseError : public EHandler { };        // Parse error
class CNoObjectsExist : public EHandler { };    // No objects exist
class CBadClassID : public EHandler { };        // Wrong object type
class CSyncError : public EHandler { };         // Synchronization Error
class CAccessViolation : public EHandler { };   // Access Violation
class CChecksumError : public EHandler { };     // Checksum Error
#endif // CPP_EXCEPTIONS

#endif  // __EHANDLER_HPP 
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
