// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: dllist.h
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer
// File Creation Date: 12/29/1996
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

A generic doubly linked list class derived from the DNodeBase
class and the DLListBase class.
*/
// ----------------------------------------------------------- //   
#ifndef __DLLIST_HPP
#define __DLLIST_HPP

#include "dllistb.h"

// (D)oubly Linked List (N)ode class 
template<class TYPE>
class DNode : public DNodeBase
{
public:
  DNode() { } // Implicitly call default constructor for Data
  DNode(const TYPE &X) : Data(X) { } // Call copy constructor

public:
  DNode<TYPE> *GetPrior() { return (DNode<TYPE> *)Prior; }
  const DNode<TYPE> *GetPrior() const { return (DNode<TYPE> *)Prior; }
  DNode<TYPE> *GetNext() { return (DNode<TYPE> *)Next; }
  const DNode<TYPE> *GetNext() const { return (DNode<TYPE> *)Next; }

public:
  TYPE Data;
};

// (D)oubly (L)inked (L)ist class 
template<class TYPE>
class DLList : public DLListBase
{
public:
  DLList() { }
  virtual ~DLList();
  DLList(const DLList<TYPE> &X);
  void operator=(const DLList<TYPE> &X);

public:
  int Copy(const DLList<TYPE> &List);
  int Cat(const DLList<TYPE> &X) { return DLListBase::Cat(X); }
  const DNode<TYPE> *Find(const TYPE &X, const DNode<TYPE> *ptr=0) const;
  DNode<TYPE> *Find(const TYPE &X, DNode<TYPE> *ptr=0);
  int Delete(DNode<TYPE> *Node, TYPE *X = 0);
  int DeleteFront(TYPE *X = 0);
  int DeleteBack(TYPE *X = 0);
  DNode<TYPE> *StoreNode(const TYPE &X);
  DNode<TYPE> *AddToFront(const TYPE &X);
  DNode<TYPE> *AddToBack(const TYPE &X);
  DNode<TYPE> *AddBefore(const TYPE &X, DNode<TYPE> *Node);
  DNode<TYPE> *AddAfter(const TYPE &X, DNode<TYPE> *Node);
  DNode<TYPE> *GetHeader() { return(DNode<TYPE> *) this; }
  const DNode<TYPE> *GetHeader() const { return(DNode<TYPE> *) this; }
  DNode<TYPE> *GetFront() { return(DNode<TYPE> *)DLListBase::GetFront(); }
  DNode<TYPE> *GetBack() { return (DNode<TYPE> *)DLListBase::GetBack(); }
  
  const DNode<TYPE> *GetFront() const { // Read only version
    return(DNode<TYPE> *)DLListBase::GetFront();
  }

  const DNode<TYPE> *GetBack() const { // Read only version
    return (DNode<TYPE> *)DLListBase::GetBack();
  }

  int IsHeader(const DNode<TYPE> *Node) const {
    return DLListBase::IsHeader(Node);
  }
  TYPE *GetFrontNode() {
    DNode<TYPE> *ptr = (DNode<TYPE> *)DLListBase::GetFront();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

  const TYPE *GetFrontNode() const {
    DNode<TYPE> *ptr = (DNode<TYPE> *)DLListBase::GetFront();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

  TYPE *GetBackNode() {
    DNode<TYPE> *ptr = (DNode<TYPE> *)DLListBase::GetBack();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

  const TYPE *GetBackNode() const {
    DNode<TYPE> *ptr = (DNode<TYPE> *)DLListBase::GetBack();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

public:
  void InsertBefore(DNode<TYPE> *A, DNode<TYPE> *B) {
    DLListBase::InsertBefore(A, B);
  }

  void InsertAfter(DNode<TYPE> *A, DNode<TYPE> *B) {
    DLListBase::InsertAfter(A, B);
  }

  void AttachToFront(DNode<TYPE> *Node) {
    DLListBase::AttachToFront(Node);
  }

  void AttachToBack(DNode<TYPE> *Node) {
    DLListBase::AttachToBack(Node);
  }

  DNode<TYPE> *RmvFront() {
    return(DNode<TYPE> *)(DLListBase::RmvFront());
  }

  DNode<TYPE> *Rmv(DNode<TYPE> *Node) {
    return(DNode<TYPE> *)(DLListBase::Rmv(Node));
  }

  DNode<TYPE> *RmvBack() {
    return(DNode<TYPE> *)(DLListBase::RmvBack());
  }

protected:
  virtual DNode<TYPE> *AllocNode(const TYPE &X);
  virtual DNodeBase *DupNode(const DNodeBase *Node);
  virtual void FreeNode(DNodeBase *Node);

public: // Overloaded operators
  int operator+=(const DLList<TYPE> &X) { return Cat(X); }
};

template<class TYPE>
DLList<TYPE>::~DLList()
{
  Clear();
}

template<class TYPE>
DLList<TYPE>::DLList(const DLList<TYPE> &X)
{
  Copy(X);
}

template<class TYPE>
void DLList<TYPE>::operator=(const DLList<TYPE> &X)
{
  Copy(X);
}

template<class TYPE>
int DLList<TYPE>::Copy(const DLList<TYPE> &List)
{
  return DLListBase::Copy(List);
}

template<class TYPE>
DNode<TYPE> *DLList<TYPE>::AllocNode(const TYPE &X)
{
  return new DNode<TYPE>(X);
}

template<class TYPE>
DNodeBase *DLList<TYPE>::DupNode(const DNodeBase *Node)
{
  return AllocNode(((DNode<TYPE> *)Node)->Data);
}

template<class TYPE>
void DLList<TYPE>::FreeNode(DNodeBase *Node)
{
  delete((DNode<TYPE> *)Node);
}

template<class TYPE>
const DNode<TYPE> *DLList<TYPE>::
Find(const TYPE &X, const DNode<TYPE> *ptr) const
// Returns the first node having an element that matched X
{
  if(ptr == 0) ptr = GetFront();

  while(!IsHeader(ptr)) { // Scan until end of list
    if(ptr->Data == X) return ptr; // Match found
    ptr = ptr->GetNext();
  }
  return 0; // No match
}

template<class TYPE>
DNode<TYPE> *DLList<TYPE>::Find(const TYPE &X, DNode<TYPE> *ptr)
// Returns the first node having an element that matched X
{
  if(ptr == 0) ptr = GetFront();

  while(!IsHeader(ptr)) { // Scan until end of list
    if(ptr->Data == X) return ptr; // Match found
    ptr = ptr->GetNext();
  }
  return 0; // No match
}

template<class TYPE>
int DLList<TYPE>::Delete(DNode<TYPE> *Node, TYPE *X)
{
  DNode<TYPE> *ptr = Rmv(Node);
  if(ptr) {
    if(X) *X = ptr->Data; // Copy Data into X if X != 0
    FreeNode(ptr);
    return 1; // Return 1 if successful
  }
  return 0; 
}

template<class TYPE>
int DLList<TYPE>::DeleteFront(TYPE *X)
{
  DNode<TYPE> *ptr = RmvFront();
  if(ptr) {
    if(X) *X = ptr->Data; // Copy Data into X if X != 0
    FreeNode(ptr);
    return 1; // Return 1 if successful
  }
  return 0; 
}

template<class TYPE>
int DLList<TYPE>::DeleteBack(TYPE *X)
{
  DNode<TYPE> *ptr = RmvBack();
  if(ptr) {
    if(X) *X = ptr->Data; // Copy Data into X if X != 0
    FreeNode(ptr);
    return 1; // Return 1 if successful
  }
  return 0; 
}

template<class TYPE>
DNode<TYPE> *DLList<TYPE>::StoreNode(const TYPE &X)
{
  DNode<TYPE> *ptr = AllocNode(X);
  if(ptr) AttachToBack(ptr);
  return ptr; // Return a pointer to the node added
}

template<class TYPE>
DNode<TYPE> *DLList<TYPE>::AddToFront(const TYPE &X)
{
  DNode<TYPE> *ptr = AllocNode(X);
  if(ptr) AttachToFront(ptr);
  return ptr; // Return a pointer to the node added
}

template<class TYPE>
DNode<TYPE> *DLList<TYPE>::AddToBack(const TYPE &X)
{
  DNode<TYPE> *ptr = AllocNode(X);
  if(ptr) AttachToBack(ptr);
  return ptr; // Return a pointer to the node added
}

template<class TYPE>
DNode<TYPE> *DLList<TYPE>::AddBefore(const TYPE &X, DNode<TYPE> *Node)
{
  DNode<TYPE> *ptr = AllocNode(X);
  if(ptr) InsertBefore(Node, ptr);
  return ptr; // Return a pointer to the node added
}

template<class TYPE>
DNode<TYPE> *DLList<TYPE>::AddAfter(const TYPE &X, DNode<TYPE> *Node)
{
  DNode<TYPE> *ptr = AllocNode(X);
  if(ptr) InsertAfter(Node, ptr);
  return ptr; // Return a pointer to the node added
}

#endif  // __DLLIST_HPP 
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
