// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: chlist.h 
// C++ Compiler Used: Microsoft Visual C/C++ 4.2  
// Produced By: Doug Gaer
// File Creation Date: 12/29/1996
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

A character string doubly linked list class derived from the
DNodeBase class and the DLListBase class.
*/
// ----------------------------------------------------------- //   
#ifndef __CHLIST_HPP
#define __CHLIST_HPP

#include "dllistb.h"

// General definition of the concrete data type used
typedef char * DLTYPE;

// (C)haracter (B)ased (D)oubly Linked List (N)ode class 
class ChNode : public DNodeBase
{
public:
  ChNode() { } // Implicitly call default constructor for Data
  ChNode(const DLTYPE &X) : Data(X) { } // Call copy constructor

public:
  ChNode *GetPrior() { return (ChNode *)Prior; }
  const ChNode *GetPrior() const { return (ChNode *)Prior; }
  ChNode *GetNext() { return (ChNode *)Next; }
  const ChNode *GetNext() const { return (ChNode *)Next; }

public:
  DLTYPE Data;
};

// (C)haracter (B)ased (D)oubly (L)inked (L)ist class 
class ChList : public DLListBase
{
public:
  ChList() { }
  virtual ~ChList();
  ChList(const ChList &X) { Copy(X); }
  void operator=(const ChList &X) { Copy(X); }

public:
  int Copy(const ChList &List);
  int Cat(const ChList &X) { return DLListBase::Cat(X); }
  const ChNode  *Find(const DLTYPE &X, const ChNode  *ptr=0) const;
  ChNode *Find(const DLTYPE &X, ChNode  *ptr=0);
  int Delete(ChNode  *Node, DLTYPE *X = 0);
  int DeleteFront(DLTYPE *X = 0);
  int DeleteBack(DLTYPE *X = 0);
  ChNode *Store(const DLTYPE &X);
  ChNode *AddToFront(const DLTYPE &X);
  ChNode *AddToBack(const DLTYPE &X);
  ChNode *AddBefore(const DLTYPE &X, ChNode *Node);
  ChNode *AddAfter(const DLTYPE &X, ChNode *Node);
  ChNode *GetHeader() { return(ChNode *) this; }
  const ChNode *GetHeader() const { return(ChNode *) this; }
  ChNode *GetFront() { return(ChNode *)DLListBase::GetFront(); }
  ChNode *GetBack() { return (ChNode *)DLListBase::GetBack(); }
  
  const ChNode *GetFront() const { // Read only version
    return(ChNode *)DLListBase::GetFront();
  }

  const ChNode *GetBack() const { // Read only version
    return (ChNode *)DLListBase::GetBack();
  }

  int IsHeader(const ChNode *Node) const {
    return DLListBase::IsHeader(Node);
  }
  DLTYPE *GetFrontNode() {
    ChNode *ptr = (ChNode *)DLListBase::GetFront();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

  const DLTYPE *GetFrontNode() const {
    ChNode *ptr = (ChNode *)DLListBase::GetFront();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

  DLTYPE *GetBackNode() {
    ChNode *ptr = (ChNode *)DLListBase::GetBack();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

  const DLTYPE *GetBackNode() const {
    ChNode *ptr = (ChNode *)DLListBase::GetBack();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

public:
  void InsertBefore(ChNode *A, ChNode *B) {
    DLListBase::InsertBefore(A, B);
  }

  void InsertAfter(ChNode *A, ChNode *B) {
    DLListBase::InsertAfter(A, B);
  }

  void AttachToFront(ChNode *Node) {
    DLListBase::AttachToFront(Node);
  }

  void AttachToBack(ChNode *Node) {
    DLListBase::AttachToBack(Node);
  }

  ChNode *RmvFront() {
    return(ChNode *)(DLListBase::RmvFront());
  }

  ChNode *Rmv(ChNode  *Node) {
    return(ChNode *)(DLListBase::Rmv(Node));
  }

  ChNode *RmvBack() {
    return(ChNode *)(DLListBase::RmvBack());
  }

protected:
  virtual ChNode *AllocNode(const DLTYPE &X);
  virtual DNodeBase *DupNode(const DNodeBase *Node);
  virtual void FreeNode(DNodeBase *Node);

public: // Overloaded operators
  int operator+=(const ChList &X) { return Cat(X); }
};

#endif  // __CHLIST_HPP //
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
