// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: cdate.h 
// C++ Compiler Used: Microsoft visual C/C++ version 4.0 
// Produced By: Doug Gaer   
// File Creation Date: 09/21/1997 
// Date Last Modified: 03/15/1999
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The CDate class is used turn a date string into into concrete
data type.
*/
// ----------------------------------------------------------- //   
#ifndef __CDATE_HPP
#define __CDATE_HPP

// Define this macro to use the CPP iostream
// #ifndef __USE_CPP_IOSTREAM__
// #define __USE_CPP_IOSTREAM__
// #endif

#include <iostream.h>
#include "dtypes.h"
#include "uint16.h"

// (C)oncrete (D)ate class
class CDate
{
public:
  CDate() { }
  CDate(__UBYTE__ month, __UBYTE__ day, UINT16 year) {
    Month = month, Day = day, Year = year;
  }
  CDate(const CDate& ob);
  CDate& operator=(const CDate& ob);
  
public:
  void SetDay(__UBYTE__ byte) { Day = byte; }
  void SetMonth(__UBYTE__ byte) { Month = byte; }
  void SetYear(UINT16 uint16) { Year = uint16; }
  void SetDate(__UBYTE__ month, __UBYTE__ day, UINT16 year) {
    Month = month, Day = day, Year = year;
  }
  __UBYTE__ GetDay() { return Day; }
  __UBYTE__ GetMonth() { return Month; }
  UINT16 GetYear() { return Year; }
  char *c_str();
  const char *c_str() const;
  char *month_c_str();
  const char *month_c_str() const;
  char *day_c_str();
  const char *day_c_str() const;
  char *year_c_str();
  const char *year_c_str() const;
  unsigned SizeOf() { return sizeof(Month)+sizeof(Day)+sizeof(Year); }
  
public: // Overloaded operators
  friend int operator==(const CDate &a, const CDate &b);
  friend int operator!=(const CDate &a, const CDate &b);
  friend int operator<(const CDate &a, const CDate &b);
  
public:
#ifdef __USE_CPP_IOSTREAM__
  friend ostream &operator<<(ostream &os, const CDate &ob);
  friend void operator>>(istream &is, CDate &ob);
#endif
  
private:
  __UBYTE__ Month;
  __UBYTE__ Day;
  UINT16 Year;
};

#endif  // __CDATE_HPP
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
