// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: cacheb.h
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/07/1997  
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The Cacheb class is used as a base class for the Cache class. It
incorporates functions that are independent of the bucket type.
The cache is used to handle requests for file-based objects. The
cache must determine whether an object is already loaded. If the
object is not loaded the cache reserves a bucket and loads the
object into memory. This cache design uses cache pointers to
reference cache buckets directly, with each cache pointer being
initialized after the bucket is reserved. The least-recently
reserved cache bucket is overwritten when the cache fills up.
*/
// ----------------------------------------------------------- //   
#ifndef __CACHEB_HPP__
#define __CACHEB_HPP__

#include "vbdfile.h"

class Bucketb; class CachePtrb; // Forward class declarations

// Data independent (C)ache (b)ase class
class Cacheb
{
protected:
  Cacheb(Bucketb *b, int n, unsigned bkt_size);
  virtual ~Cacheb();

protected:
  Bucketb *AcquireBkt();
  Bucketb *FindBkt(FAU Address);
  void MoveToFront(Bucketb *b);

public:
  friend class CachePtrb;
  void Connect(VBDFilePtr &fp) { Clear(); fptr = fp; }
  void Disconnect() { if (fptr) Clear(); fptr = 0; }
  void Flush(int empty_bkts = 0);
  void Clear();
  virtual Bucketb *ReserveBkt(FAU Address, int ensure_loaded=1);
  void FastBind() { FastBinds++; }
  FAU GetHits() { return Hits; }
  FAU GetMisses() { return Misses; }
  FAU GetFastBinds() { return FastBinds; }
  Bucketb *GetHead() { return Head; } 
  int GetBuckets() { return nbuckets; }
  
protected:
  int nbuckets;      // Size of cache
  VBDFilePtr fptr;   // File cache is connected to
  Bucketb *Head;     // Most recently reserved bucket

  // Performance statistics members
  FAU Hits;      // Number of buckets that did not have to be acqiured 
  FAU Misses;    // Number of cache buckets that had to acqiured  
  FAU FastBinds; // Binds to previously allocated, unchanged buckets 
};

#endif // __CACHEB_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
