// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: bucketb.h 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/07/1997  
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The Bucketb class is implemented independently of the data
stored to provide the maximum code sharing. The cache bucket
class is derived from the Bucketb class, creating a family of
classes specific to the data type stored. Both of the cache
bucket classes are used to keep addresses and memory buffers
paired together, to prevent a file-based object's address from
being associated with the wrong memory buffer.

Changes:
================================================================
10/08/1998: Added another version of the SetDirty() function. The
void SetDirty(VBDFile &f) version is used to write the bucket data
immediately to disk instead of waiting for the cache to fill up.
This effectly creates a write-through cache, used in cases where
the delay in writing the bucket data to disk is unacceptable.
Added by: Doug Gaer
*/
// ----------------------------------------------------------- //   
#ifndef __BUCKETB_HPP__
#define __BUCKETB_HPP__

#include "int32.h"

class Cacheb; class CachePtrb; class VBDFile; // Forward declarations

// This typedef is defined in the vbdfile.h file
#ifndef FAU
typedef INT32 FAU; // (F)ile (A)ddress (U)nit, physical file address type
#endif

// Data independent cache (B)ucket (b)ase class
class Bucketb
{
public:
  Bucketb() { } // Other classes initialize buckets

public:
  void Lock() { ++refcnt; }
  void Unlock() { --refcnt; }
  int IsLocked() { return refcnt; }
  void SetDirty() { Dirty = 1; }
  void SetDirty(VBDFile &f) { Dirty = 1; if(Address) Store(f); }
  int IsNull() { return Address == 0; }
  void Release() { refcnt = 0; }
  void Flush(VBDFile &f) { if(Address && Dirty) Store(f); }
  virtual void Fetch(VBDFile &f) = 0; // Depends on bucket data
  virtual void Store(VBDFile &f) = 0; // Depends on bucket data

public: // Functions used for testing and statistics
  FAU GetAddress() { return Address; }
  int GetRefCnt() { return refcnt; }
  char GetDirty() { return Dirty; }
  Bucketb *GetPrior() { return Prior; }
  Bucketb *GetNext() { return Next; }
  
public:
  friend class Cacheb;
  friend class CachePtrb;

protected:
  void MakeNull() { Address = 0; refcnt = 0; Dirty = 0; }

protected:
  FAU Address;    // Location of bucket's data in the file
  int refcnt;     // How many cache pointers pointing to this bucket
  char Dirty;     // True when data doesn't match what's in file
  Bucketb *Prior; // Pointer to adjacent buckets in the cache
  Bucketb *Next;  // Most recently acquired bucket
};

#endif // __BUCKETB_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
