// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: btwalk.h
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/12/1997 
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The BtreeWalk() function defines a generic iterator used to walk
through Balanced multi-way file-base tree class.

Changes:
================================================================
10/08/1998: Modified the BtreeWalk() function to test the Btree 
before walking through it. NOTE: A pointer to the Btree must be
suppiled when calling this function.
Changed by: Doug Gaer

*/
// ----------------------------------------------------------- //   
#ifndef __BTWALK_HPP
#define __BTWALK_HPP

#include "btree.h"
#include "ustring.h"
#include "strutil.h"

// BtreeVisitFunc is a function pointer used for the visit action.
// The visit action defines a procedure used to process node data.
typedef void (*BtreeVisitFunc)(CachePointer Node); 

// This is a recursive function used to walk through the btree.
void BtreeWalk(CachePointer t, BtreeVisitFunc Visit, Btree *tree = 0);

// This class is used as a container to store the entry keys in
// memory with as little overhead as possible.
class InMemCopy
{
public:
  InMemCopy() { }
  ~InMemCopy() { }
  InMemCopy(char *k, INT32 oa, INT32 cid);
  InMemCopy(const InMemCopy &ob);
  void operator=(const InMemCopy &ob);
  
public:
  friend int operator==(const InMemCopy &a, const InMemCopy &b) {
    return Compare(a, b) == 0;
  }
  
  friend int operator!=(const InMemCopy &a, const InMemCopy &b) {
    return Compare(a, b) != 0;
  }
  
  friend int operator>(const InMemCopy &a, const InMemCopy &b) {
    return Compare(a, b) > 0;
  }
  
  friend int operator>=(const InMemCopy &a, const InMemCopy &b) {
    return Compare(a, b) >= 0;
  }
  
  friend int operator<(const InMemCopy &a, const InMemCopy &b) {
    return Compare(a, b) < 0;
  }
  
  friend int operator<=(const InMemCopy &a, const InMemCopy &b) {
    return Compare(a, b) <= 0;
  }
  
  friend int Compare(const InMemCopy &a, const InMemCopy &b);
  
public:
  UString key;          // Unique data key 
  INT32 object_address; // Object's address in the database file
  INT32 class_id;       // Class ID number of the object 
};

#endif // __BTWALK_HPP
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
