// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: btree.h 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/12/1997 
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Balanced multi-way file-base tree class used to create
file-based objects that reside on disk.

Changes:
================================================================
10/08/1998: Added the ReInit() function to allow an application
to flush the cache and reinitialize the Btree. This will ensure
that the memory buffers and the file data stays in sync during
multiple file access and multiple instances of the application. 
Added by: Doug Gaer

10/08/1998: Added the TestTree() functions to ensure that the
memory buffers and the file data stay in sync during multiple
file access.
Added by: Doug Gaer

10/08/1998: Modified all versions of the Search() function to
test the tree before searching.
Changed by: Doug Gaer

10/08/1998: Modified all versions of the FullSearch() function 
to test the tree before searching.
Changed by: Doug Gaer

10/08/1998: Modified the Add() function to flush the disk
buffers and the cache after each insertion by default.
Changed by: Doug Gaer

10/08/1998: Modifed the Remove() function to flush the disk
buffers and the cache after each deletion by default.
Changed by: Doug Gaer
*/
// ----------------------------------------------------------- //   
#ifndef __BTREE_HPP
#define __BTREE_HPP

// NOTE: To avoid portability problems with template classes, enable
// the __NOT_USING_TEMPLATE_CLASS__ macro and directly code the
// Bucket class, Cache class, and the CachePtr class for the data
// type that will be used.

// Default to using template class
#ifndef __NOT_USING_TEMPLATE_CLASS__
#define __USING_TEMPLATE_CLASS__
#endif

#include "vbdfile.h"
#include "cacheptr.h"
#include "mnode.h"

#ifdef __USING_TEMPLATE_CLASS__
typedef CachePtr<Mnode> CachePointer; // Pointer to cache
#endif

#ifdef __NOT_USING_TEMPLATE_CLASS__
#include "cacheptr.h"
typedef CachePtr CachePointer; // Pointer to cache
#endif

// Function return status codes
const int __DUPLKEY__       = -1;
const int __ALLOCERR__      = -2;
const int __NODE_OVERFLOW__ =  2;

// (B)alanced multi-way file-base (T)ree (H)eader stored with every tree
struct BtreeHeader
{ 
  FAU root_addr;
  INT32 order;
  INT32 num_entries;
  INT32 num_nodes;
  INT32 height;
};

// (B)alanced multi-way file-base (T)ree class.
class Btree
{  
public:
  Btree(int CacheSize = 8) : f(0), cache(CacheSize), root(cache) { }
  ~Btree() { Disconnect(); }

public:
  int Connect(VBDFilePtr &fptr, int create, FAU bha=sizeof(FileHeader));
  void Disconnect();
  int Create(char *FName, FAU bha=sizeof(FileHeader));
  int Open(char *FName, VBDFile::AccessMode mode, FAU bha=sizeof(FileHeader));
  void Flush(int clear=0);
  void Close() { Disconnect(); }
  int Search(EntryKey &e);
  int Search(char *key);
  int FullSearch(const EntryKey &e);
  int FullSearch(char *key, FAU object_address, FAU class_id);
  int Add(char *key, FAU object_address = 0, FAU class_id = 0, int flush = 1);
  int Add(EntryKey &e, int flush = 1);
  int Remove(char *k, FAU object_address = 0, FAU class_id = 0, int flush = 1);
  int Remove(EntryKey &e, int flush = 1);
  int IsEmpty() const { return bh.num_entries == 0; }
  int IsOpen() const { return f->IsOpen(); } 
  int IsOK() const { return f->IsOK(); }
  void ClearErr() { f->ClearErr(); }
  FAU GetRootAddr() { return bh.root_addr; }
  INT32 GetOrder() { return bh.order; }
  INT32 GetNumEntries() { return bh.num_entries; }
  INT32 GetNumNodes() { return bh.num_nodes; }
  INT32 GetHeight() { return bh.height; }
  VBDFilePtr GetFilePtr() { return f; }
  FAU GetHeaderAddr() { return bh_addr; }
  CachePointer GetRoot() { return root; }
  void ReInit(int flush = 0);
  int TestTree();
  
#ifdef __USING_TEMPLATE_CLASS__
  Cache<Mnode> *GetCache() { return &cache; }
#endif

#ifdef __NOT_USING_TEMPLATE_CLASS__
  Cache *GetCache() { return &cache; }
#endif

  int operator!() const { return f->operator!(); }
  operator int() const { return f->operator const int(); }
  
protected:
  void ReadHdr(); 
  void WriteHdr();
  int Insert(EntryKey &e, CachePointer t);
  int Delete(EntryKey &e, CachePointer t);
  void RestoreBalance(CachePointer p, int posn);
  void RotateRight(CachePointer p, int posn);
  void RotateLeft(CachePointer p, int posn);
  void Merge(CachePointer p, int posn);

protected:
  VBDFilePtr f;      // File the Btree is connected to
  FAU bh_addr;       // Address of the Btree header
  BtreeHeader bh;    // Btree header
  CachePointer root; // Pointer to the root node
  
#ifdef __USING_TEMPLATE_CLASS__
  Cache<Mnode> cache; // Node cache
#endif

#ifdef __NOT_USING_TEMPLATE_CLASS__
  Cache cache; // Node cache
#endif
};

#endif // __BTREE_HPP
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

