// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: bstree.h
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 01/23/1997 
// Date Last Modified: 03/15/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

This is a generic (B)inary (S)earch (T)ree. A binary search
tree has binary nodes (nodes with no more then two children).
The smaller nodes are stored on the left and larger nodes are
stored on the right.
*/
// ----------------------------------------------------------- //   
#ifndef __BSTREE_HPP
#define __BSTREE_HPP

#include "bstreeb.h"
#include "twalk.h"

// (B)inary (S)earch (T)ree class
template<class TYPE>
class BSTree
{
public:
  BSTree() { Root = 0; }
  virtual ~BSTree() { Clear(); }
  BSTree(const BSTree<TYPE> &t)  { Root = 0; Copy(t); }
  void operator=(const BSTree<TYPE> &t) { if (this != &t) Copy(t); }

public:
  int Copy(const BSTree<TYPE> &Tree);
  int Copy(const BSTree<TYPE> &Tree, WalkOrder w);
  void Clear() { DelTree(Root); Root = 0; }
  BNode<TYPE> *GetMember(const TYPE &X);
  const BNode<TYPE> *GetMember(const TYPE &X) const {
    return ((BSTree<TYPE> *)this)->GetMember(X);
  }
  BNode<TYPE> *Add(const TYPE &X, int &existed);
  BNode<TYPE> *Add(const TYPE &X) { int dmy; return Add(X, dmy); }
  BNode<TYPE> *Detach(const TYPE &X);
  BNode<TYPE> *DetachMin(); 
  BNode<TYPE> *DetachMax();
  int Delete(const TYPE &X);
  void DeleteMin() { FreeNode(DetachMin()); }
  void DeleteMax() { FreeNode(DetachMax()); }
  BNode<TYPE> *GetRoot();
  BNode<TYPE> *GetMin() { return (BNode<TYPE> *)Minimum(Root); }
  BNode<TYPE> *GetMax() { return (BNode<TYPE> *)Maximum(Root); }
  int IsEmpty() const;

protected:
  BNode<TYPE> *SearchP(const TYPE &X, BNode<TYPE> *&p, int &Side);
  BNode<TYPE> *DupTree(BNode<TYPE> *Tree);
  virtual void FreeNode(BNode<TYPE> *n);
  void DelTree(BNode<TYPE> *Tree);

  virtual BNode<TYPE> *AllocNode
      (const TYPE &X, BNode<TYPE> *L=0, BNode<TYPE> *R=0);

protected:
  BNode<TYPE> *Root;
};

template<class TYPE>
BNode<TYPE> *BSTree<TYPE>::GetMember(const TYPE &X)
{
  BNode<TYPE> *Tree = Root;
  while (Tree) {
    if (X == Tree->Data) break;
    Tree = (X < Tree->Data) ? Tree->GetLeft() : Tree->GetRight();
  }
  return Tree; // Return pointer to node containing data X 
}

template<class TYPE>
BSTree<TYPE>::~BSTree()
{
  Clear();
}

template<class TYPE>
BNode<TYPE> *BSTree<TYPE>::
AllocNode(const TYPE &X, BNode<TYPE> *L, BNode<TYPE> *R)
{
  return new BNode<TYPE>(X, L, R);
}

template<class TYPE>
void BSTree<TYPE>::FreeNode(BNode<TYPE> *n)
{
  delete n;
}

template<class TYPE>
BNode<TYPE> *BSTree<TYPE>
::SearchP(const TYPE &X, BNode<TYPE> *&p, int &Side)
// SearchP is used to determine where the node should be added.
// Passes back parent of the node found and which side the child is on.
// (If matching node is the Root, a 0 is returned for p.)
{
  BNode<TYPE> *Tree = Root;
  p = 0;
  while (Tree) {
    // Assumes TYPE has comparison operators defined.
    if (X == Tree->Data) break; 
    p = Tree;
    if (X < Tree->Data) {
       Side = 0;
       Tree = Tree->GetLeft();
    }
    else {
       Side = 1;
       Tree = Tree->GetRight();
    }
  }
  return Tree; // Returns pointer to node containing data X
}

template<class TYPE>
BNode<TYPE> *BSTree<TYPE>::Add(const TYPE &X, int &existed)
{
  BNode<TYPE> *p;
  int Side;

  BNode<TYPE> *Tree = SearchP(X, p, Side);

  if (Tree == 0) { // No matching node found
     Tree = AllocNode(X);
     if(p) {
        if(Side) p->Right = Tree; else p->Left = Tree;
     }
     else Root = Tree; // No parent, so this must be first node
     existed = 0;
  }
  else existed = 1;

  return Tree; // Returns pointer to the new or matching node
}

template<class TYPE>
BNode<TYPE> *BSTree<TYPE>::Detach(const TYPE &X)
{
  int Side;
  BNode<TYPE> *p, *Tree;

  Tree = SearchP(X, p, Side);
  return (BNode<TYPE> *)DetachNode((BNodeBase *&)Root, Tree, p, Side);
}

template<class TYPE>
BNode<TYPE> *BSTree<TYPE>::DetachMin()
{
  BNodeBase *p = ParentOfMinimum(Root);
  if (p && p->Left)
     return (BNode<TYPE> *)DetachNode((BNodeBase *&)Root, p->Left, p, 0);
     else return (BNode<TYPE> *)DetachNode((BNodeBase *&)Root, Root, 0, 0);
}

template<class TYPE>
BNode<TYPE> *BSTree<TYPE>::DetachMax()
{
  BNodeBase *p = ParentOfMaximum(Root);
  if (p && p->Right)
     return (BNode<TYPE> *)DetachNode((BNodeBase *&)Root, p->Right, p, 1);
     else return (BNode<TYPE> *)DetachNode((BNodeBase *&)Root, Root, 0, 0);
}

template<class TYPE>
int BSTree<TYPE>::Delete(const TYPE &X)
{
  BNode<TYPE> *n = Detach(X);
  FreeNode(n);
  return n != 0; // Return 1 if node found, else 0
}

template<class TYPE>
void BSTree<TYPE>::DelTree(BNode<TYPE> *Tree)
{
  if (Tree == 0) return;
  DelTree(Tree->GetLeft());  // Recursive function call 
  DelTree(Tree->GetRight()); // Recursive function call 
  FreeNode(Tree);
}

template<class TYPE>
BNode<TYPE> *BSTree<TYPE>::DupTree(BNode<TYPE> *Tree)
{
  if (Tree == 0) return 0;
  BNode<TYPE> *L = DupTree(Tree->GetLeft());  // Recursive function call 
  BNode<TYPE> *R = DupTree(Tree->GetRight()); // Recursive function call 

  // Return Root of copy, or 0 if could not allocate Root
  return AllocNode(Tree->Data, L, R); 
}

template<class TYPE>
int BSTree<TYPE>::Copy(const BSTree<TYPE> &Tree)
{
  Clear();
  BNode<TYPE> *R = DupTree(Tree.Root);
  if (R) {
     Root = R;
     return 1;
  }
  else return 0;
}

template<class TYPE>
int BSTree<TYPE>::Copy(const BSTree<TYPE> &Tree, WalkOrder w)
{
  Clear();
  TreeWalker< BNode<TYPE> > tw(Tree.Root, w);
  BNode<TYPE> *nxt;
  while(1) {
    nxt = tw.Next();
    if (nxt == 0) break;
    Add(nxt->Data);
  }
  return 1;
}

template<class TYPE>
BNode<TYPE> *BSTree<TYPE>::GetRoot()
{
  return Root;
}

template<class TYPE>
int BSTree<TYPE>::IsEmpty() const
{
  return Root == 0;
}

#endif // __BSTREE_HPP
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
