#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program  
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2 
# Produced By: Doug Gaer
# File Creation Date: 04/14/1997 
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#       GX -- Enable C++ exception handling
#       GR -- Enable C++ Run-Time Type Information
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
VBDFILE_PATH = ../../src/
EHANDLER_PATH = ../../src/
DTYPES_PATH = ../../src/
REFCOUNT_PATH = ../../src/
CRC32_PATH = ../../src/
TIMER_PATH = ../../src/

ADD_INC_PATHS = -I../../include

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = /D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = /D__RECLAIM_FIRST_FIT__ 

# Setup define macros
DEFMACS = /D__X86__ /D__CONSOLE__ /D__DOS_INCLUDES__ \
$(DEF_VB_ALLOC) # /DCPP_EXCEPTIONS

# Define macros for compiler and linker
CC = cl
CPP = cl
LINKER = link

# Define compiler and linker flags macros
CFLAGS= /W3 /Zi /GX $(DEFMACS) $(ADD_INC_PATHS)
COMPILE_ONLY = /c
LFLAGS =  

# Build dependency rules
# ===============================================================
CRC32_DEP = ../../include/crc32.h ../../include/crc32tab.h

EHANDLER_DEP = ../../include/ehandler.h

FLOAT64_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/float64.h 

INT32_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/int32.h

VBDFILE_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/int32.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/crc32.h \
	../../include/uint32.h

VBDSTATS_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/int32.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/crc32.h \
	../../include/uint32.h

UINT32_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/uint32.h

TESTPROG_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/float64.h ../../include/int32.h \
        ../../include/vbdfile.h ../../include/refcount.h \
	../../include/uint32.h llist.h ../../include/timer.h \
	../../include/vbdstats.h

LLIST_DEP = llist.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

ehandler.obj:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

testprog.obj:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

llist.obj:	llist.cpp $(LLIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) llist.cpp

float64.obj:	$(DTYPES_PATH)float64.cpp $(FLOAT64_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)float64.cpp

int32.obj:	$(DTYPES_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)int32.cpp

vbdfile.obj:    $(VBDFILE_PATH)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdfile.cpp

vbdstats.obj:    $(VBDFILE_PATH)vbdstats.cpp $(VBDSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdstats.cpp

uint32.obj:	$(DTYPES_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint32.cpp

crc32.obj:	$(CRC32_PATH)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CRC32_PATH)crc32.cpp

# Make the executable
OBJS = ehandler.obj float64.obj int32.obj vbdfile.obj \
	testprog.obj crc32.obj uint32.obj llist.obj \
	vbdstats.obj
 
$(PROJECT).exe:	$(OBJS)
	$(LINKER) $(LFLAGS) $(OBJS) /OUT:$@ 
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 

	@echo Removing any test files created during program execution
	if exist *.vbd del *.vbd
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


