// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: llist.h 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 04/05/1996 
// Date Last Modified: 03/17/1999
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Simple doubly linked list implementation.
*/
// ----------------------------------------------------------- //   
#ifndef __LLIST_HPP
#define __LLIST_HPP

// Define the data type being used
typedef long listTYPE;

// Doubly linked list base class
class LListB
{
public:
  LListB() { Next =  Prior= 0; info = 0; }
  
public:
  LListB *GetNext() { return Next; }           // Get the next link
  LListB *GetPrior() { return Prior; }         // Get the previous link
  listTYPE Get() { return info; }              // Get the current element
  void Change(listTYPE data) { info = data; }  // Change an element

public:
  listTYPE info;
  LListB *Next;
  LListB *Prior;
};

// Doubly linked list class
class LList : public LListB
{
public:
  LList() { Start = End = 0; }
  ~LList() { Clear(); }

public:
  void Store(listTYPE);        // Store a node
  LListB *Detach(LListB *ptr); // Detach a node from the list
  void Remove(LListB *ptr);    // Detach node and remove from memory
  LListB *Find(listTYPE);      // Returns a pointer to the matching element
  int RmvData(listTYPE info);  // Remove the head of the list and free memory
  void Clear();                // Empty the list
  LListB *GetStart() { return Start; }
  LListB *GetEnd() { return End; }
  
private:
  LListB *Start;
  LListB *End;
};

#endif  // __LLIST_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
