// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: llist.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 04/05/1996 
// Date Last Modified: 03/17/1999
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Simple doubly linked list implementation.
*/
// ----------------------------------------------------------- // 
#include "llist.h"

void LList::Store(listTYPE info)
{
  LListB *prt;

  // Allocate memory for info elements 
  prt = new LListB;

  // Copy info elements into non-contiguous memory
  prt->info = info;

  if(Start == 0) {
    // First element in list
    End = Start = prt;
  }
  else {
    // Put element on the end of the list
    prt->Prior = End;
    End->Next = prt;
    End = prt;
  }
}

void LList::Remove(LListB *ptr)
// Detach node and remove it from memory.
{
  Detach(ptr);
  delete ptr;
}

LListB *LList::Detach(LListB *ptr)
// Detaches a node from the list.
// Returns a pointer to the detached node.
{
  if(ptr->Prior) { // Not deleting first element
    ptr->Prior->Next = ptr->Next;
    if(ptr->Next) // Not deleting last element
      ptr->Next->Prior = ptr->Prior;
    else // Otherwise, we are deleting last element
      End = ptr->Prior; // Update end pointer
  }
  else { // Deleting first element
    if(ptr->Next) { // List not empty
      ptr->Next->Prior = 0;
      Start = ptr->Next;
    }
    else // List is now empty
      Start = End = 0;
  }

  return ptr;
}

LListB *LList::Find(listTYPE info)
// Find a specifed node. This functions assumes that
// listTYPE has its == operator defined.
{
  for(LListB *prt = Start; prt; prt = prt->GetNext())
    if(prt->info == info) return prt; // Found the item

  // Return a NULL if the item is not found
  return 0;
}

int LList::RmvData(listTYPE info)
// Remove Data starting from the head from the list, and set
// next node as the head.
{
  if (Start) {
     info = Start->info;
     LListB *ptr = Start;
     Start = Start->Next;
     delete ptr;
     return 1;
  }
  else return 0;
}

void LList::Clear()
{
  // Remove all nodes from the list.
  listTYPE dmy;
  int r;

  do {
    r = RmvData(dmy);
  } while(r);

  // Reset the Start and End pointers
  Start = End = 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
