// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Author: Doug Gaer 
// File Creation Date: 11/29/1996  
// Date Last Modified: 03/17/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the UString class.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "ustring.h"

void pause()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

main()
{
  cout << "Testing constructors..." << endl;

  UString a("The quick brown fox jumps over the lazy dog");
  cout << a << endl;
  
  UString b;

  UString c("This is a test", 14);
  cout << c << endl;

  cout << "Constructing a substring..." << endl;
  UString d(c, 0, 14);
  cout << d << endl;

  cout << endl;
  cout << "Testing overloaded assignment operators..." << endl;
  b = a;
  cout << b << endl;
  b = c;
  cout << b << endl;
  b = "0123456789";
  cout << b << endl;
  
  cout << endl;
  cout << "Testing copy constructor..." << endl;
  UString aa(a);
  cout << aa << endl;
  UString bb(b);
  cout << bb << endl;

  pause();
  
  cout << "Testing overloaded += operator..." << endl;
  UString buf(" 0123456789");
  a+=buf;
  cout << a << endl;
  c+=" message";
  cout << c << endl;
  c+='X';
  cout << c << endl;

  pause();
  
  cout << "Testing concatenation..." << endl;
  UString s1("String 1"), s2("String 2");
  char *str3 = " and String 3";
  s1.Cat(" and ", 5);
  s1 += s2;
  cout << s1 << endl; 
  s1.Cat(str3);
  cout << s1 << endl;

  pause();
  
  cout << "Testing find functions..." << endl;
  if(s1.Find("xyz") == UString::NoMatch)
    cout << "Pattern not found!" << endl;
  else
    cout << "Pattern found." << endl;

  if(s1.Find(str3, strlen(str3)) == UString::NoMatch)
    cout << "Pattern not found!" << endl;
  else
    cout << "Pattern found." << endl;

  if(s1.Find(s2) == UString::NoMatch)
    cout << "Pattern not found!" << endl;
  else
    cout << "Pattern found." << endl;

  cout << "Testing repeated pattern finding..." << endl;
  s1 = "This is a test message";
  unsigned Offset = 0;
  while(1) {
    Offset = s1.Find("is", Offset);
    if (Offset == UString::NoMatch) break;
    cout << "Pattern match found at index: " << Offset << endl;
    Offset++;
  }

  pause();

  cout << "Testing copy functions..." << endl;
  s1.Copy("The quick brown fox jumps over the lazy dog");
  UString s3("0123456789");
  cout << s1 << endl;
  s1.Copy(s3);
  cout << s1 << endl;
  
  pause();

  cout << "Testing delete function..." << endl;
  UString x1("The quick brown fox jumps over the lazy dog");
  cout << x1 << endl;
  char *xx = "fox";
  int Index = x1.Find(xx);
  cout << "Deleting fox from string..." << endl;
  x1.DeleteAt(Index, strlen(xx));
  cout << x1 << endl;

  pause();
  
  cout << "Testing replace functions..." << endl;
  x1 = "The quick brown fox jumps over the lazy dog";
  cout << x1 << endl;
  char *xy = "cat";
  Index = x1.Find(xx);
  cout << "Replacing fox:" << endl;
  x1.ReplaceAt(Index, xy, strlen(xy));  
  cout << x1 << endl;
  cout << "Replacing jumps:" << endl;
  Index = x1.Find("jumps");
  x1.ReplaceAt(Index, "runs ");
  cout << x1 << endl;
  UString x2("cow");
  cout << "Replacing dog:" << endl;
  Index = x1.Find("dog");
  x1.ReplaceAt(Index, x2);
  cout << x1 << endl;
  
  pause();
  
  cout << "Testing the insert functions..." << endl;
  x1 = "The quick brown fox jumps over the lazy dog";
  cout << x1 << endl;
  char *xz = "and yellow ";
  cout << "Inserting text into string:" << endl;
  Index = x1.Find(xx);
  x1.InsertAt(Index, xz, strlen(xz));
  cout << x1 << endl;
  Index = x1.Find("over");
  x1.InsertAt(Index, "around and ");
  cout << x1 << endl;
  UString x3("cow and ");
  Index = x1.Find("dog");
  x1.InsertAt(Index, x3);
  cout << x1 << endl;
  
  pause();
  
  cout << "Testing fill functions..." << endl;
  UString y1(15,0); // 0 for GrowBy will not allow string to grow
  y1.Fill('Z');
  cout << y1 << endl;
  y1.Fill("0123456789");
  cout << y1 << endl;
  UString y3("TEST");
  y1.Fill(y3);
  cout << y1 << endl;
  
  pause();
  
  cout << "Testing substring functions..." << endl;
  UString z1("The quick brown fox jumps over the lazy dog");
  cout << z1 << endl;
  Index = z1.Find("fox");
  cout << "Testing mid function:" << endl;
  UString Fox = z1.Mid(Index, 3); // 3 bytes for fox
  cout << Fox << endl;
  cout << "Testing left function:" << endl;
  UString The = z1.Left(3); // 3 bytes for the
  cout << The << endl;
  cout << "Testing right function:" << endl;
  UString Dog = z1.Right(3); // 3 bytes for dog
  cout << Dog << endl;
    
  pause();

  cout << "Testing Growth and Null Terminate function..." << endl;
  UString z("This is a test"); // Default GrowBy of 16
  cout << z << endl;
  cout << "String's logical length = " << z.GetLength() << endl;
  cout << "String's allocated length = " << z.GetDimLen() << endl;
  cout << "Changing allocated length..." << endl;
  z.Grow();
  cout << "String's allocated length = " << z.GetDimLen() << endl;
  cout << "Freeing unused allocated space..." << endl;
  z.FreeExtra();
  cout << "String's allocated length = " << z.GetDimLen() << endl;
  cout << "Null terminating string: " << endl;
  cout << z.NullTermStr() << endl;
  cout << "String's allocated length = " << z.GetDimLen() << endl;
  cout << "Freeing unused allocated space..." << endl;
  z.FreeExtra();
  cout << "String's allocated length = " << z.GetDimLen() << endl;
  cout << "Disallowing growth..." << endl;
  cout << "String's logical length = " << z.GetLength() << endl;
  cout << "String's allocated length = " << z.GetDimLen() << endl;
  cout << "Null terminating string: " << endl;
  z.ChgGrowByInc(0); 
  cout << z.NullTermStr() << endl;

  pause();

  cout << "Testing resizing function" << endl;
  UString rs("DOG", 3);
  cout << "String = " << rs.c_str() << endl;
  cout << "String's logical length = " << rs.GetLength() << endl;
  cout << "String's allocated length = " << rs.GetDimLen() << endl;
  cout << "Resizing the string" << endl;
  rs.Resize(24);
  cout << "String's logical length = " << rs.GetLength() << endl;
  cout << "String's allocated length = " << rs.GetDimLen() << endl;

  pause();
  
  cout << "Testing c_str functions" << endl;
  UString gs("COW");
  const UString &cs = gs;
  cout << "String = " << gs.c_str() << endl;
  cout << "Const String = " << cs.c_str() << endl;
  pause();
  
  cout << "Testing overload subscript operator..." << endl;
  char *Message = "This is a test message";
  UString ss(Message);
  for(unsigned i = 0; i < strlen(Message); i++)
    cout << ss[i];
  cout << endl;
  
  pause();
  
  cout << "Testing the comparison functions..." << endl;
  UString x(80), y(80);
  cout << "Enter first string to compare: ";
  cin >> x;
  cout << "Enter second string to compare: ";
  cin >> y;

  UString No = "No";
  UString Yes = "Yes";
  UString NoYes[2] = { No, Yes };
  cout << x << " == " << y << " ? " << NoYes[x == y] << '\n';
  cout << x << " != " << y << " ? " << NoYes[x != y] << '\n';
  cout << x << " >  " << y << " ? " << NoYes[x > y]  << '\n'; 
  cout << x << " >= " << y << " ? " << NoYes[x >= y] << '\n'; 
  cout << x << " <  " << y << " ? " << NoYes[x < y]  << '\n'; 
  cout << x << " <= " << y << " ? " << NoYes[x <= y] << '\n'; 

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
