// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 12/11/1996 
// Date Last Modified: 03/17/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the Sleep(), Start(), Stop(), and
ElapsedSeconds() functions.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <stdlib.h>
#include "timer.h"

main(int argc, char *argv[]) 
{
  clock_t Begin, End;

  if (argc <= 1) {
    cout << "Usage: testprog <time to sleep in seconds>" << endl;
    exit(0);
  }

  int InputBuffer = atoi(argv[1]);
  if (!InputBuffer) {
    cout << "Invalid input." << endl;
    cout << "Usage: testprog <time to sleep in seconds>" << endl;
    exit(0);
  }
    
  cout <<  "Sleeping for " << InputBuffer  << " seconds..." << endl;

  // Get CPU clock cycles
  Begin = Start();

  Sleep((clock_t)InputBuffer);
  
  // Get CPU clock cycles 
  End = Stop();

  cout << "Elapsed time = " << ElapsedSeconds(Begin, End)
       << " seconds" << endl;

  return 0;
} 
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


