// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 01/21/1997 
// Date Last Modified: 03/17/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the generic singly linked list
based stack class.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <ctype.h>
#include "stack.h"
#include "ustring.h"

// Define this macro to use the list function
// #ifndef __USE_LIST__
// #define __USE_LIST__
// #endif

// NOTE: The list function was removed because of compile prblems
// under HPUX 10.24A CPP. To compile with the list function define
// the __USE_LIST__ macro.
#ifdef __USE_LIST__
// This function is for test purposes only
template<class TYPE>
int List(const Stack<TYPE> &X)
{
  if (X.IsEmpty()) {
    cout << "Stack is empty" << endl;
  }
  else {
    const SNode<TYPE> *ptr = (const SNode<TYPE> *)X.GetFront();
    while(!X.IsHeader(ptr)) {
      cout << ptr->Data << endl;
      ptr = ptr->GetNext();
    }
    cout << endl;
  }
  return 1;
}
#endif

void SkipToEol(istream &Stream)
{
  char c;
  Stream.clear();
  while(Stream.get(c) && c != '\n') { ; }
}

int AddToStack(Stack<UString> &X)
{
  UString s;

  cout << "Enter a new character string: ";
  cin >> s;
  if (cin) {
        int rv = X.Push(s);
        cout << ((rv == 0) ?  "Push failed\n" : "Push succeeded\n");
        return 1;
    }
  cout << "Input operation failed" << endl;
  return 1;
}

template<class TYPE>
inline int CopyStack(Stack<TYPE> &X)
{
  Stack<TYPE> buf;
  buf = X;
#ifdef __USE_LIST__
  cout << "Temporary copy of list: " << endl << endl;
  List(buf);
#endif
  return 1;
}

template<class TYPE>
inline int POP(Stack<TYPE> &X)
{
  if (X.IsEmpty()) {
    cout << "Stack empty" << endl;
     return 1;
  }

  TYPE buf;

  if (X.Pop(buf)) {
    cout << "Element popped: " << buf << endl;
  }
  else {
    cout << "Pop failed" << endl;
  }
  
  return 1;
}

template<class TYPE>
inline int Peek(const Stack<TYPE> &X)
{
  unsigned Index;

  if (X.IsEmpty()) {
    cout << "Stack is empty" << endl;
     return 1;
  }

  cout << "Enter number of elements back to peek (0 for top): ";
  cin >> Index;
  if (cin) {
     const TYPE *buf = X.Look(Index);
     if (buf) cout << *buf << endl;
     else cout << "out of range" << endl;
  }
  else cout << "Input operation failed" << endl;
  return 1;
}

template<class TYPE>
inline int RewindStack(Stack<TYPE> &X)
{
  unsigned Index;

  cout << "Enter number of elements to rewind (0 to empty completely): ";
  cin >> Index;
  if (cin) {
     X.Rewind(Index);
     cout << "Stk rewound" << endl;
     return 1;
  }
  cout << "Input operation failed" << endl;
  return 1;
}

template<class TYPE>
inline int Status(const Stack<TYPE> &X)
{
  if (X.IsEmpty()) cout << "Stack empty" << endl;
  else cout << "Stack is not empty" << endl;
  return 1;
}

template<class TYPE>
inline int Top(const Stack<TYPE> &X)
{
  const TYPE *ptr = X.Top();
  if (ptr) {
     cout << "Top element is: " << *ptr << endl;
  }
  else {
    cout << "Stack is empty" << endl;
  }
  return 1;
}

int Quit()
{
  cout << "Exiting..." << endl;
  return 0;
}

void Menu(void)
{
  cout << "(A) Add Stack entry" << endl;
  cout << "(C) Copy list" << endl;
  cout << "(P) POP entry" << endl;
  cout << "(H) Help" << endl;
#ifdef __USE_LIST__
  cout << "(L) List stack contents" << endl;
#endif
  cout << "(K) Peek into stack" << endl;
  cout << "(R) Rewind stack" << endl;
  cout << "(S) Show stack status" << endl;
  cout << "(T) Show stack top" << endl;
  cout << "(Q) Quit" << endl;
}

main()
{
  Stack<UString> a;

  int rv;
  char key;

  Menu();
  rv = 1;
  while(rv) {
    if (!cin) { // Input is in fail state
       SkipToEol(cin); // Go to end of line
       if (!cin) {  // Can't fix
	 cout << "Input stream is broken" << endl;
          return 0;
       }
    }
    cout << '>';
    cin >> key;
    if (!cin) continue; // Fix at top of loop
    key = toupper(key);
    switch(key) {
      case 'A' : rv = AddToStack(a); break;
      case 'C' : rv = CopyStack(a); break;
      case 'P' : rv = POP(a); break;
      case 'H' : Menu(); break;
#ifdef __USE_LIST__
      case 'L' : rv = List(a); break;
#endif
      case 'K' : rv = Peek(a); break;
      case 'R' : rv = RewindStack(a); break;
      case 'S' : rv = Status(a); break;
      case 'T' : rv = Top(a); break;
      case 'Q' : rv = Quit(); break;
      default:
        cout << "Unrecognized command" << endl;
    }
  }
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

