// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 01/23/1997  
// Date Last Modified: 03/17/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for (R)ed (B)lack trees.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include "rbtree.h"
#include "twalk.h"
#include "treeprt.h"
#include "ustring.h"

int PrtClass<UString>::RBNodeWidth(BNodeBase *)
{
  return 3;
}

template<class TYPE>
inline int DisplayUp(RBTree<TYPE> &t)
{
  PrintUp(t.GetRoot(), PrtClass<TYPE>::PrtRBNode, PrtClass<TYPE>::RBNodeWidth);
  return 1;
}

template<class TYPE>
inline int DisplaySideWays(RBTree<TYPE> &t)
{
  PrintSideWays(t.GetRoot(), PrtClass<TYPE>::PrtRBNode, 3);
  return 1;
}

template<class TYPE>
inline int Walk(RBTree<TYPE> &t)
{
  TestTraversals(t.GetRoot(), PrtClass<TYPE>::PrtRBNodeWSpace);
  return 1;
}

template<class TYPE>
inline int Copy(RBTree<TYPE> &t)
{
  RBTree<TYPE> copy_of_t;

  cout << "Enter copy order (<p>re <i>n p<o>st <l>vl): ";
  char x;

  cin >> x;
  WalkOrder w;

  if (x == 'p') w = PREORDER;
  else if (x == 'i') w = INORDER;
  else if (x == 'o') w = POSTORDER;
  else w = LVLORDER;

  copy_of_t.Copy(t, w);

  cout << "Temporary copy:" << endl;
  DisplayUp(copy_of_t);
  return 1;
}

int Add(RBTree<UString> &t)
{
  UString x;

  cout << "Enter character string to insert: ";
  cin >> x;
  if (cin) {
     int exists;
     t.Add(x, exists);
     if (exists) cout << "Matching node already exists" << endl;
     DisplayUp(t);
     return 1;
  }
  cout << "Input operation failed" << endl;
  return 1;
}

int Build1(RBTree<UString> &t)
{

  UString s1("aback");
  UString s2("abacus");
  UString s3("abalone");
  UString s4("abandon");
  UString s5("abase");
  UString s6("abash");
  UString s7("abate");
  UString s8("abater");
  UString s9("abbas");

  t.Add(s1);
  t.Add(s2);
  t.Add(s3);
  t.Add(s4);
  t.Add(s5);
  t.Add(s6);
  t.Add(s7);
  t.Add(s8);
  t.Add(s9);
  DisplayUp(t);
  return 1;
}

int Build2(RBTree<UString> &t)
{
  UString s1("babbitt");
  UString s2("babble");
  UString s3("babe");
  UString s4("baboon");
  UString s5("baby");
  UString s6("babyhood");
  UString s7("babysat");
  UString s8("babysit");
  UString s9("babysitter");

  t.Add(s1);
  t.Add(s2);
  t.Add(s3);
  t.Add(s4);
  t.Add(s5);
  t.Add(s6);
  t.Add(s7);
  t.Add(s8);
  t.Add(s9);
  DisplayUp(t);
  return 1;
}

template<class TYPE>
inline int Clear(RBTree<TYPE> &t)
{
  t.Clear();
  DisplayUp(t);
  return 1;
}

int Find(RBTree<UString> &t)
{
  UString x;

  cout << "Enter character string to find: ";
  cin >> x;
  if (cin) {
     if (t.GetMember(x))
       cout << "Found" << endl;
     else
       cout << "Not found" << endl;

     DisplayUp(t);
     return 1;
  }
  cout << "Input operation failed" << endl;
  return 1;
}


int Quit()
{
  cout << "Exiting..." << endl;
  return 0;
}

int Remove(RBTree<UString> &t)
{
  char x;
  UString str;
  
  cout << "Remove minimum/maximum, or specified node (m/M/s): ";
  cin >> x;
  if (x == 'm') {
     t.DeleteMin();
     cout << "Minimum removed" << endl;
     DisplayUp(t);
  }
  else if (x == 'M') {
     t.DeleteMax();
     cout << "Maximum removed" << endl;
     DisplayUp(t);
  }
  else {
    cout << "Enter character string to remove: ";
    cin >> str;
    if (cin) {
       if (t.Delete(str) == 0) cout << "Matching node not found" << endl;
       DisplayUp(t);
       return 1;
    }
    cout << "Input operation failed" << endl;
  }
  return 1;
}

template<class TYPE>
inline int ShowMin(RBTree<TYPE> &t)
{
  if (t.IsEmpty()) { cout << "Tree empty" << endl; return 1; }
  cout << "Minimum element is: " << t.GetMin()->Data << '\n';
  DisplayUp(t);
  return 1;
}

template<class TYPE>
inline int ShowMax(RBTree<TYPE> &t)
{
  if (t.IsEmpty()) { cout << "Tree empty" << endl; return 1; }
  cout << "Maximum element is: " << t.GetMax()->Data << '\n';
  DisplayUp(t);
  return 1;
}

template<class TYPE>
inline int Statistics(RBTree<TYPE> &t)
{
  if (t.IsEmpty()) { cout << "Tree is empty" << endl; return 1; }
  cout << "Height of tree is " << Height(t.GetRoot()) << '\n';
  return 1;
}

void Menu(void)
{
  cout << "(A)   Add element" << endl;
  cout << "(b/B) Build test tree 1/2" << endl;
  cout << "(c/C) copy/Clear the tree" << endl;
  cout << "(d/D) Display tree upright/sideways" << endl;
  cout << "(F)   Find element" << endl;
  cout << "(H)   Help" << endl;
  cout << "(m/M) Show min/Max element" << endl;
  cout << "(Q)   Quit" << endl;
  cout << "(R)   Remove element" << endl;
  cout << "(S)   Statistics" << endl;
  cout << "(W)   Walk the tree" << endl;
}


void SkipToEol(istream &s)
{
  char c;
  s.clear();
  while(s.get(c) && c != '\n') { ; }
}

void test()
{
  RBTree<UString> a;

  int rv;
  char key;

  Menu();
  rv = 1;
  while(rv) {
    if (!cin) { // Input is in fail state
       SkipToEol(cin); // Go to end of line
       if (!cin) {  // Can't fix
          cout << "Input stream is broken" << endl;
          return;
       }
    }
    cout << '>';
    cin >> key;
    if (!cin) continue; // Fix at top of loop
    switch(key) {
      case 'a' : case 'A' : rv = Add(a); break;
      case 'b' : rv = Build1(a); break;
      case 'B' : rv = Build2(a); break;
      case 'c' : rv = Copy(a); break;
      case 'C' : rv = Clear(a); break;
      case 'd' : rv = DisplayUp(a); break;
      case 'D' : rv = DisplaySideWays(a); break;
      case 'f' : case 'F' : rv = Find(a); break;
      case 'h' : case 'H' : Menu(); break;
      case 'm' : rv = ShowMin(a); break;
      case 'M' : rv = ShowMax(a); break;
      case 'q' : case 'Q' : rv = Quit(); break;
      case 'r' : case 'R' : rv = Remove(a); break;
      case 's' : case 'S' : rv = Statistics(a); break;
      case 'w' : case 'W' : rv = Walk(a); break;
      default:
        cout << "Unrecognized command" << endl;
    }
  }
  return;
}

int main()
{
  test();
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
