#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program  
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2 
# Produced By: Doug Gaer
# File Creation Date: 04/09/1997 
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
RBTREE_PATH = ../../src/
QUEUE_PATH = ../../src/
SLLISTB_PATH = ../../src/
STACK_PATH = ../../src/
USTRING_PATH = ../../src/

ADD_INC_PATHS = -I../../include

# Setup define macros
DEFMACS = /D__DOS__

# Define macros for compiler and linker
CC = cl
CPP = cl
LINKER = link

# Define compiler and linker flags macros
CFLAGS= /Zi /W3 $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = /c
LFLAGS =  

# Build dependency rules
# ===============================================================
BNODEB_DEP = ../../include/bnodeb.h ../../include/queue.h \
	../../include/sllist.h ../../include/sllistb.h \
	../../include/stack.h

BSTREEB_DEP = ../../include/bnode.h ../../include/bnodeb.h \
	../../include/bstreeb.h

RBTREEB_DEP = ../../include/bnode.h ../../include/bnodeb.h \
	../../include/bstreeb.h ../../include/queue.h \
	../../include/rbnode.h ../../include/rbtree.h \
	../../include/rbtreeb.h ../../include/sllist.h \
	../../include/sllistb.h ../../include/stack.h \
	../../include/twalk.h

SLLISTB_DEP = ../../include/sllistb.h

TESTPROG_DEP = ../../include/bnode.h ../../include/bnodeb.h \
	../../include/bstreeb.h ../../include/queue.h \
	../../include/rbnode.h ../../include/rbtree.h \
	../../include/rbtreeb.h ../../include/sllist.h \
	../../include/sllistb.h ../../include/stack.h \
	../../include/treeprt.h ../../include/twalk.h \
	../../include/ustring.h

TREEPRT_DEP = ../../include/bnode.h ../../include/bnodeb.h \
	../../include/queue.h ../../include/rbnode.h \
	../../include/sllist.h ../../include/sllistb.h \
	../../include/stack.h ../../include/treeprt.h \
	../../include/twalk.h

TWALK_DEP = ../../include/bnode.h ../../include/bnodeb.h \
	../../include/queue.h ../../include/rbnode.h \
	../../include/sllist.h ../../include/sllistb.h \
	../../include/stack.h ../../include/twalk.h

USTRING_DEP = ../../include/ustring.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

bnodeb.obj:	$(RBTREE_PATH)bnodeb.cpp $(BNODEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(RBTREE_PATH)bnodeb.cpp

bstreeb.obj:	$(RBTREE_PATH)bstreeb.cpp $(BSTREEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(RBTREE_PATH)bstreeb.cpp

rbtreeb.obj:	$(RBTREE_PATH)rbtreeb.cpp $(RBTREEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(RBTREE_PATH)rbtreeb.cpp

sllistb.obj:	$(SLLISTB_PATH)sllistb.cpp $(SLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(SLLISTB_PATH)sllistb.cpp

testprog.obj:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

treeprt.obj:	$(RBTREE_PATH)treeprt.cpp $(TREEPRT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(RBTREE_PATH)treeprt.cpp

twalk.obj:	$(RBTREE_PATH)twalk.cpp $(TWALK_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(RBTREE_PATH)twalk.cpp

ustring.obj:	$(USTRING_PATH)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(USTRING_PATH)ustring.cpp

# Make the executable
OBJS = bnodeb.obj bstreeb.obj rbtreeb.obj sllistb.obj testprog.obj \
	treeprt.obj twalk.obj ustring.obj
 
$(PROJECT).exe:	$(OBJS)
	$(LINKER) $(LFLAGS) $(OBJS) /OUT:$@ 
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


