#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program 
# C/C++ Compiler Used: DJGPP gcc 2.7.2.1 compiled for MSDOS 
# Produced By: Doug Gaer
# File Creation Date: 04/09/1997 
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
RBTREE_PATH = ../../src/
QUEUE_PATH = ../../src/
SLLISTB_PATH = ../../src/
STACK_PATH = ../../src/
USTRING_PATH = ../../src/

ADD_INC_PATHS = -I../../include

# Setup define macros
DEFMACS = -D__DOS__

# Define macros for compiler and linker
CC = gcc
CPP = gcc 
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -v -g -Wall $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
CPP_FLAG = -lgpp     
LFLAGS =  

# Build dependency rules
# ===============================================================
BNODEB_DEP = ../../include/bnodeb.h ../../include/queue.h \
	../../include/sllist.h ../../include/sllistb.h \
	../../include/stack.h

BSTREEB_DEP = ../../include/bnode.h ../../include/bnodeb.h \
	../../include/bstreeb.h

RBTREEB_DEP = ../../include/bnode.h ../../include/bnodeb.h \
	../../include/bstreeb.h ../../include/queue.h \
	../../include/rbnode.h ../../include/rbtree.h \
	../../include/rbtreeb.h ../../include/sllist.h \
	../../include/sllistb.h ../../include/stack.h \
	../../include/twalk.h

SLLISTB_DEP = ../../include/sllistb.h

TESTPROG_DEP = ../../include/bnode.h ../../include/bnodeb.h \
	../../include/bstreeb.h ../../include/queue.h \
	../../include/rbnode.h ../../include/rbtree.h \
	../../include/rbtreeb.h ../../include/sllist.h \
	../../include/sllistb.h ../../include/stack.h \
	../../include/treeprt.h ../../include/twalk.h \
	../../include/ustring.h

TREEPRT_DEP = ../../include/bnode.h ../../include/bnodeb.h \
	../../include/queue.h ../../include/rbnode.h \
	../../include/sllist.h ../../include/sllistb.h \
	../../include/stack.h ../../include/treeprt.h \
	../../include/twalk.h

TWALK_DEP = ../../include/bnode.h ../../include/bnodeb.h \
	../../include/queue.h ../../include/rbnode.h \
	../../include/sllist.h ../../include/sllistb.h \
	../../include/stack.h ../../include/twalk.h

USTRING_DEP = ../../include/ustring.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT) 


bnodeb.o:	$(RBTREE_PATH)bnodeb.cpp $(BNODEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(RBTREE_PATH)bnodeb.cpp

bstreeb.o:	$(RBTREE_PATH)bstreeb.cpp $(BSTREEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(RBTREE_PATH)bstreeb.cpp

rbtreeb.o:	$(RBTREE_PATH)rbtreeb.cpp $(RBTREEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(RBTREE_PATH)rbtreeb.cpp

sllistb.o:	$(SLLISTB_PATH)sllistb.cpp $(SLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(SLLISTB_PATH)sllistb.cpp

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

treeprt.o:	$(RBTREE_PATH)treeprt.cpp $(TREEPRT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(RBTREE_PATH)treeprt.cpp

twalk.o:	$(RBTREE_PATH)twalk.cpp $(TWALK_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(RBTREE_PATH)twalk.cpp

ustring.o:	$(USTRING_PATH)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(USTRING_PATH)ustring.cpp

# Make the executable
OBJS = bnodeb.o bstreeb.o rbtreeb.o sllistb.o testprog.o \
	treeprt.o twalk.o ustring.o

$(PROJECT):	$(OBJS)
	$(CC) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) $(CPP_FLAG)
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing COFF file from working directory...
	rm -f $(PROJECT)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT).exe
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
