#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program
# C/C++ Compiler Used: HP C++ A.10.09  compiled for HP-UX 10.20 
# Produced By: Doug Gaer
# File Creation Date: 04/08/1997 
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	v    -- Echo compilation
#	g    -- Enable debugging
#	+w   -- Turn on all warnings
#	+a1  -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
QUEUE_PATH = ../../src/
SLLISTB_PATH = ../../src/
USTRING_PATH = ../../src/
STACK_PATH = ../../src/

ADD_INC_PATHS = -I../../include

# Setup define macros
DEFMACS = -D__UNIX__

# Define macros for compiler and linker
CC = cc
CPP = CC
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -v -g +a1 -pta $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS =  

# Build dependency rules
# ===============================================================
SLLISTB_DEP = ../../include/sllistb.h

TESTPROG_DEP = ../../include/queue.h ../../include/sllist.h \
	../../include/sllistb.h ../../include/stack.h \
	../../include/ustring.h

USTRING_DEP = ../../include/ustring.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT) 

sllistb.o:	$(SLLISTB_PATH)sllistb.cpp $(SLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(SLLISTB_PATH)sllistb.cpp

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

ustring.o:	$(USTRING_PATH)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(USTRING_PATH)ustring.cpp 

# Make the executable
OBJS = sllistb.o testprog.o ustring.o

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing template repository from working directory...
	rm -r -f ptrepository

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
