// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: part.h 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer    
// File Creation Date: 09/18/1997  
// Date Last Modified: 03/17/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This is a test program use to test the (P)ersistent base class.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- //   
#ifndef __PART_HPP
#define __PART_HPP

#include "persist.h"
#include "float64.h"

typedef INT32 ID;
typedef FLOAT64 Price;
typedef UString Name;

const INT32 ClassPartID = 1285;

class Part : public Persistent
{ 
public:
  Part(POD *pod) : Persistent(pod) { name = "\0"; id = 0; price = 0; }
  Part(const POD *pod) : Persistent(pod) { name = "\0"; id = 0; price = 0; }
  Part() { name = "\0"; id = 0; price = 0; }
  
public:
  ID GetID() const { return id; }
  Price GetPrice() const { return price; }
  char *GetName() { return name.c_str(); }
  void SetID(ID i) { id = i; }
  void SetPrice(Price p) { price = p; }
  void SetName(char *s) { name = s; }
  void SetName(const UString &s) { name = s; }
  
private: // Base class interface
  virtual INT32 GetClassID() const { return ClassPartID; }
  virtual const char *GetClassName() { return "Class Part"; }
  virtual FAU Write();
  virtual void Read(FAU Address);
  virtual FAU Find();
  virtual FAU Delete();
  virtual FAU Remove();
  
public: // Base class interface
  virtual __UWORD__ ObjectLength();
  virtual void SetObjectAddress(FAU addr) { objectaddress = addr; }
  virtual FAU GetObjectAddress() { return objectaddress; }
  virtual int CompareIndex();
  virtual int RebuildIndexFile(const char *fname);

private:
  ID id; 
  Price price;
  Name name;
};

#endif // __PART_HPP
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
