#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program 
# C/C++ Compiler Used: DJGPP gcc 2.7.2.1 compiled for MSDOS 
# Produced By: Doug Gaer
# File Creation Date: 09/18/1997 
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#       -fhandle-exceptions -- Enable C++ exception handling
#       -frtti              -- Enable C++ Run-Time Type Information
#
# Linker flags using gcc or ld
#	-lgpp    -- C++ Linkage
#	-lstdcx  -- Needed for Exception Handling and RTTI
#	-lm      -- Needed for Exception Handling
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
PERSIST_PATH = ../../src/
POD_PATH = ../../src/
EHANDLER_PATH = ../../src/
DTYPES_PATH = ../../src/
VBDFILE_PATH = ../../src/
USTRING_PATH = ../../src/
REFCOUNT_PATH = ../../src/
BTREE_PATH = ../../src/
CACHE_PATH = ../../src/
PLACENEW_PATH = ../../src/
CRC32_PATH = ../../src/
STRUTIL_PATH = ../../src/

ADD_INC_PATHS = -I../../include

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = -D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = -D__RECLAIM_FIRST_FIT__ 

# Setup define macros
# DEFMACS = -D__DOS__ -D__X86__ -D__CONSOLE__ $(DEF_VB_ALLOC) 

# Use this DEFMACS macro to compile without using template classes
DEFMACS = -D__NOT_USING_TEMPLATE_CLASS__ -D__BTREE_MNODE__ -D__CONSOLE__ \
-D__USE_VBDREFCOUNT__ -D__DOS__ -D__X86__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Define macros for compiler and linker
CC = gcc
CPP = gcc 
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -fhandle-exceptions $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
CPP_FLAG = -lgpp -lstdcx -lm        
LFLAGS =  

# Build dependency rules
# ===============================================================
CRC32_DEP = ../../include/crc32.h ../../include/crc32tab.h

UINT32_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/uint32.h

BUCKET_DEP = ../../include/bucket.h ../../include/cacheb.h \
	../../include/cactype.h ../../include/ehandler.h \
	../../include/vbdfile.h ../../include/mnode.h \
	../../include/refcount.h ../../include/uint32.h

CACHE_DEP = ../../include/bucketb.h ../../include/cacheb.h \
	../../include/cactype.h ../../include/ehandler.h \
	../../include/vbdfile.h ../../include/mnode.h \
	../../include/refcount.h ../../include/uint32.h

CACHEB_DEP = ../../include/bucketb.h ../../include/cacheb.h \
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/int32.h \
	../../include/dtypes.h ../../include/uint32.h

CACSTATS_DEP = ../../include/bucketb.h ../../include/cacheb.h \
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/int32.h \
	../../include/dtypes.h ../../include/cacstats.h \
	../../include/uint32.h

CHPTRB_DEP = ../../include/bucket.h ../../include/bucketb.h \
	../../include/cache.h ../../include/cacheb.h \
	../../include/chptrb.h ../../include/cactype.h\
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/int32.h \
	../../include/dtypes.h ../../include/uint32.h

MNODE_DEP = ../../include/mnode.h ../../include/ehandler.h \
	../../include/int32.h ../../include/dtypes.h \
	../../include/entrykey.h

ENTRYKEY_DEP = ../../include/entrykey.h ../../include/ehandler.h \
	../../include/int32.h ../../include/dtypes.h \
	../../include/strutil.h 

STRUTIL_DEP = ../../include/strutil.h

BTREE_DEP = ../../include/bucket.h ../../include/bucketb.h \
	../../include/cache.h ../../include/cacheb.h \
	../../include/chptrb.h ../../include/cactype.h\
	../../include/cacheptr.h ../../include/btree.h \
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/placenew.h \
	../../include/mnode.h ../../include/int32.h\
	../../include/dtypes.h ../../include/entrykey.h \
	../../include/uint32.h

BTREEPRT_DEP = ../../include/bucket.h 	../../include/bucketb.h \
	../../include/cache.h 	../../include/cacheb.h \
	../../include/chptrb.h ../../include/cactype.h\
	../../include/cacheptr.h ../../include/btree.h \
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/placenew.h \
	../../include/mnode.h ../../include/int32.h\
	../../include/dtypes.h ../../include/entrykey.h \
	../../include/btreeprt.h ../../include/uint32.h

EHANDLER_DEP = ../../include/ehandler.h

FLOAT64_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/float64.h

INT32_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/int32.h

VBDFILE_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/int32.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/crc32.h \
	../../include/uint32.h

VBDREF_DEP = ../../include/vbdfile.h ../../include/vbdref.h \
	../../include/refcount.h

POD_DEP = ../../include/pod.h ../../include/bucket.h \
	../../include/bucketb.h ../../include/cache.h \
	../../include/cacheb.h ../../include/chptrb.h \
	../../include/cactype.h ../../include/cacheptr.h \
	../../include/btree.h ../../include/ehandler.h \
	../../include/vbdfile.h ../../include/refcount.h \
	../../include/placenew.h ../../include/mnode.h \
	../../include/int32.h ../../include/dtypes.h \
	../../include/entrykey.h ../../include/btree.h \
	../../include/uint32.h

PERSIST_DEP = ../../include/pod.h ../../include/bucket.h \
	../../include/bucketb.h ../../include/cache.h \
	../../include/cacheb.h ../../include/chptrb.h \
	../../include/cactype.h ../../include/cacheptr.h \
	../../include/btree.h ../../include/ehandler.h \
	../../include/vbdfile.h ../../include/refcount.h \
	../../include/placenew.h ../../include/mnode.h \
	../../include/int32.h ../../include/dtypes.h \
	../../include/entrykey.h ../../include/btree.h \
	../../include/persist.h ../../include/uint32.h 

PART_DEP = ../../include/pod.h ../../include/bucket.h \
	../../include/bucketb.h ../../include/cache.h \
	../../include/cacheb.h ../../include/chptrb.h \
	../../include/cactype.h ../../include/cacheptr.h \
	../../include/btree.h ../../include/ehandler.h \
	../../include/vbdfile.h ../../include/refcount.h \
	../../include/placenew.h ../../include/mnode.h \
	../../include/int32.h ../../include/dtypes.h \
	../../include/entrykey.h ../../include/btree.h \
	../../include/persist.h part.h ../../include/uint32.h 

USTRING_DEP = ../../include/ustring.h 

TESTPROG_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/float64.h ../../include/int32.h \
        ../../include/vbdfile.h ../../include/refcount.h \
	../../include/ustring.h ../../include/pod.h \
	../../include/bucket.h ../../include/bucketb.h \
	../../include/cache.h ../../include/cacheb.h \
	../../include/chptrb.h ../../include/cacheptr.h \
	../../include/cactype.h ../../include/btree.h \
	../../include/placenew.h ../../include/mnode.h \
	../../include/entrykey.h ../../include/btreeprt.h \
	../../include/cacstats.h ../../include/pod.h \
	../../include/persist.h part.h ../../include/uint32.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

strutil.o:	$(STRUTIL_PATH)strutil.cpp $(STRUTIL_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(STRUTIL_PATH)strutil.cpp 

uint32.o:	$(DTYPES_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint32.cpp

crc32.o:	$(CRC32_PATH)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CRC32_PATH)crc32.cpp

bucket.o:	$(CACHE_PATH)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)bucket.cpp

cache.o:	$(CACHE_PATH)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cache.cpp

cacheb.o:	$(CACHE_PATH)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cacheb.cpp

chptrb.o:	$(CACHE_PATH)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)chptrb.cpp

cacstats.o:	$(CACHE_PATH)cacstats.cpp $(CACSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cacstats.cpp

mnode.o:	$(BTREE_PATH)mnode.cpp $(MNODE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)mnode.cpp

entrykey.o:	$(BTREE_PATH)entrykey.cpp $(ENTRYKEY_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BTREE_PATH)entrykey.cpp

btreeprt.o:	$(BTREE_PATH)btreeprt.cpp $(BTREEPRT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BTREE_PATH)btreeprt.cpp

btree.o:	$(BTREE_PATH)btree.cpp $(BTREE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BTREE_PATH)btree.cpp

vbdref.o:	$(VBDFILE_PATH)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdref.cpp

ehandler.o:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

float64.o:	$(DTYPES_PATH)float64.cpp $(FLOAT64_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)float64.cpp

int32.o:	$(DTYPES_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)int32.cpp

vbdfile.o:    $(VBDFILE_PATH)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdfile.cpp

pod.o:    $(POD_PATH)pod.cpp $(POD_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(POD_PATH)pod.cpp

persist.o:    $(PERSIST_PATH)persist.cpp $(PERSIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(PERSIST_PATH)persist.cpp

part.o:	part.cpp $(PART_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) part.cpp

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

ustring.o:	$(USTRING_PATH)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(USTRING_PATH)ustring.cpp

# Make the executable
OBJS = ehandler.o float64.o int32.o vbdfile.o \
	testprog.o ustring.o pod.o cacheb.o chptrb.o \
	btree.o mnode.o bucket.o cache.o vbdref.o \
	entrykey.o btreeprt.o cacstats.o persist.o \
	part.o crc32.o uint32.o strutil.o

$(PROJECT):	$(OBJS)
	$(CC) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) $(CPP_FLAG)
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing COFF file from working directory...
	rm -f $(PROJECT)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT).exe

	echo Removing any test file created...
	rm -f *.pod
	rm -f *.btx
	rm -f *.vbd
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
