// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: dstring.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 04/05/1996 
// Date Last Modified: 03/17/1999
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

A simple dynamic string class.
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include <iostream.h>
#include <iomanip.h>

class DString 
{ 
public:
  DString() { str = 0; }
  DString(char *s) { Store(s); }
  DString(int sz);
  ~DString() { delete str; }    
  DString(const DString &s) { Store(s.str); }

  DString &operator=(const DString &s) {
    if(this != &s) {
      str = 0;
      Store(s.str);
    }
    return *this;
  }

public:
  void Store(char *s);
  char *c_str() const { return str; } 

public:
  friend int operator==(const DString &a, const DString &b) {
    return strcmp(a.str, b.str) == 0;
  }

  friend int operator<(const DString &a, const DString &b) {
    return strcmp(a.str, b.str) < 0;
  }

  friend int operator>(const DString &a, const DString &b) {
    return strcmp(a.str, b.str) > 0;
  }

  friend int operator!=(const DString &a, const DString &b) {
    return strcmp(a.str, b.str) != 0;
  }
  
  friend ostream &operator<<(ostream &os, const DString &s) {
    return os.write(s.str, strlen(s.str));
  }

  friend istream &operator>>(istream &os, DString &s) {
    os >> setw(strlen(s.str)) >> s.str;
    return os;
  }
	       
private:
  char *str;
};

DString::DString(int sz)
{
  str = new char[sz+1];
  str[sz+1] = '\0';
}

void DString::Store(char *s)
{
  size_t len = strlen(s);
  str = new char[len+1];
  str[len+1] = '\0';
  strcpy(str, s);
}

// Test program code starts here
// *********************************************************** //
int main()
{
  cout << "Constructing DString class objects..." << endl;
  DString a("DOG");
  DString b("CAT");
  DString c("MOUSE");
  DString d("BIRD");

  cout << "Testing copy constructor..." << endl;
  DString e(a);  

  cout << "Testing assignment operator..." << endl;
  a = c;

  cout << endl;
  cout << "Testing overloaded << operator..."  << endl;
  cout << a << ' ' << b  << ' ' << c  << ' ' << d << ' ' << e << endl;

  cout << endl;
  cout << "Testing c_str() function..." << endl;
  cout << a.c_str() << endl;
  cout << b.c_str() << endl;
  cout << c.c_str() << endl;
  cout << d.c_str() << endl;
  cout << e.c_str() << endl;

  cout << endl;
  cout << "Testing overloaded >> operator..." << endl;
  DString buf(255);
  cout << "Enter a string of characters: ";
  cin >> buf;

  cout << endl;
  cout << "Data entered = " << buf << endl;
  
  return 0;
}  
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
