// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer  
// File Creation Date: 02/14/1996  
// Date Last Modified: 03/17/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the ehandler class.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <stdlib.h>
#include <fstream.h>
#include "ehandler.h"

#ifdef CPP_EXCEPTIONS

class CTest
{
public:
  CTest() { cout << "Constructing CTest object..." << endl; }
  ~CTest() { cout << "Destructing CTest object..." << endl; }

public:
  int FOpen(const char *s);

private:
  fstream f;
};

int CTest::FOpen(const char *s)
{
  f.open(s, ios::in|ios::nocreate);
  if(!f) return 0;
  return 1;
}

void TestFunction()
{
  CTest ob;
  cout << "In TestFunction(). Throwing COpenError exception..." << endl;
  if(!ob.FOpen("ABCDEF")) throw CFileOpenError();  
  // This will automatically call the destructor function during
  // stack unwinding for all loacl objects constructed before
  // the exception was thrown.

  // The context between the throw site and the catch handler
  // is known as the "exception stack frame". 
}

#endif

void pause()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}


void MyHandler()
{
  cout << "Handling custom exception..." << endl;
}

int main()
{
  cout << endl;
  cout << "Setting exception for non-fatal (dummy) exception..." << endl;
  Error->SetException(EHandler::PathError);

  if(Error->Exception()) Error->DisplayException();

  pause();
  
  cout << "Resetting exception..." << endl;
  Error->ClearException();
  if(Error->Exception()) Error->DisplayException();
		     
  pause();

  cout << "Testing non-fatal exception with display off..." << endl;
  Error->SignalException(EHandler::PathError,
			EHandler::DISPLAY,
			DisplayOff);

  pause();

  cout << "Testing display function..." << endl;
  Error->DisplayException(EHandler::PathError);

  pause();

  cout << "Testing custom exception handler routine..." << endl;
  Error->TrapException(MyHandler);

  pause();
  
#ifdef CPP_EXCEPTIONS  
  cout << "Testing C++'s built-in exception handling routines" << endl;

  try
    {
      cout << "In try block, calling TestFunction()..." << endl;
      TestFunction();
    }

  catch(CFileOpenError err)
    {
      err.SignalException(EHandler::FileOpenError, EHandler::DISPLAY);
    }

  cout << "Resuming program execution here..." << endl;
#endif

  pause();

  ifstream InFile("NOTHING", ios::in|ios::nocreate);

  cout << "Using Message() function to display a message..." << endl;
  if(!InFile) Error->Message("Could not open file!");

  cout << endl;
  cout << "Testing fatal exception..." << endl;
  if(!InFile) Error->SignalException(EHandler::FileOpenError);

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
