// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testf64.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/05/1997  
// Date Last Modified: 03/17/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the FLOAT64 class.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <stdio.h>
#include "float64.h"

void pause()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

void SkipToEol(istream &s)
// Used to clear istream
{
  char c;
  s.clear();
  while(s.get(c) && c != '\n') { ; }
}

void FWrite(char *fname)
{
  FLOAT64 aa = 3.141592653589793; // Arc cosine of -1 equals pi
  cout.precision(15);  // Show 15 places after the decimal point 
  cout.setf(ios::fixed | ios::right); // Normal FP notation right justified
  cout << "Writing a FLOAT64 value " << aa << " to a file..." << endl;
  ios::sync_with_stdio();
  FILE *stream;
  int numwritten;

  /* Open file in binary mode: */
  if((stream = fopen( fname, "w+b" )) != NULL )
    {
      numwritten = fwrite((char *)&aa, 1, sizeof(FLOAT64), stream );
      printf( "Wrote %d items\n", numwritten );
      fclose( stream );
    }
  else
    printf( "Problem opening the file\n" );
}

void FRead(char *fname)
{
  FLOAT64 bb = 0;
  ios::sync_with_stdio();
  FILE *stream;
  int numread;

  cout.precision(15);  // Show 15 places after the decimal point 
  cout.setf(ios::fixed | ios::right); // Normal FP notation right justified
  cout << "Reading back FLOAT64 value from the file..." << endl;
  if( (stream = fopen( fname, "r+b" )) != NULL )
    {
      numread = fread((char *)&bb, 1, sizeof(FLOAT64), stream );
      printf( "Number of items read = %d\n", numread );
      fclose( stream );
    }
  else
    printf( "File could not be opened\n" );
  
  cout << "Value read from file = " << bb << endl;

}

template<class TYPEX, class TYPEY>
inline void OperatorTest(TYPEX x, TYPEY y)
{
  char *tf[2] = {"FALSE", "TRUE"};
  cout << endl;
  cout << "Value x = " << x << ", Value y = " << y << endl;
  TYPEX z;
  cout << x << " += " << y << " = "; z = x; z += y; cout << z << endl;
  cout << x << " -= " << y << " = "; z = x; z -= y; cout << z << endl;
  cout << x << " *= " << y << " = "; z = x; z *= y; cout << z << endl;
  cout << x << " /= " << y << " = "; z = x; z /= y; cout << z << endl;
  cout << x << " * " << y << " = " ; z = (x * y); cout << z << endl;
  cout << x << " / " << y << " = " ; z = (x / y); cout << z << endl;
  cout << x << " + " << y << " = " ; z = (x + y); cout << z << endl;
  cout << x << " - " << y << " = " ; z = (x - y); cout << z << endl;
  cout << x << " == " << y << " = " << tf[(x == y)] << endl;
  cout << x << " != " << y << " = " << tf[(x != y)] << endl;
  cout << x << " <= " << y << " = " << tf[(x <= y)] << endl;
  cout << x << " >= " << y << " = " << tf[(x >= y)] << endl;
  cout << x << " < " << y << " = " << tf[(x < y)] << endl;
  cout << x << " > " << y << " = " << tf[(x > y)] << endl;
  cout << x << "++ = "; z = x; z++; cout << z << endl;
  cout << x << "-- = "; z = x; z--; cout << z << endl; 
  cout << "++" << x << " = "; z = x; ++z; cout << z << endl;
  cout << "--" << x << " = "; z = x; --z; cout << z << endl;
}

int main()
{
  FLOAT64 a = DPFLOATPositiveLimit;
  cout << "FLOAT64 positive limit = " << a << endl;

  FLOAT64 b(DPFLOATNegitiveLimit);
  cout << "FLOAT64 negitive limit = " << b << endl;

  pause();
  
  cout << "Testing FLOAT64 copy consturctor..." << endl;
  FLOAT64 c(a);
  cout << c << endl;

  cout << endl;
  cout << "Testing FLOAT64 assignment operator..." << endl;
  FLOAT64 d;
  d = a;
  cout << d << endl;

  pause();

  // Reading and writing a FLOAT64 value to a file
  char fname[255] = "testf64.out";
  FILE *tmp; // Temporary file pointer
  tmp = ::fopen(fname, "rb");

  if(tmp) FRead(fname); else FWrite(fname);
    
  pause();
  
  cout.precision(10);  // Show 10 places after the decimal point 
  cout.setf(ios::fixed | ios::right); // Normal FP notation right justified
  cout << "Testing overloaded operators (FLOAT64, FLOAT64)..." << endl;
  __DPFLOAT__ buf1, buf2, af, bf;
  
  cout << "Enter first floating point value: ";
  cin >> buf1;
  if(cin) {
    a = buf1;
    af = buf1;
    cout << "Enter second floating point value: ";
    cin >> buf2;
  }
  else {
    cout << "Input stream broken. Exiting..." << endl;
    return 0;
  }
  if(cin) {
    b = buf2;
    bf = buf2;
  }
  else {
    cout << "Input stream broken. Exiting..." << endl;
    return 0;
  }

  SkipToEol(cin);
    
  cout << endl;
  
  OperatorTest(a, b);
  
  pause();

  cout << "Testing overloaded operators (FLOAT64, __DPFLOAT__)..." << endl;
  OperatorTest(a, bf);

  pause();

  cout << "Testing overloaded operators (__DPFLOAT__, FLOAT64)..." << endl;
  OperatorTest(af, b);
  
  pause();

  cout << "Testing overloaded operators (FLOAT64, __LWORD__)..." << endl;
  OperatorTest(a, (__LWORD__)bf);

  pause();

  cout << "Testing overloaded operators (__LWORD__, FLOAT64)..." << endl;
  OperatorTest((__LWORD__)af, b);
  
  pause();

  cout << "Testing overloaded operators (FLOAT64, __WORD__)..." << endl;
  OperatorTest(a, (__WORD__)bf);

  pause();

  cout << "Testing overloaded operators (__WORD__, FLOAT64)..." << endl;
  OperatorTest((__WORD__)af, b);

  pause();

  cout << "Testing overloaded operators (FLOAT64, __SWORD__)..." << endl;
  OperatorTest(a, (__SWORD__)bf);

  pause();

  cout << "Testing overloaded operators (__SWORD__, FLOAT64)..." << endl;
  OperatorTest((__SWORD__)af, b);

  pause();
  
  cout << "Testing overloaded operators (FLOAT64, __UWORD__)..." << endl;
  OperatorTest(a, (__UWORD__)bf);

  pause();

  cout << "Testing overloaded operators (__UWORD__, FLOAT64)..." << endl;
  OperatorTest((__UWORD__)af, b);

  pause();

  cout << "Testing overloaded operators (FLOAT64, __USWORD__)..." << endl;
  OperatorTest(a, (__USWORD__)bf);

  pause();

  cout << "Testing overloaded operators (__USWORD__, FLOAT64)..." << endl;
  OperatorTest((__USWORD__)af, b);

  pause();
  
  cout << "Testing overloaded operators (FLOAT64, __SBYTE__)..." << endl;
  OperatorTest(a, 'B');

  pause();

  cout << "Testing overloaded operators (__SBYTE__, FLOAT64)..." << endl;
  OperatorTest('A', b);

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
