#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the test programs
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2
# Produced By: Doug Gaer
# File Creation Date: 09/05/1997 
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#       GX -- Enable C++ exception handling
#       GR -- Enable C++ Run-Time Type Information
# 	Zp -- Byte align structures (leave no gaps between members)
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT1 = testi32
PROJECT2 = testu32
PROJECT3 = testi16
PROJECT4 = testu16
PROJECT5 = testf64

# Setup additional paths for includes and source code
DTYPES_PATH = ../../src/
EHANDLER_PATH = ../../src/

ADD_INC_PATHS = -I../../include

# Setup define macros
DEFMACS = /D__X86__ /D__CONSOLE__ /D__USE_DTYPES_CONSTANTS__

# Define macros for compiler and linker
CC = cl
CPP = cl
LINKER = link

# Define compiler and linker flags macros
CFLAGS= /Zi /GX $(DEFMACS) $(ADD_INC_PATHS)
COMPILE_ONLY = /c
LFLAGS =  

# Build dependency rules
# ===============================================================
EHANDLER_DEP = ../../include/ehandler.h

INT32_DEP = ../../include/int32.h ../../include/ehandler.h \
	../../include/dtypes.h

UINT32_DEP = ../../include/uint32.h ../../include/ehandler.h \
	../../include/dtypes.h

INT16_DEP = ../../include/int16.h ../../include/ehandler.h \
	../../include/dtypes.h

UINT16_DEP = ../../include/uint16.h ../../include/ehandler.h \
	../../include/dtypes.h

FLOAT64_DEP = ../../include/float64.h ../../include/ehandler.h \
	../../include/dtypes.h 

TESTI32_DEP = ../../include/int32.h ../../include/ehandler.h \
	../../include/dtypes.h

TESTU32_DEP = ../../include/uint32.h ../../include/ehandler.h \
	../../include/dtypes.h

TESTI16_DEP = ../../include/int16.h ../../include/ehandler.h \
	../../include/dtypes.h

TESTU16_DEP = ../../include/uint16.h ../../include/ehandler.h \
	../../include/dtypes.h

TESTF64_DEP = ../../include/float64.h ../../include/ehandler.h \
	../../include/dtypes.h 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT1).exe $(PROJECT2).exe $(PROJECT3).exe $(PROJECT4).exe \
	$(PROJECT5).exe

int32.obj:	$(DTYPES_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)int32.cpp

uint32.obj:	$(DTYPES_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint32.cpp

int16.obj:	$(DTYPES_PATH)int16.cpp $(INT16_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)int16.cpp

uint16.obj:	$(DTYPES_PATH)uint16.cpp $(UINT16_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint16.cpp

float64.obj:	$(DTYPES_PATH)float64.cpp $(FLOAT64_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)float64.cpp

ehandler.obj:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

testf64.obj:	testf64.cpp $(TESTF64_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testf64.cpp

testu16.obj:	testu16.cpp $(TESTU16_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testu16.cpp

testi16.obj:	testi16.cpp $(TESTI16_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testi16.cpp

testu32.obj:	testu32.cpp $(TESTU32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testu32.cpp

testi32.obj:	testi32.cpp $(TESTI32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testi32.cpp

# Make the executable
OBJS_PROJECT1 = ehandler.obj testi32.obj int32.obj 
OBJS_PROJECT2 = ehandler.obj testu32.obj uint32.obj 
OBJS_PROJECT3 = ehandler.obj testi16.obj int16.obj 
OBJS_PROJECT4 = ehandler.obj testu16.obj uint16.obj 
OBJS_PROJECT5 = ehandler.obj testf64.obj float64.obj 

$(PROJECT1).exe:	$(OBJS_PROJECT1)
        $(LINKER) $(LFLAGS) $(OBJS_PROJECT1) /OUT:$@ 

$(PROJECT2).exe:	$(OBJS_PROJECT2)
        $(LINKER) $(LFLAGS) $(OBJS_PROJECT2) /OUT:$@ 

$(PROJECT3).exe:	$(OBJS_PROJECT3)
        $(LINKER) $(LFLAGS) $(OBJS_PROJECT3) /OUT:$@ 

$(PROJECT4).exe:	$(OBJS_PROJECT4)
        $(LINKER) $(LFLAGS) $(OBJS_PROJECT4) /OUT:$@ 

$(PROJECT5).exe:	$(OBJS_PROJECT5)
        $(LINKER) $(LFLAGS) $(OBJS_PROJECT5) /OUT:$@ 
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT1).exe del $(PROJECT1).exe 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT2).exe del $(PROJECT2).exe 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT3).exe del $(PROJECT3).exe 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT4).exe del $(PROJECT4).exe 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT5).exe del $(PROJECT5).exe 
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


