#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the test programs
# C/C++ Compiler Used: DJGPP gcc 2.7.2.1 compiled for MSDOS 
# Produced By: Doug Gaer
# File Creation Date: 09/05/1997 
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v                   -- Echo compilation
#       g                   -- Enable debugging
#       Wall                -- Turn on warnings 
#       -fhandle-exceptions -- Enable C++ exception handling
#       -frtti              -- Enable C++ Run-Time Type Information
#
# Linker flags using gcc or ld
#	-lgpp    -- C++ Linkage
#	-lstdcx  -- Needed for Exception Handling and RTTI
#	-lm      -- Needed for Exception Handling
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT1 = testi32
PROJECT2 = testu32
PROJECT3 = testi16
PROJECT4 = testu16
PROJECT5 = testf64

# Setup additional paths for includes and source code
DTYPES_PATH = ../../src/
EHANDLER_PATH = ../../src/

ADD_INC_PATHS = -I../../include

# Setup define macros
DEFMACS = -D__X86__ -D__CONSOLE__ -D__USE_DTYPES_CONSTANTS__

# Define macros for compiler and linker
CC = gcc
CPP = gcc
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -fhandle-exceptions $(DEFMACS) $(ADD_INC_PATHS)
COMPILE_ONLY = -c
OUTPUT = -o
CPP_FLAG = -lgpp -lstdcx     
LFLAGS =  

# Build dependency rules
# ===============================================================
EHANDLER_DEP = ../../include/ehandler.h

INT32_DEP = ../../include/int32.h ../../include/ehandler.h \
	../../include/dtypes.h

UINT32_DEP = ../../include/uint32.h ../../include/ehandler.h \
	../../include/dtypes.h

INT16_DEP = ../../include/int16.h ../../include/ehandler.h \
	../../include/dtypes.h

UINT16_DEP = ../../include/uint16.h ../../include/ehandler.h \
	../../include/dtypes.h

FLOAT64_DEP = ../../include/float64.h ../../include/ehandler.h \
	../../include/dtypes.h 

TESTI32_DEP = ../../include/int32.h ../../include/ehandler.h \
	../../include/dtypes.h

TESTU32_DEP = ../../include/uint32.h ../../include/ehandler.h \
	../../include/dtypes.h

TESTI16_DEP = ../../include/int16.h ../../include/ehandler.h \
	../../include/dtypes.h

TESTU16_DEP = ../../include/uint16.h ../../include/ehandler.h \
	../../include/dtypes.h

TESTF64_DEP = ../../include/float64.h ../../include/ehandler.h \
	../../include/dtypes.h 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT1) $(PROJECT2) $(PROJECT3) $(PROJECT4) $(PROJECT5)

TESTI32:	$(PROJECT1)

ehandler.o:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

int32.o:	$(DTYPES_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)int32.cpp

testi32.o:	testi32.cpp $(TESTI32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testi32.cpp

OBJS_PROJECT1 = ehandler.o testi32.o int32.o 

$(PROJECT1):	$(OBJS_PROJECT1)
	$(CC) $(CFLAGS) $(OBJS_PROJECT1) $(OUTPUT) $(PROJECT1) $(CPP_FLAG)

TESTU32:	$(PROJECT2)

uint32.o:	$(DTYPES_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint32.cpp

testu32.o:	testu32.cpp $(TESTU32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testu32.cpp

OBJS_PROJECT2 = ehandler.o testu32.o uint32.o 

$(PROJECT2):	$(OBJS_PROJECT2)
	$(CC) $(CFLAGS) $(OBJS_PROJECT2) $(OUTPUT) $(PROJECT2) $(CPP_FLAG)

TESTI16:	($PROJECT3)

int16.o:	$(DTYPES_PATH)int16.cpp $(INT16_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)int16.cpp

testi16.o:	testi16.cpp $(TESTI16_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testi16.cpp

OBJS_PROJECT3 = ehandler.o testi16.o int16.o 

$(PROJECT3):	$(OBJS_PROJECT3)
	$(CC) $(CFLAGS) $(OBJS_PROJECT3) $(OUTPUT) $(PROJECT3) $(CPP_FLAG)

TESTU16:	($PROJECT4)

uint16.o:	$(DTYPES_PATH)uint16.cpp $(UINT16_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint16.cpp

testu16.o:	testu16.cpp $(TESTU16_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testu16.cpp

OBJS_PROJECT4 = ehandler.o testu16.o uint16.o 

$(PROJECT4):	$(OBJS_PROJECT4)
	$(CC) $(CFLAGS) $(OBJS_PROJECT4) $(OUTPUT) $(PROJECT4) $(CPP_FLAG)

TESTF64:	($PROJECT5)

float64.o:	$(DTYPES_PATH)float64.cpp $(FLOAT64_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)float64.cpp

testf64.o:	testf64.cpp $(TESTF64_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testf64.cpp

OBJS_PROJECT5 = ehandler.o testf64.o float64.o 

$(PROJECT5):	$(OBJS_PROJECT5)
	$(CC) $(CFLAGS) $(OBJS_PROJECT5) $(OUTPUT) $(PROJECT5) $(CPP_FLAG)
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing COFF file from working directory...
	rm -f $(PROJECT1)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT1).exe

	echo Removing COFF file from working directory...
	rm -f $(PROJECT2)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT2).exe

	echo Removing COFF file from working directory...
	rm -f $(PROJECT3)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT3).exe

	echo Removing COFF file from working directory...
	rm -f $(PROJECT4)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT4).exe

	echo Removing COFF file from working directory...
	rm -f $(PROJECT5)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT5).exe
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
