#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program
# C/C++ Compiler Used: HP C++ A.10.24  compiled for HP-UX 10.20 
# Produced By: Doug Gaer      ^^^^^^^
# File Creation Date: 04/14/1997 
# Date Last Modified: 03/17/1999
#
# NOTE: If using the template classes this program will not 
# compile under HP C++ A.10.09. The template version of the 
# Bucket class uses a template parameter as base class, which 
# was not allowed in this version of HP C++. To get the current 
# version number enter the following command:
# 
# % what /opt/CC/bin/CC
# ***************************************************************
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	v    -- Echo compilation
#	g    -- Enable debugging
#	+w   -- Turn on all warnings
#	+a1  -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
#       +eh -- Enable C++ exception handling
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
DTREE_PATH = 
CACHE_PATH = ../../src/
EHANDLER_PATH = ../../src/
DTYPES_PATH = ../../src/
VBDFILE_PATH = ../../src/
REFCOUNT_PATH = ../../src/
PLACENEW_PATH = ../../src/
CRC32_PATH = ../../src/

ADD_INC_PATHS = -I../../include -I./

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = -D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = -D__RECLAIM_FIRST_FIT__ 

# Use this DEFMACS macro to compile without using template classes
DEFMACS = -D__NOT_USING_TEMPLATE_CLASS__ -D__DTREE_NODE__ -D__CONSOLE__ \
-D__USE_VBDREFCOUNT__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Enable to use the template classes
# DEFMACS = -D__CONSOLE__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Define macros for compiler and linker
CC = cc
CPP = CC
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -v -g +a1 -pta +eh $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS =  

# Build dependency rules
# ===============================================================
CRC32_DEP = ../../include/crc32.h ../../include/crc32tab.h

UINT32_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/uint32.h

BUCKET_DEP = ../../include/bucket.h ../../include/cacheb.h \
	../../include/cactype.h ../../include/ehandler.h \
	../../include/vbdfile.h $(DTREE_PATH)tnode.h \
	../../include/refcount.h $(DTREE_PATH)fkey.h \
	../../include/uint32.h

CACHE_DEP = ../../include/bucketb.h ../../include/cacheb.h \
	../../include/cactype.h ../../include/ehandler.h \
	../../include/vbdfile.h $(DTREE_PATH)tnode.h \
	../../include/refcount.h $(DTREE_PATH)fkey.h \
	../../include/uint32.h

CACHEB_DEP = ../../include/bucketb.h ../../include/cacheb.h \
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/int32.h \
	../../include/dtypes.h ../../include/uint32.h

CACSTATS_DEP = ../../include/bucketb.h ../../include/cacheb.h \
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/int32.h \
	../../include/dtypes.h ../../include/cacstats.h \
	../../include/uint32.h

CHPTRB_DEP = ../../include/bucket.h ../../include/bucketb.h \
	../../include/cache.h ../../include/cacheb.h \
	../../include/chptrb.h ../../include/cactype.h\
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/int32.h \
	../../include/dtypes.h ../../include/uint32.h

TNODE_DEP = $(DTREE_PATH)tnode.h ../../include/cacheptr.h \
	../../include/chptrb.h ../../include/cache.h \
	../../include/placenew.h ../../include/bucket.h \
	../../include/bucketb.h ../../include/cacheb.h \
	../../include/vbdfile.h ../../include/refcount.h \
	../../include/ehandler.h ../../include/int32.h \
	../../include/dtypes.h $(DTREE_PATH)fkey.h \
	../../include/uint32.h

FKEY_DEP = $(DTREE_PATH)tnode.h ../../include/cacheptr.h \
	../../include/chptrb.h ../../include/cache.h \
	../../include/placenew.h ../../include/bucket.h \
	../../include/bucketb.h ../../include/cacheb.h \
	../../include/vbdfile.h ../../include/refcount.h \
	../../include/cactype.h ../../include/ehandler.h \
	../../include/int32.h ../../include/dtypes.h \
	$(DTREE_PATH)fkey.h ../../include/uint32.h

DTREE_DEP = ../../include/bucket.h ../../include/bucketb.h \
	../../include/cache.h ../../include/cacheb.h \
	../../include/chptrb.h ../../include/cactype.h\
	../../include/cacheptr.h $(DTREE_PATH)dtree.h \
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/placenew.h \
	$(DTREE_PATH)tnode.h ../../include/int32.h\
	../../include/dtypes.h $(DTREE_PATH)fkey.h \
	../../include/uint32.h

EHANDLER_DEP = ../../include/ehandler.h

INT32_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/int32.h

VBDFILE_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/int32.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/uint32.h \
	../../include/crc32.h

VBDREF_DEP = ../../include/vbdfile.h \
	../../include/vbdref.h ../../include/refcount.h

TESTPROG_DEP = ../../include/bucket.h ../../include/bucketb.h \
	../../include/cache.h ../../include/cacheb.h \
	../../include/chptrb.h ../../include/cacheptr.h \
	../../include/cactype.h $(DTREE_PATH)dtree.h \
	../../include/ehandler.h ../../include/int32.h \
        ../../include/vbdfile.h ../../include/refcount.h \
	../../include/placenew.h $(DTREE_PATH)tnode.h \
	$(DTREE_PATH)fkey.h ../../include/uint32.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

uint32.o:	$(DTYPES_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint32.cpp

crc32.o:	$(CRC32_PATH)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CRC32_PATH)crc32.cpp

bucket.o:	$(CACHE_PATH)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)bucket.cpp

cache.o:	$(CACHE_PATH)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cache.cpp

cacheb.o:	$(CACHE_PATH)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cacheb.cpp

chptrb.o:	$(CACHE_PATH)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)chptrb.cpp

cacstats.o:	$(CACHE_PATH)cacstats.cpp $(CACSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cacstats.cpp

tnode.o:	$(DTREE_PATH)tnode.cpp $(TNODE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTREE_PATH)tnode.cpp

fkey.o:	$(DTREE_PATH)fkey.cpp $(FKEY_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTREE_PATH)fkey.cpp

dtree.o:	$(DTREE_PATH)dtree.cpp $(DTREE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTREE_PATH)dtree.cpp

ehandler.o:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

int32.o:	$(DTYPES_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)int32.cpp

vbdfile.o:    $(VBDFILE_PATH)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdfile.cpp

vbdref.o:	$(VBDFILE_PATH)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)vbdref.cpp

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

# Make the executable
OBJS = cacheb.o chptrb.o dtree.o ehandler.o vbdfile.o \
	testprog.o tnode.o int32.o bucket.o cache.o \
	fkey.o vbdref.o cacstats.o crc32.o uint32.o

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)

	echo Removing template repository from working directory...
	rm -r -f ptrepository

	echo Removing any test files created during program execution
	rm -f testfile.dtx
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
