// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: fkey.h 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/07/1997  
// Date Last Modified: 03/17/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The FKey class is used to identify objects in the database
by a unique key name when an index file is used. Each key is
fixed in length by the KeyLength variable.
*/
// ----------------------------------------------------------- //   
#ifndef __FKEY_HPP__
#define __FKEY_HPP__

#include <string.h>
#include <iostream.h>
#include <iomanip.h>
#include "vbdfile.h"

// Each Key will be limited to 64 bytes (512 bits)
const unsigned FKeyLength = 64; // String length of the fixed key name

// (F)ixed length (K)ey class
class FKey 
{ 
public:
  FKey() { Clear(); object_address = 0; class_id = 0; }
  FKey(char *s);
  FKey(char *s, int oa, int ci); 
  FKey(const FKey &s);
  FKey &operator=(const FKey &s);

public:
  void Store(char *s);
  void Store(const char *s);
  int Append(char c);
  void Clear();
  void SetClassID(INT32 id) { class_id = id; }
  void SetObjectAddress(INT32 addr) { object_address = addr; }
  INT32 ClassID() { return class_id; }
  INT32 ObjectAddress() { return object_address; }
  void Copy(const FKey &s);

  // Functions used to return null terminate low level c strings
  char *c_str();
  char *c_str() const;
  
public:
  friend int operator==(const FKey &a, const FKey &b) {
    return strcmp(a.key_name, b.key_name) == 0;
  }

  friend int operator<(const FKey &a, const FKey &b) {
    return strcmp(a.key_name, b.key_name) < 0;
  }

  friend int operator>(const FKey &a, const FKey &b) {
    return strcmp(a.key_name, b.key_name) > 0;
  }

  friend int operator!=(const FKey &a, const FKey &b) {
    return strcmp(a.key_name, b.key_name) != 0;
  }
  
  friend ostream &operator<<(ostream &os, const FKey &s) {
    return os.write(s.key_name, strlen(s.key_name));
  }

  friend istream &operator>>(istream &os, FKey &s) {
    os >> setw(strlen(s.key_name)) >> s.key_name;
    return os;
  }
	       
private:
  char key_name[FKeyLength];  // Unique data key 
  INT32 class_id;             // Class ID number of the object
  INT32 object_address;       // Object's address in the database file
};

#endif  // __FKEY_HPP__ //
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
