// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer
// File Creation Date: 12/29/1996
// Date Last Modified: 03/17/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the generic doubly linked list
class implementation.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "dllist.h"
#include "ustring.h"

void pause()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

template<class TYPE>
inline void PrintList(DLList<TYPE> &List)
// Prints out the members of the list.
// Assumes TYPE can be written to output stream.
{
  DNode<TYPE> *ptr = List.GetFront();
  while(!List.IsHeader(ptr)) {
    cout << ptr->Data << endl;
    ptr = ptr->GetNext(); 
  }
}

template<class TYPE>
inline void RewindList(DLList<TYPE> &List)
// Prints out the members of the list.
// Assumes TYPE can be written to output stream.
{
  DNode<TYPE> *ptr = List.GetBack();
  while(!List.IsHeader(ptr)) {
    cout << ptr->Data << endl;
    ptr = ptr->GetPrior(); 
  }
}

main()
{
  DLList<UString> a, b;
  DNode<UString> *ptr;

  UString s1("The quick brown fox jumps over the lazy dog");
  UString s2("0123456789");
  UString s3("abcdefghijklmnopqrstuvwxyz");
  UString s4("!@#$%^&*()_+");
    
  cout << "Adding nodes to list ""a""..." << endl;
  a.StoreNode(s1);
  a.StoreNode(s2);
  a.StoreNode(s3);
  a.StoreNode(s4);
  
  cout << endl;
  PrintList(a);

  cout << endl;
  cout << "Adding nodes to list ""b""..." << endl;
  b.StoreNode(s1);
  b.StoreNode(s2);
  b.StoreNode(s3);
  b.StoreNode(s4);

  cout << endl;
  PrintList(b);

  pause();
  
  cout << "Rewinding list ""b""..." << endl;
  cout << endl;
  RewindList(b);
  
  pause();

  cout << "Testing copy constructor..." << endl;
  DLList<UString> c(b);

  cout << endl;
  PrintList(c);
  
  pause();

  cout << "Testing assignment operator..." << endl;
  DLList<UString>d;
  d = a;

  cout << endl;
  PrintList(d);

  pause();
  
  cout << "Testing concatenation functions..." << endl;
  a += b;

  cout << endl;
  PrintList(a);

  c.Cat(d);

  cout << endl;
  PrintList(c);
  
  pause();

  cout << "Testing Find function..." << endl;
  cout << "Looking for alphabet string..." << endl;

  ptr = (DNode<UString> *)a.Find(s3);
  if(ptr) cout << "Found: " << ptr->Data << " string." << endl;

  pause();

  cout << "Testing add functions..." << endl;
  a.Clear();

  UString s5("DOG");
  UString s6("CAT");
  UString s7("COW");
  UString s8("BIRD");
  UString s9("MOUSE");
  
  ptr = a.AddToBack(s5);
  a.AddToBack(s6);
  a.AddBefore(s7, ptr);
  a.AddAfter(s8, ptr);
  a.AddToFront(s9);

  PrintList(a);
  
  pause();

  cout << "Testing delete functions..." << endl;
  ptr = (DNode<UString> *)a.Find(s7);
  if(ptr) a.Delete(ptr);
  PrintList(a);
  cout << endl;
  a.DeleteFront();
  PrintList(a);
  cout << endl;
  a.DeleteBack();
  PrintList(a);

  pause();

  cout << "Testing GetNode functions..." << endl;
  UString *ListData;
  ListData = a.GetFrontNode();
  cout << *ListData << endl;
  ListData = a.GetBackNode();
  cout << *ListData << endl;
  
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
