#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program
# C/C++ Compiler Used: Microsoft Visual C/C++ 1.52 
# Produced By: Doug Gaer
# File Creation Date: 04/04/97
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	AL -- Compile for large model
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Define macros for compiler and linker
CC = cl
CPP = cl
LINKER = link

# Define compiler and linker flags macros
CFLAGS= /AL /Zi /W3
COMPILE_ONLY = /c
LFLAGS = /ONERROR:NOEXE /STACK:5120 

# Define additional file macros that will be linked to the project
OBJS =
MAPFILE =
LIBS =

# General inference rules
# ===============================================================
# Rule to make object files from C/C++ source code files
.c.obj:
	$(CC) $(CFLAGS) $(COMPILE_ONLY) $*.c

.cpp.obj:
	$(CPP) $(CFLAGS) $(COMPILE_ONLY) $*.cpp
# ===============================================================

# Build dependency rules
# ===============================================================
CHSLIST_DEP = chslist.h sllistb.h

CONFIG_DEP = chslist.h config.h sllistb.h

SLLISTB_DEP = sllistb.h

TESTPROG_DEP = chslist.h config.h sllistb.h 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

chslist.obj:	chslist.cpp $(CHSLIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) chslist.cpp

config.obj:	config.cpp $(CONFIG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) config.cpp

sllistb.obj:	sllistb.cpp $(SLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) sllistb.cpp

testprog.obj:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

# Make the executable
$(PROJECT).exe::  chslist.obj config.obj sllistb.obj testprog.obj 
	echo >NUL @<<$(PROJECT).CRF
chslist.obj+ 
config.obj+ 
sllistb.obj+ 
testprog.obj+ 
$(OBJS)
$(PROJECT).exe
$(MAPFILE) 
$(LIBS) 
$(DEFFILE);
<<
	$(LINKER) $(LFLAGS) @$(PROJECT).CRF 
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .MAP files from working directory...
	if exist *.map del *.map 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 
# ---------------------------------------------------------------
#####################
#### End of File ####
#####################
