#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program 
# C/C++ Compiler Used: GNU g++ 2.7.2.1 
# Produced By: Doug Gaer
# File Creation Date: 09/21/1997 
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#       -fhandle-exceptions -- Enable C++ exception handling
#       -frtti              -- Enable C++ Run-Time Type Information
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = testprog


# Setup additional paths for includes and source code
CDATE_PATH = ../../src/
EHANDLER_PATH = ../../src/
DTYPES_PATH = ../../src/

ADD_INC_PATHS = -I../../include

# Setup define macros
DEFMACS = -D__CONSOLE__ -D__USE_CPP_IOSTREAM__ #-DCPP_EXCEPTIONS

# Define macros for compiler and linker
CC = gcc
CPP = g++ 
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -fhandle-exceptions $(DEFMACS) $(ADD_INC_PATHS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS =  

# Build dependency rules
# ===============================================================
EHANDLER_DEP = ../../include/ehandler.h

UINT16_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/uint16.h

CDATE_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/uint16.h ../../include/cdate.h 

TESTPROG_DEP = ../../include/dtypes.h ../../include/ehandler.h \
		../../include/uint16.h ../../include/cdate.h 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

ehandler.o:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

uint16.o:	$(DTYPES_PATH)uint16.cpp $(UINT16_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint16.cpp

cdate.o:    $(CDATE_PATH)cdate.cpp $(CDATE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CDATE_PATH)cdate.cpp

# Make the executable
OBJS = ehandler.o uint16.o cdate.o testprog.o 

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
