#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program  
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2 
# Produced By: Doug Gaer
# File Creation Date: 03/21/1997 
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#       GX -- Enable C++ exception handling
#       GR -- Enable C++ Run-Time Type Information
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
CACHE_PATH = ../../src/
CACHE_PATH = ../../src/
EHANDLER_PATH = ../../src/
DTYPES_PATH = ../../src/
VBDFILE_PATH = ../../src/
REFCOUNT_PATH = ../../src/
CRC32_PATH = ../../src/
PLACENEW_PATH = ../../src/

ADD_INC_PATHS = -I../../include

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = /D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = /D__RECLAIM_FIRST_FIT__ 

DEFMACS = /D__CONSOLE__ /D__DOS__ $(DEF_VB_ALLOC) # /DCPP_EXCEPTIONS

# Define macros for compiler and linker
CC = cl
CPP = cl
LINKER = link

# Define compiler and linker flags macros
CFLAGS= /Zi /GX $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = /c
LFLAGS =  

# Build dependency rules
# ===============================================================
CRC32_DEP = ../../include/crc32.h ../../include/crc32tab.h

UINT32_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/uint32.h

BUCKET_DEP = ../../include/bucket.h ../../include/cacheb.h \
	../../include/cactype.h ../../include/ehandler.h \
	../../include/vbdfile.h ../../include/refcount.h \
	../../include/uint32.h

CACHE_DEP = ../../include/bucketb.h ../../include/cacheb.h \
	../../include/cactype.h ../../include/ehandler.h \
	../../include/vbdfile.h ../../include/refcount.h \
	../../include/uint32.h	

CACHEB_DEP = ../../include/bucketb.h ../../include/cacheb.h \
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/int32.h \
	../../include/dtypes.h ../../include/uint32.h

CHPTRB_DEP = ../../include/bucket.h ../../include/bucketb.h \
	../../include/cache.h ../../include/cacheb.h \
	../../include/chptrb.h ../../include/cactype.h\
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/int32.h \
	../../include/dtypes.h ../../include/uint32.h

CACSTATS_DEP = ../../include/bucketb.h ../../include/cacheb.h \
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/int32.h \
	../../include/dtypes.h ../../include/cacstats.h \
	../../include/uint32.h

EHANDLER_DEP = ../../include/ehandler.h

INT32_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/int32.h

VBDFILE_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/int32.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/uint32.h \
	../../include/crc32.h

TESTPROG_DEP = ../../include/bucket.h ../../include/bucketb.h \
	../../include/cache.h ../../include/cacheb.h \
	../../include/chptrb.h ../../include/cacheptr.h \
	../../include/ehandler.h ../../include/int32.h \
        ../../include/vbdfile.h ../../include/refcount.h \
	../../include/cacstats.h ../../include/uint32.h \
	../../include/cactype.h ../../include/placenew.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

uint32.obj:	$(DTYPES_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint32.cpp

crc32.obj:	$(CRC32_PATH)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CRC32_PATH)crc32.cpp

bucket.obj:	$(CACHE_PATH)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)bucket.cpp

cache.obj:	$(CACHE_PATH)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cache.cpp

cacheb.obj:	$(CACHE_PATH)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cacheb.cpp

chptrb.obj:	$(CACHE_PATH)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)chptrb.cpp

cacstats.obj:	$(CACHE_PATH)cacstats.cpp $(CACSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cacstats.cpp

ehandler.obj:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

int32.obj:	$(DTYPES_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)int32.cpp

vbdfile.obj:    $(VBDFILE_PATH)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdfile.cpp

vbdref.obj:	$(VBDFILE_PATH)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdref.cpp

testprog.obj:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

# Make the executable
OBJS = cacheb.obj chptrb.obj ehandler.obj vbdfile.obj \
	testprog.obj int32.obj bucket.obj cache.obj cacstats.obj \
	crc32.obj uint32.obj
 
$(PROJECT).exe:	$(OBJS)
	$(LINKER) $(LFLAGS) $(OBJS) /OUT:$@ 
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 

	@echo Removing any test files created during program execution
	if exist *.vbd del *.vbd
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


