#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for test program 
# C/C++ Compiler Used: DJGPP gcc 2.7.2.1 compiled for MSDOS 
# Produced By: Doug Gaer
# File Creation Date: 03/21/1997 
# Date Last Modified: 03/17/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#       -fhandle-exceptions -- Enable C++ exception handling
#       -frtti              -- Enable C++ Run-Time Type Information
#
# Linker flags using gcc or ld
#	-lgpp    -- C++ Linkage
#	-lstdcx  -- Needed for Exception Handling and RTTI
#	-lm      -- Needed for Exception Handling
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Define macros for compiler and linker
CC = gcc
CPP = gcc 
LINKER = ld

# Setup additional paths for includes and source code
BTREE_PATH = ../../src/
CACHE_PATH = ../../src/
EHANDLER_PATH = ../../src/
DTYPES_PATH = ../../src/
VBDFILE_PATH = ../../src/
REFCOUNT_PATH = ../../src/
PLACENEW_PATH = ../../src/
USTRING_PATH = ../../src/
STRUTIL_PATH = ../../src/
CRC32_PATH = ../../src/
SLLISTB_PATH = ../../src/
DLLISTB_PATH = ../../src/
STACK_PATH = ../../src/
QUEUE_PATH = ../../src/
TIMER_PATH = ../../src/

ADD_INC_PATHS = -I../../include

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = -D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = -D__RECLAIM_FIRST_FIT__ 

# Use this DEFMACS macro to compile without using template classes
# DEFMACS = -D__NOT_USING_TEMPLATE_CLASS__ -D__BTREE_MNODE__ -D__CONSOLE__ \
# -D__USE_VBDREFCOUNT__ -D__DOS__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Enable to use the template classes
DEFMACS = -D__CONSOLE__ -D__DOS__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Define compiler and linker flags macros
CFLAGS= -fhandle-exceptions $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
CPP_FLAG = -lgpp -lstdcx -lm            
LFLAGS =  

# Build dependency rules
# ===============================================================
SLLISTB_DEP = ../../include/sllistb.h

DLLISTB_DEP = ../../include/dllistb.h

BTWALKER_DEP = ../../include/bucket.h ../../include/bucketb.h \
	../../include/cache.h ../../include/cacheb.h \
	../../include/chptrb.h ../../include/cactype.h\
	../../include/cacheptr.h ../../include/btree.h \
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/placenew.h \
	../../include/int32.h  ../../include/dtypes.h \
	../../include/mnode.h ../../include/btreeprt.h \
	../../include/entrykey.h ../../include/sllistb.h \
	../../include/dllistb.h ../../include/dllist.h \
	../../include/stack.h ../../include/queue.h \
	../../include/strutil.h 

VBDSTATS_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/int32.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/uint32.h \
	../../include/crc32.h

CRC32_DEP = ../../include/crc32.h ../../include/crc32tab.h

UINT32_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/uint32.h

BUCKET_DEP = ../../include/bucket.h ../../include/cacheb.h \
	../../include/cactype.h ../../include/ehandler.h \
	../../include/vbdfile.h ../../include/mnode.h \
	../../include/refcount.h ../../include/mnode.h \
	../../include/uint32.h

CACHE_DEP = ../../include/bucketb.h ../../include/cacheb.h \
	../../include/cactype.h ../../include/ehandler.h \
	../../include/vbdfile.h ../../include/mnode.h \
	../../include/refcount.h ../../include/mnode.h \
	../../include/uint32.h	

CACHEB_DEP = ../../include/bucketb.h ../../include/cacheb.h \
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/int32.h \
	../../include/dtypes.h ../../include/uint32.h

CHPTRB_DEP = ../../include/bucket.h ../../include/bucketb.h \
	../../include/cache.h ../../include/cacheb.h \
	../../include/chptrb.h ../../include/cactype.h\
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/int32.h \
	../../include/dtypes.h ../../include/uint32.h

BTREE_DEP = ../../include/bucket.h ../../include/bucketb.h \
	../../include/cache.h ../../include/cacheb.h \
	../../include/chptrb.h ../../include/cactype.h\
	../../include/cacheptr.h ../../include/btree.h \
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/placenew.h \
	../../include/int32.h  ../../include/dtypes.h \
	../../include/mnode.h ../../include/entrykey.h \
	../../include/uint32.h ../../include/strutil.h

BTREEPRT_DEP = ../../include/bucket.h ../../include/bucketb.h \
	../../include/cache.h ../../include/cacheb.h \
	../../include/chptrb.h ../../include/cactype.h\
	../../include/cacheptr.h ../../include/btree.h \
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/placenew.h \
	../../include/int32.h  ../../include/dtypes.h \
	../../include/mnode.h ../../include/btreeprt.h \
	../../include/entrykey.h ../../include/uint32.h \
	../../include/strutil.h

BTWALK_DEP = ../../include/bucket.h ../../include/bucketb.h \
	../../include/cache.h ../../include/cacheb.h \
	../../include/chptrb.h ../../include/cactype.h\
	../../include/cacheptr.h ../../include/btree.h \
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/placenew.h \
	../../include/int32.h  ../../include/dtypes.h \
	../../include/mnode.h ../../include/btreeprt.h \
	../../include/entrykey.h ../../include/ustring.h \
	../../include/strutil.h ../../include/uint32.h

CACSTATS_DEP = ../../include/bucketb.h ../../include/cacheb.h \
	../../include/ehandler.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/int32.h \
	../../include/dtypes.h ../../include/cacstats.h \
	../../include/uint32.h

ENTRYKEY_DEP = ../../include/entrykey.h ../../include/dtypes.h \
	../../include/ehandler.h ../../include/int32.h \
	../../include/strutil.h 

MNODE_DEP = ../../include/mnode.h ../../include/dtypes.h \
	../../include/ehandler.h ../../include/int32.h \
	../../include/entrykey.h ../../include/strutil.h 

EHANDLER_DEP = ../../include/ehandler.h

INT32_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/int32.h

VBDFILE_DEP = ../../include/dtypes.h ../../include/ehandler.h \
	../../include/int32.h ../../include/vbdfile.h \
	../../include/refcount.h ../../include/uint32.h \
	../../include/crc32.h

VBDREF_DEP = ../../include/vbdfile.h \
	../../include/vbdref.h ../../include/refcount.h

USTRING_DEP = ../../include/ustring.h

STRUTIL_DEP = ../../include/strutil.h

TESTPROG_DEP = ../../include/bucket.h ../../include/bucketb.h \
	../../include/cache.h ../../include/cacheb.h \
	../../include/chptrb.h ../../include/cacheptr.h \
	../../include/cactype.h ../../include/btree.h \
	../../include/ehandler.h ../../include/int32.h \
        ../../include/vbdfile.h ../../include/refcount.h \
	../../include/placenew.h ../../include/mnode.h \
	../../include/btreeprt.h ../../include/entrykey.h \
	../../include/btwalk.h ../../include/cacstats.h \
	../../include/ustring.h ../../include/strutil.h \
	../../include/uint32.h ../../include/vbdstats.h \
	../../include/btwalker.h  ../../include/timer.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

btwalker.o:	$(BTREE_PATH)btwalker.cpp $(BTWALKER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BTREE_PATH)btwalker.cpp

sllistb.o:	$(SLLISTB_PATH)sllistb.cpp $(SLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(SLLISTB_PATH)sllistb.cpp

dllistb.o:	$(DLLISTB_PATH)dllistb.cpp $(DLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DLLISTB_PATH)dllistb.cpp

vbdstats.o:    $(VBDFILE_PATH)vbdstats.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdstats.cpp

uint32.o:	$(DTYPES_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint32.cpp

crc32.o:	$(CRC32_PATH)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CRC32_PATH)crc32.cpp

bucket.o:	$(CACHE_PATH)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)bucket.cpp

cache.o:	$(CACHE_PATH)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cache.cpp

cacheb.o:	$(CACHE_PATH)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cacheb.cpp

chptrb.o:	$(CACHE_PATH)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)chptrb.cpp

cacstats.o:	$(CACHE_PATH)cacstats.cpp $(CACSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cacstats.cpp

mnode.o:	$(BTREE_PATH)mnode.cpp $(MNODE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BTREE_PATH)mnode.cpp

entrykey.o:	$(BTREE_PATH)entrykey.cpp $(ENTRYKEY_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BTREE_PATH)entrykey.cpp

btree.o:	$(BTREE_PATH)btree.cpp $(BTREE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BTREE_PATH)btree.cpp

btreeprt.o:	$(BTREE_PATH)btreeprt.cpp $(BTREEPRT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BTREE_PATH)btreeprt.cpp

btwalk.o:	$(BTREE_PATH)btwalk.cpp $(BTWALK_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BTREE_PATH)btwalk.cpp

ehandler.o:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

int32.o:	$(DTYPES_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)int32.cpp

vbdfile.o:    $(VBDFILE_PATH)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdfile.cpp

vbdref.o:	$(VBDFILE_PATH)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdref.cpp

ustring.o:	$(USTRING_PATH)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(USTRING_PATH)ustring.cpp 

strutil.o:	$(STRUTIL_PATH)strutil.cpp $(STRUTIL_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(STRUTIL_PATH)strutil.cpp 

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

# Make the executable
OBJS = cacheb.o chptrb.o btree.o ehandler.o vbdfile.o \
	testprog.o mnode.o int32.o bucket.o cache.o \
	vbdref.o entrykey.o btreeprt.o cacstats.o \
	btwalk.o strutil.o ustring.o crc32.o uint32.o \
	vbdstats.o sllistb.o btwalker.o dllistb.o

$(PROJECT):	$(OBJS)
	$(CC) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) $(CPP_FLAG)
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing COFF file from working directory...
	rm -f $(PROJECT)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT).exe

	echo Removing any test files created by program
	rm -f *.btx
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
