// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: strdb_sh.h
// C++ Compiler Used: MSVC40 
// Produced By: Doug Gaer 
// File Creation Date: 12/16/1997 
// Date Last Modified: 03/18/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

General purpose search functions used with the string database.

Changes:
================================================================
10/09/1998: Removed the FlushCache() function used for flushing
the cache to keep the file in sync during multiple file access.
NOTE: The Btree class was modified to test the file to determine
when to flush the cache.
Changed by: Doug Gaer

10/09/1998: Removed the DummyLoad() function.
Changed by: Doug Gaer
*/
// ----------------------------------------------------------- //
#ifndef __STRDB_SH_HPP__
#define __STRDB_SH_HPP__

#include "strdb.h"
#include "dllist.h"
#include "btwalk.h"

enum StrDBItem { // Database items used in global database searches
  KEYMEMBER,
  M2NAME,
  M3NAME,
  M4NAME,
  M5NAME,
  M6NAME,
  M7NAME,
  M8NAME,
  COMMENTS
};

// Variable used to count the number of object found during a search
extern int ObjectsFound;

// Global data structures used to organize and store btree nodes
extern DLList<InMemCopy> StrDB_SH_DLList; // Doubly Linked
extern DLList<InMemCopy> *dllist;         // Doubly Linked
extern DNode<InMemCopy> *dllistptr;       // DLList node pointer

// Recursive functions used to search the btree.
void BtreeSearch(Btree *btx, int item, StrDB &strdb,
		 UString &str, int find_all = 0); 

void BtreeKeySearch(EntryKey &e, int item, StrDB &strdb, UString &str,
		    int find_all);

// Visit functions used by the btree iterator
void LoadKeys(EntryKey &e);

#endif  // __STRDB_SH_HPP__ 
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
