// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: strdb.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/17/1997  
// Date Last Modified: 03/18/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The StrDB class is a general purpose string database used to
represent one unique key member, 7 general purpose members,
and one comment block. All the string members can grow and
shrink as needed
*/
// ----------------------------------------------------------- //   
#include "strdb.h"
#include "strutil.h"

unsigned StrDB::ObjectLength()
{
  unsigned len = StringFileLength(KM) + \
    StringFileLength(M2) + \
    StringFileLength(M3)  + \
    StringFileLength(M4)  + \
    StringFileLength(M5)  + \
    StringFileLength(M6)  + \
    StringFileLength(M7)  + \
    StringFileLength(M8)  + \
    StringFileLength(CM);

  return len;
}

FAU StrDB::Write()
{
  ObjectHeader oh;

  FAU addr = pod->OpenDatabase()->Alloc(ObjectLength() + sizeof(ObjectHeader));
  if(!addr) return 0;
  
  oh.ClassID = GetClassID();
  oh.ObjectID = addr;
  WriteObjHeader(oh, addr);
  WriteString(KM);
  WriteString(M2);
  WriteString(M3);
  WriteString(M4);
  WriteString(M5);
  WriteString(M6);
  WriteString(M7);
  WriteString(M8);
  WriteString(CM);
  objectaddress = addr;  

  // Add the entry to the Index file
  if (UsingIndex()) {
    EntryKey key(KM.c_str(), oh.ObjectID, oh.ClassID);
    AddKey(key);
  }
  return addr;
}

void StrDB::Read(FAU Address)
{
  ObjectHeader oh;

  ReadObjHeader(oh, Address);
  if(oh.ClassID != GetClassID()) return; // Incorrect object type

  ReadString(KM);
  ReadString(M2);
  ReadString(M3);
  ReadString(M4);
  ReadString(M5);
  ReadString(M6);
  ReadString(M7);
  ReadString(M8);
  ReadString(CM);
  objectaddress = Address;
}

FAU StrDB::Find()
// Find object by seaching the database for its primary data members
{
  StrDB strdb;

  strdb.KM = this->KM; 
  strdb.M2 = this->M2;
  strdb.M3 = this->M3;
  strdb.M4 = this->M4;
  strdb.M5 = this->M5;
  strdb.M6 = this->M6;
  strdb.M7 = this->M7;
  strdb.M8 = this->M8;
  strdb.CM = this->CM;

  int rv; // Return value
 
  // Search the index file for this entry
  if(UsingIndex()) {
    EntryKey e(this->KM.c_str());
    rv = FindKey(e);
    if(rv) { // Found the object in the index file
      Read(e.object_address);
      return e.object_address;
    }
    else
      return 0;
  }

  FAU oa;          // Object Address
  VBHeader vb;     // Variable Block Header
  ObjectHeader oh; // Object Header
  
  FAU vbdfileEOF = pod->OpenDatabase()->GetEOF();
  FAU addr = 0;
  addr = pod->OpenDatabase()->FindFirstVB(addr); // Search the entire file

  if(addr == 0) return 0; // No variable blocks found in file
  
  while(1) { 
    if(addr >= vbdfileEOF) break;
    pod->OpenDatabase()->Read(&vb, sizeof(VBHeader), addr);
    if(vb.CkWord == CheckWord) {
      if((__SBYTE__)vb.Status == NormalVB) {
	oa = addr + sizeof(VBHeader);
	ReadObjHeader(oh, oa);
	if(oh.ClassID == GetClassID()) { 
	  Read(oa);
	  if(KM == strdb.KM) {
	    objectaddress = oa;
	    return oa; // Found unique data member
	  }
	}
      }
      addr = addr + vb.Length; // Goto the next variable block
    }
    else {
      addr = pod->OpenDatabase()->VBSearch(addr); 
      if(!addr) break;
    }
  }

  // Reset the objects data
  this->KM = strdb.KM;
  this->M2 = strdb.M2;
  this->M3 = strdb.M3;
  this->M4 = strdb.M4;
  this->M5 = strdb.M5;
  this->M6 = strdb.M6;
  this->M7 = strdb.M7;
  this->M8 = strdb.M8;
  this->CM = strdb.CM;
  
  return 0; // Could not find 
}

void StrDB::Copy(const StrDB &ob)
{
  KM = ob.KM;
  M2 = ob.M2;
  M3 = ob.M3;
  M4 = ob.M4;
  M5 = ob.M5;
  M6 = ob.M6;
  M7 = ob.M7;
  M8 = ob.M8;
  CM = ob.CM;
  objectaddress = ob.objectaddress;
}

int StrDB::FullCompare(const StrDB &ob)
{
  if(KM != ob.KM) return 0;
  if(M2 != ob.M2) return 0;
  if(M3 != ob.M3) return 0;
  if(M4 != ob.M4) return 0;
  if(M5 != ob.M5) return 0;
  if(M6 != ob.M6) return 0;
  if(M7 != ob.M7) return 0;
  if(M8 != ob.M8) return 0;
  if(CM != ob.CM) return 0;
  return 1;
}

int operator==(const StrDB &a, const StrDB &b)
{
  return CaseICmp(a.GetKM(), b.GetKM()) == 0;
}

int operator!=(const StrDB &a, const StrDB &b)
{
  return CaseICmp(a.GetKM(), b.GetKM()) != 0;
}

int operator>(const StrDB &a, const StrDB &b)
{
  return CaseICmp(a.GetKM(), b.GetKM()) > 0;
}

int operator>=(const StrDB &a, const StrDB &b)
{
  return CaseICmp(a.GetKM(), b.GetKM()) >= 0;
}
  
int operator<(const StrDB &a, const StrDB &b)
{
  return CaseICmp(a.GetKM(), b.GetKM()) < 0;
}
  
int operator<=(const StrDB &a, const StrDB &b)
{
  return CaseICmp(a.GetKM(), b.GetKM()) <= 0;
}

FAU StrDB::Delete()
{
  if(UsingIndex()) {
    EntryKey e(this->KM.c_str());
    int rv = FindKey(e);
    if(rv) {  // Found the object in the index file
      FAU addr = e.object_address;
      DeleteObject(e.object_address); // Delete from the data file
      RemoveKey(e);                   // Remove from the index file
      return addr;
    }
    else
      return 0; // Could not delete
  }

  FAU addr = Find();
  if(!addr) return 0; // Object does not exist
  DeleteObject(addr);
  return addr;
}

FAU StrDB::Remove()
{
  if(UsingIndex()) {
    EntryKey e(this->KM.c_str());
    int rv = FindKey(e);
    if(rv) {  // Found the object in the index file
      FAU addr = e.object_address;
      RemoveObject(e.object_address); // Remove from the data file
      RemoveKey(e);                   // Remove from the index file
      return addr;
    }
    else
      return 0; // Could not remove
  }

  FAU addr = Find();
  if(!addr) return 0; // Object does not exist
  RemoveObject(addr);
  return addr;
}

int StrDB::CompareIndex()
// Compares the data file to the index file.
// Returns true if data and index file match.
{
  if(!UsingIndex()) return 0;

  StrDB strdb(pod);
  EntryKey key;
  
  FAU oa;          // Object Address
  VBHeader vb;     // Variable Block Header
  ObjectHeader oh; // Object Header
  
  int objects = 0; // Keeps track of good variable blocks
  int matches = 0; // Keep track of matches
  
  FAU vbdfileEOF = pod->OpenDatabase()->GetEOF();
  FAU addr = 0;
  addr = pod->OpenDatabase()->FindFirstVB(addr); // Search the entire file

  if(addr == 0) { // No variable blocks found in file
#ifdef CPP_EXCEPTIONS
    throw CNoObjectsExist();
#else
    Error->SignalException(EHandler::NoObjectsExist, EHandler::DISPLAY);
    return 0;
#endif
  }
  
  while(1) { 
    if(addr >= vbdfileEOF) break;
    pod->OpenDatabase()->Read(&vb, sizeof(VBHeader), addr);
    if(vb.CkWord == CheckWord) {
      if((__SBYTE__)vb.Status == NormalVB) {
	objects++; // Increment the object count
	oa = addr + sizeof(VBHeader);
	ReadObjHeader(oh, oa);
	if(oh.ClassID == GetClassID()) { 
	  strdb.Read(oa);
	  key.SetStrKey(strdb.GetKM());
	  key.SetOA(oa);
	  key.SetCID(oh.ClassID);
	  int rv = FindKey(key, 1);
	  if(rv) matches++; // Index and data file match
	}
      }
      addr = addr + vb.Length; // Goto the next variable block
    }
    else {
      addr = pod->OpenDatabase()->VBSearch(addr); 
      if(!addr) break;
    }
  }

  return objects == matches;
}

int StrDB::RebuildIndexFile(const char *fname)
{
  if(!UsingIndex()) return 0;

  int rv; // (R)eturn (V)alue
  int CacheSize = 15;

  VBDFilePtr f(new VBDFile);
  Btree btx(CacheSize);
  f->Create(fname, sizeof(BtreeHeader));
  btx.Connect(f, 1);
  
  StrDB strdb(pod);
  EntryKey key;
  
  FAU oa;          // Object Address
  VBHeader vb;     // Variable Block Header
  ObjectHeader oh; // Object Header
  
  int objects = 0; // Keeps track of good variable blocks
  int inserts = 0; // Keep track of inserts
  
  FAU vbdfileEOF = pod->OpenDatabase()->GetEOF();
  FAU addr = 0;
  addr = pod->OpenDatabase()->FindFirstVB(addr); // Search the entire file

  if(addr == 0) { // No variable blocks found in file
#ifdef CPP_EXCEPTIONS
    throw CNoObjectsExist();
#else
    Error->SignalException(EHandler::NoObjectsExist, EHandler::DISPLAY);
    return 0;
#endif
  }
  
  while(1) { 
    if(addr >= vbdfileEOF) break;
    pod->OpenDatabase()->Read(&vb, sizeof(VBHeader), addr);
    if(vb.CkWord == CheckWord) {
      if((__SBYTE__)vb.Status == NormalVB) {
	objects++; // Increment the object count
	oa = addr + sizeof(VBHeader);
	ReadObjHeader(oh, oa);
	if(oh.ClassID == GetClassID()) { 
	  strdb.Read(oa);
	  key.SetStrKey(strdb.GetKM());
	  key.SetOA(oa);
	  key.SetCID(oh.ClassID);
	  rv = btx.Add(key);
	  if(!rv) { 
#ifdef CPP_EXCEPTIONS
	    throw CAssertError();
#else
	  Error->SignalException(EHandler::AssertError);
#endif
	  }
	  else
	    inserts++; // Index and data file match
	}
      }
      addr = addr + vb.Length; // Goto the next variable block
    }
    else {
      addr = pod->OpenDatabase()->VBSearch(addr); 
      if(!addr) break;
    }
  }

  return objects == inserts;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
// ------------------------------- //
