#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the database program  
# C/C++ Compiler Used: DJGPP gcc 2.7.2.1 compiled for MSDOS 
# Produced By: Doug Gaer
# File Creation Date: 09/18/1997 
# Date Last Modified: 03/29/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#       -fhandle-exceptions -- Enable C++ exception handling
#       -frtti              -- Enable C++ Run-Time Type Information
#
# Linker flags using gcc or ld
#	-lgpp    -- C++ Linkage
#	-lstdcx  -- Needed for Exception Handling and RTTI
#	-lm      -- Needed for Exception Handling
# --------------------------------------------------------------- 
# Define this macro in the main makefile for this application
# Name for the executable
PROJECT = strdbt

# Define this macro in the main makefile for this application
# Installation directory for the application and config files
INSTALL_DIR = ..\bin

# Define the $(VBDDIR) macro in the main makefile for this application
# Setup path for VBD Base installation directory
# NOTE: You must use Unix-style slashes for djgpp make utility.
VBDDIR = $(VBDPATH)

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
DBCONFIG_PATH = ..$(PATHSEP)config
APP_PATH = $(VBDDIR)$(PATHSEP)contrib$(PATHSEP)strdb$(PATHSEP)curses
STRDB_PATH = $(VBDDIR)$(PATHSEP)contrib$(PATHSEP)strdb$(PATHSEP)src
QUEUE_PATH = $(VBDDIR)$(PATHSEP)src
STACK_PATH = $(VBDDIR)$(PATHSEP)src
BTREE_PATH = $(VBDDIR)$(PATHSEP)src
CACHE_PATH = $(VBDDIR)$(PATHSEP)src
EHANDLER_PATH = $(VBDDIR)$(PATHSEP)src
DTYPES_PATH = $(VBDDIR)$(PATHSEP)src
REFCOUNT_PATH = $(VBDDIR)$(PATHSEP)src
USTRING_PATH = $(VBDDIR)$(PATHSEP)src
VBDFILE_PATH = $(VBDDIR)$(PATHSEP)src
SLLISTB_PATH = $(VBDDIR)$(PATHSEP)src
STRUTIL_PATH = $(VBDDIR)$(PATHSEP)src
CONFIG_PATH = $(VBDDIR)$(PATHSEP)src
CHSLIST_PATH = $(VBDDIR)$(PATHSEP)src
POD_PATH = $(VBDDIR)$(PATHSEP)src
PERSIST_PATH = $(VBDDIR)$(PATHSEP)src
TIMER_PATH = $(VBDDIR)$(PATHSEP)src
PLACENEW_PATH = $(VBDDIR)$(PATHSEP)src
DLLISTB_PATH = $(VBDDIR)$(PATHSEP)src
TERMINAL_PATH = $(VBDDIR)$(PATHSEP)src
PSCRIPT_PATH = $(VBDDIR)$(PATHSEP)src
CRC32_PATH = $(VBDDIR)$(PATHSEP)src
ASPRINT_PATH = $(VBDDIR)$(PATHSEP)src
HTMLDRV_PATH = $(VBDDIR)$(PATHSEP)src

ADD_INC_PATHS = -I$(VBDDIR)$(PATHSEP)include -I$(VBDDIR)$(PATHSEP)contrib$(PATHSEP)strdb$(PATHSEP)src -I$(DBCONFIG_PATH)

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = -D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = -D__RECLAIM_FIRST_FIT__ 

# Use this DEFMACS macro to compile without using templates
DEFMACS = -D__NOT_USING_TEMPLATE_CLASS__ -D__BTREE_MNODE__ -D__CURSES__ \
-D__USE_VBDREFCOUNT__ -D__DOS__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Define macros for compiler and linker
AC     = gcc   # ANSI c compiler
CPP    = gcc   # C++ compiler
LINKER = ld    # Linker

# Define compiler and linker flags macros
COMPILE_FLAGS= -fhandle-exceptions $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
CPP_FLAG = -lgpp -lstdcx -lm        
LINK_FLAGS =  

# Build dependency rules
# ===============================================================
HTMLDRV_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)htmldrv.h 

VBDSTATS_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)terminal.h

CRC32_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)crc32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)crc32tab.h 

UINT32_DEP =  $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h

BUCKET_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

CACHE_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

CACHEB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

CHPTRB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

MNODE_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h

ENTRYKEY_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)strutil.h

BTREE_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h

POD_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)pod.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

PERSIST_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)pod.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)persist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)crc32.h 


EHANDLER_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)terminal.h

VBDFILE_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)crc32.h 

INT32_DEP =  $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h

VBDREF_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdref.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h

USTRING_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)ustring.h


SLLISTB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h

STRDB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(STRDB_PATH)$(PATHSEP)strdb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)persist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)pod.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdref.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ustring.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(DBCONFIG_PATH)$(PATHSEP)dbvers.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

ASPRINT_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)asprint.h

STRDBT_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(STRDB_PATH)$(PATHSEP)strdb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)persist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)pod.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdref.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ustring.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chslist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)config.h \
	$(DBCONFIG_PATH)$(PATHSEP)dbconfig.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)timer.h \
	$(DBCONFIG_PATH)$(PATHSEP)dbvers.h \
	$(STRDB_PATH)$(PATHSEP)version.h \
	$(DBCONFIG_PATH)$(PATHSEP)dbtcfg.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)asprint.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btwalk.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)queue.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)stack.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)strutil.h \
	$(STRDB_PATH)$(PATHSEP)strdb_sh.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)terminal.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btwalker.h  \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdstats.h

TERMINAL_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)terminal.h

STRDB_SH_DEP = $(STRDB_PATH)$(PATHSEP)strdb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)persist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)pod.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdref.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(DBCONFIG_PATH)$(PATHSEP)dbvers.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h \
	$(DBCONFIG_PATH)$(PATHSEP)dbvers.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btwalk.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)queue.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)stack.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ustring.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btwalker.h 

CONFIG_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)chslist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)config.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h

STRUTIL_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)strutil.h 

DLLISTB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)dllistb.h

CHSLIST_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)chslist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h

BTWALK_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btwalk.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ustring.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)strutil.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h	

BTWALKER_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h  \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btreeprt.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)stack.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)queue.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)strutil.h 

PSCRIPT_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)pscript.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

htmldrv.o:	$(HTMLDRV_PATH)$(PATHSEP)htmldrv.cpp $(HTMLDRV_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(HTMLDRV_PATH)$(PATHSEP)htmldrv.cpp

btwalker.o:	$(BTREE_PATH)$(PATHSEP)btwalker.cpp $(BTWALKER_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)btwalker.cpp

vbdstats.o:	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp $(VBDSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp

uint32.o:	$(DTYPES_PATH)$(PATHSEP)uint32.cpp $(UINT31_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint32.cpp

crc32.o:	$(CRC32_PATH)$(PATHSEP)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CRC32_PATH)$(PATHSEP)crc32.cpp

bucket.o:	$(CACHE_PATH)$(PATHSEP)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)bucket.cpp

cache.o:	$(CACHE_PATH)$(PATHSEP)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)cache.cpp

cacheb.o:	$(CACHE_PATH)$(PATHSEP)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)cacheb.cpp

chptrb.o:	$(CACHE_PATH)$(PATHSEP)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)chptrb.cpp

mnode.o:	$(BTREE_PATH)$(PATHSEP)mnode.cpp $(MNODE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)mnode.cpp

entrykey.o:	$(BTREE_PATH)$(PATHSEP)entrykey.cpp $(ENTRYKEY_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)entrykey.cpp

btree.o:	$(BTREE_PATH)$(PATHSEP)btree.cpp $(BTREE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)btree.cpp

ehandler.o:	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp

vbdfile.o:	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp

strdbt.o:	$(APP_PATH)$(PATHSEP)strdbt.cpp $(STRDBT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(APP_PATH)$(PATHSEP)strdbt.cpp

ustring.o:	$(USTRING_PATH)$(PATHSEP)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(USTRING_PATH)$(PATHSEP)ustring.cpp

int32.o:	$(DTYPES_PATH)$(PATHSEP)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)int32.cpp

sllistb.o:	$(SLLISTB_PATH)$(PATHSEP)sllistb.cpp $(SLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.cpp

dllistb.o:	$(DLLISTB_PATH)$(PATHSEP)dllistb.cpp $(DLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DLLISTB_PATH)$(PATHSEP)dllistb.cpp

vbdref.o:	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp

pod.o:	$(POD_PATH)$(PATHSEP)pod.cpp $(POD_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(POD_PATH)$(PATHSEP)pod.cpp

persist.o:	$(PERSIST_PATH)$(PATHSEP)persist.cpp $(PERSIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(PERSIST_PATH)$(PATHSEP)persist.cpp

strdb.o:	$(STRDB_PATH)$(PATHSEP)strdb.cpp $(STRDB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(STRDB_PATH)$(PATHSEP)strdb.cpp

chslist.o:	$(CHSLIST_PATH)$(PATHSEP)chslist.cpp $(CHSLIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CHSLIST_PATH)$(PATHSEP)chslist.cpp

config.o:	$(CONFIG_PATH)$(PATHSEP)config.cpp $(CONFIG_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CONFIG_PATH)$(PATHSEP)config.cpp

strutil.o:	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp $(STRUTIL_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp

asprint.o:	$(ASPRINT_PATH)$(PATHSEP)asprint.cpp $(ASPRINT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(ASPRINT_PATH)$(PATHSEP)asprint.cpp

strdb_sh.o:	$(STRDB_PATH)$(PATHSEP)strdb_sh.cpp $(STRDB_SH_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(STRDB_PATH)$(PATHSEP)strdb_sh.cpp

btwalk.o:	$(BTREE_PATH)$(PATHSEP)btwalk.cpp $(BTWALK_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)btwalk.cpp

terminal.o:	$(TERMINAL_PATH)$(PATHSEP)terminal.cpp $(TERMINAL_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(TERMINAL_PATH)$(PATHSEP)terminal.cpp

pscript.o:	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp $(PSCRIPT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp

# Make the executable
OBJECTS = ehandler.o int32.o vbdfile.o asprint.o persist.o \
	ustring.o pod.o strdb.o sllistb.o chslist.o \
	config.o vbdref.o cacheb.o chptrb.o btree.o \
	mnode.o bucket.o cache.o entrykey.o dllistb.o \
	strdbt.o strutil.o btwalk.o btwalker.o strdb_sh.o \
	terminal.o pscript.o uint32.o crc32.o vbdstats.o \
	htmldrv.o

$(PROJECT):	$(OBJECTS)
	$(CC) $(CFLAGS) $(OBJECTS) $(OUTPUT) $(PROJECT) $(CPP_FLAG)
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing COFF file from working directory...
	rm -f $(PROJECT)

	echo Removing the EXECUTABLE file from working directory
	rm -f $(PROJECT).exe 
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
