// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: mtank_sh.h
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 12/16/1997 
// Date Last Modified: 03/18/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/* 
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

General purpose search functions used with the marine tank
database.
*/
// ----------------------------------------------------------- //
#ifndef __MTANK_SH_HPP__
#define __MTANK_SH_HPP__

#include "mtank.h"
#include "cdate.h"
#include "rbtree.h"
#include "dllist.h"
#include "btwalk.h"

// This class is used as a container to store the entry keys in
// memory with as little overhead as possible.
class MTankInMemCopy
{
public:
  MTankInMemCopy() { }
  ~MTankInMemCopy() { }
  MTankInMemCopy(char *k, INT32 oa, INT32 cid);
  
  MTankInMemCopy(const MTankInMemCopy &ob) {
    date = ob.date;
    object_address = ob.object_address;
    class_id = ob.class_id;
  }
  
  void operator=(const MTankInMemCopy &ob) { 
    date = ob.date;
    object_address = ob.object_address;
    class_id = ob.class_id;
  }
  
public:
  friend int operator==(const MTankInMemCopy &a, const MTankInMemCopy &b) {
    return a.date == b.date;
  }
  
  friend int operator!=(const MTankInMemCopy &a, const MTankInMemCopy &b) {
    return a.date != b.date;
  }
  
  friend int operator<(const MTankInMemCopy &a, const MTankInMemCopy &b) {
    return a.date < b.date;
  }
  
public:
  CDate date;           // Unique data key 
  INT32 object_address; // Object's address in the database file
  INT32 class_id;       // Class ID number of the object 
};

enum MTankDBItem { // Database items used in global database searches
  YEAR,
  COMMENTS
};

// Variable used to count the number of object found during a search
extern int ObjectsFound;

// Global data structures used to organize and store btree nodes
extern DLList<MTankInMemCopy> MTankDB_SH_DLList; // Doubly Linked
extern DLList<MTankInMemCopy> *dllist;           // Doubly Linked
extern DNode<MTankInMemCopy> *dllistptr;         // DLList node pointer
extern RBTree<MTankInMemCopy> MTankDB_SH_RBTree; // Red Black mem based tree
extern RBTree<MTankInMemCopy> *rbtree;           // Red Black mem based tree

// SearchVisitFunc is a function pointer used for a visit action that
// searches each btree node for a specified string database item. All
// visit actions define a procedure used to process node data.
typedef void (*SearchVisitFunc)(CachePointer Node, int item, MarineTank &mtank,
				UString &str, int find_all); 

// Recursive functions used to search the btree.
void BtreeSearch(CachePointer t, SearchVisitFunc Visit, int item,
                 MarineTank &mtank, UString &str, int find_all = 0); 

// Visit functions used by the btree iterator
void LoadKeys(CachePointer n);
void BtreeNodeSearch(CachePointer n, int item, MarineTank &mtank, UString &str,
		     int find_all);

#endif  // __MTANK_SH_HPP__ 
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

