// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: groc_sh.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 12/16/1997 
// Date Last Modified: 03/18/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

General purpose search functions used with the mtank list
database.
*/
// ----------------------------------------------------------- //
#include <stdlib.h>
#include "mtank_sh.h"

// Global data structures used to organize and store btree nodes
DLList<MTankInMemCopy> MTankDB_SH_DLList;            // Doubly Linked
DLList<MTankInMemCopy> *dllist = &MTankDB_SH_DLList; // Doubly Linked
DNode<MTankInMemCopy> *dllistptr = 0;                // DLList node pointer
RBTree<MTankInMemCopy> MTankDB_SH_RBTree;            // Red Black tree
RBTree<MTankInMemCopy> *rbtree = &MTankDB_SH_RBTree; // Red Black tree

// Variable used to count the number of object found during a search
int ObjectsFound = 0;

MTankInMemCopy::MTankInMemCopy(char *k, INT32 oa, INT32 cid)
{
  char date_words[MAXWORDS][MAXWORDLENGTH];
  int num;
  parse(k, date_words, &num, '/');
  date.SetDate(atoi(date_words[0]), atoi(date_words[1]),
	       atoi(date_words[2])); 
  object_address = oa;
  class_id = cid;
}

void LoadKeys(CachePointer n)
// Visit function used to load the btree nodes into memory
{
  int i = 0;

  while (i < n->cnt) {
    MTankInMemCopy buf(n->entry[i].key,
		  n->entry[i].object_address,
		  n->entry[i].class_id);

    rbtree->Add(buf);
    i++;
  }
}

void BtreeSearch(CachePointer t, SearchVisitFunc Visit, int item,
                 MarineTank &mtank, UString &str, int find_all) 
// Recursive functions used to search the btree for a specified.
{
  int i;

  if ((__LWORD__)t) {
    (*Visit)(t, item, mtank, str, find_all); // Process the node data
    int n = t->cnt;
    CachePointer p(t);

    for(i = -1; i < n; i++) {
      p = t->Branch(i);
      t.Release();
        BtreeSearch(p, Visit, item, mtank, str, find_all);  
    }
  }
}

void BtreeNodeSearch(CachePointer n, int item, MarineTank &mtank, UString &str,
		     int find_all)
// Visit function used to search each node for a specified item
{
  int i = 0;
  int offset;
  UString buf;

  if(item == YEAR) {
    while (i < n->cnt) {
      buf = n->entry[i].key;
      
      if(find_all == 0) { // Search for single match
	int result = CaseICmp(buf, str);
	if(result == 0) { 
	  MTankInMemCopy inmemcopy(n->entry[i].key,
			      n->entry[i].object_address,
			      n->entry[i].class_id);
	  rbtree->Add(inmemcopy);
	  ObjectsFound++;
	}
      }
      else { // Search for all matches
	offset = buf.Find(str.c_str(), 0);
	if(offset != UString::NoMatch) {
	  MTankInMemCopy inmemcopy(n->entry[i].key,
				   n->entry[i].object_address,
				   n->entry[i].class_id);
	  rbtree->Add(inmemcopy);
	  ObjectsFound++;
	}
      }
      i++;
    }
  }
  else {
    while (i < n->cnt) {
      mtank.ReadObject(n->entry[i].object_address);
      switch(item) {
	case COMMENTS:
          buf = mtank.GetComments();
	  break;
	default:
	  return;
      }
      if(find_all == 0) { // Search for single match
	int result = CaseICmp(buf, str);
	if(result == 0) { 
	  MTankInMemCopy inmemcopy(n->entry[i].key,
			      n->entry[i].object_address,
			      n->entry[i].class_id);
	  rbtree->Add(inmemcopy);
	  ObjectsFound++;
	}
      }
      else { // Search for all matches
	offset = buf.Find(str.c_str(), 0);
	if(offset != UString::NoMatch) {
	  MTankInMemCopy inmemcopy(n->entry[i].key,
			      n->entry[i].object_address,
			      n->entry[i].class_id);
	  rbtree->Add(inmemcopy);
	  ObjectsFound++;
	}
      }
      i++;
    }
  }
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

