#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the database program  
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2
# Produced By: Doug Gaer
# File Creation Date: 09/18/1997 
# Date Last Modified: 03/18/1999
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#       GX -- Enable C++ exception handling
#       GR -- Enable C++ Run-Time Type Information
# 	Zp -- Byte align structures (leave no gaps between members)
# --------------------------------------------------------------- 
# Define this macro in the main makefile for this application
# Name for the executable
PROJECT = mtank

# Define this macro in the main makefile for this application
# Installation directory for the application and config files
INSTALL_DIR = ..\bin

# Define the $(VBDDIR) macro in the main makefile for this application
# Setup path for VBD Base installation directory
# My directory path for the VBD class library.
VBDDIR = $(VBDPATH)

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
APP_PATH = .
MTANK_PATH = ..$(PATHSEP)src
CDATE_PATH = $(VBDDIR)$(PATHSEP)src
QUEUE_PATH = $(VBDDIR)$(PATHSEP)src
STACK_PATH = $(VBDDIR)$(PATHSEP)src
RBTREE_PATH = $(VBDDIR)$(PATHSEP)src
BTREE_PATH = $(VBDDIR)$(PATHSEP)src
CACHE_PATH = $(VBDDIR)$(PATHSEP)src
EHANDLER_PATH = $(VBDDIR)$(PATHSEP)src
DTYPES_PATH = $(VBDDIR)$(PATHSEP)src
REFCOUNT_PATH = $(VBDDIR)$(PATHSEP)src
USTRING_PATH = $(VBDDIR)$(PATHSEP)src
VBDFILE_PATH = $(VBDDIR)$(PATHSEP)src
SLLISTB_PATH = $(VBDDIR)$(PATHSEP)src
STRUTIL_PATH = $(VBDDIR)$(PATHSEP)src
CONFIG_PATH = $(VBDDIR)$(PATHSEP)src
CHSLIST_PATH = $(VBDDIR)$(PATHSEP)src
POD_PATH = $(VBDDIR)$(PATHSEP)src
PERSIST_PATH = $(VBDDIR)$(PATHSEP)src
TIMER_PATH = $(VBDDIR)$(PATHSEP)src
PLACENEW_PATH = $(VBDDIR)$(PATHSEP)src
DLLISTB_PATH = $(VBDDIR)$(PATHSEP)src
TERMINAL_PATH = $(VBDDIR)$(PATHSEP)src
PSCRIPT_PATH = $(VBDDIR)$(PATHSEP)src
CRC32_PATH = $(VBDDIR)$(PATHSEP)src
ASPRINT_PATH = $(VBDDIR)$(PATHSEP)src

ADD_INC_PATHS = -I$(VBDDIR)$(PATHSEP)include -I..$(PATHSEP)src

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = /D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = /D__RECLAIM_FIRST_FIT__ 

# Use this DEFMACS macro to compile without using template classes
DEFMACS = /D__NOT_USING_TEMPLATE_CLASS__ /D__BTREE_MNODE__ \
/D__CURSES__ /D__USE_VBDREFCOUNT__ /D__DOS__ /D__X86__ \
$(DEF_VB_ALLOC) # /DCPP_EXCEPTIONS

# Define macros for compiler and linker
AC     = cl   # ANSI c compiler
CPP    = cl   # C++ compiler
LINKER = link # Linker

# Compiler and linker flags 
COMPILE_FLAGS= /GX /W3 $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = /c
LINK_FLAGS = 
LINK_LIBS = 

# Build dependency rules
# ===============================================================
VBDSTATS_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)terminal.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdstats.h

CRC32_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)crc32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)crc32tab.h 

UINT32_DEP =  $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h

BUCKET_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

CACHE_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

CACHEB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

CHPTRB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

MNODE_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h

ENTRYKEY_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h 

BTREE_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

POD_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)pod.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

PERSIST_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)pod.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)persist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

EHANDLER_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)terminal.h

VBDFILE_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)crc32.h 

INT32_DEP =  $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h

VBDREF_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdref.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h

USTRING_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)ustring.h


SLLISTB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h

MTANK_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(MTANK_PATH)$(PATHSEP)mtank.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)float64.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)persist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)pod.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdref.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ustring.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint16.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cdate.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

ASPRINT_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)asprint.h

FLOAT64_DEP =  $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)float64.h

MAIN_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(MTANK_PATH)$(PATHSEP)mtank.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)float64.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)persist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)pod.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdref.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ustring.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chslist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)config.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)timer.h \
	$(MTANK_PATH)$(PATHSEP)version.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)asprint.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btwalk.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)queue.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)stack.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bnodeb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bstreeb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)rbnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)rbtree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)rbtreeb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)twalk.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)strutil.h \
	$(MTANK_PATH)$(PATHSEP)dbconfig.h \
	$(MTANK_PATH)$(PATHSEP)mtank_sh.h  \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint16.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cdate.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)terminal.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdstats.h

TERMINAL_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)terminal.h

MTANK_SH_DEP = $(MTANK_PATH)$(PATHSEP)mtank.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)float64.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)persist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)pod.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdref.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btwalk.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)queue.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)stack.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bnodeb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bstreeb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)rbnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)rbtree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)rbtreeb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)twalk.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint16.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cdate.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ustring.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

CONFIG_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)chslist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)config.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h

STRUTIL_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)strutil.h 

DLLISTB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)dllistb.h

CHSLIST_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)chslist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h

BTWALK_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btwalk.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ustring.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)strutil.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

BNODEB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bnodeb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)queue.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)stack.h

BSTREEB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bnodeb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bstreeb.h 

RBTREEB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bnodeb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bstreeb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)queue.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)rbnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)rbtree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)rbtreeb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)stack.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)twalk.h

TWALK_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bnodeb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)queue.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)rbnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)stack.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)twalk.h

PSCRIPT_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)pscript.h

CDATE_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cdate.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint16.h

UINT16_DEP =  $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint16.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

vbdstats.obj:	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp $(VBDSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp

uint32.obj:	$(DTYPES_PATH)$(PATHSEP)uint32.cpp $(UINT31_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint32.cpp

crc32.obj:	$(CRC32_PATH)$(PATHSEP)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CRC32_PATH)$(PATHSEP)crc32.cpp

bnodeb.obj:	$(RBTREE_PATH)$(PATHSEP)bnodeb.cpp $(BNODEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(RBTREE_PATH)$(PATHSEP)bnodeb.cpp

bstreeb.obj:	$(RBTREE_PATH)$(PATHSEP)bstreeb.cpp $(BSTREEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(RBTREE_PATH)$(PATHSEP)bstreeb.cpp

rbtreeb.obj:	$(RBTREE_PATH)$(PATHSEP)rbtreeb.cpp $(RBTREEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(RBTREE_PATH)$(PATHSEP)rbtreeb.cpp

twalk.obj:	$(RBTREE_PATH)$(PATHSEP)twalk.cpp $(TWALK_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(RBTREE_PATH)$(PATHSEP)twalk.cpp

bucket.obj:	$(CACHE_PATH)$(PATHSEP)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)bucket.cpp

cache.obj:	$(CACHE_PATH)$(PATHSEP)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)cache.cpp

cacheb.obj:	$(CACHE_PATH)$(PATHSEP)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)cacheb.cpp

chptrb.obj:	$(CACHE_PATH)$(PATHSEP)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)chptrb.cpp

mnode.obj:	$(BTREE_PATH)$(PATHSEP)mnode.cpp $(MNODE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)mnode.cpp

entrykey.obj:	$(BTREE_PATH)$(PATHSEP)entrykey.cpp $(ENTRYKEY_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)entrykey.cpp

btree.obj:	$(BTREE_PATH)$(PATHSEP)btree.cpp $(BTREE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)btree.cpp

ehandler.obj:	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp

vbdfile.obj:	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp

main.obj:	$(APP_PATH)$(PATHSEP)main.cpp $(MAIN_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(APP_PATH)$(PATHSEP)main.cpp

ustring.obj:	$(USTRING_PATH)$(PATHSEP)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(USTRING_PATH)$(PATHSEP)ustring.cpp

int32.obj:	$(DTYPES_PATH)$(PATHSEP)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)int32.cpp

sllistb.obj:	$(SLLISTB_PATH)$(PATHSEP)sllistb.cpp $(SLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.cpp

dllistb.obj:	$(DLLISTB_PATH)$(PATHSEP)dllistb.cpp $(DLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DLLISTB_PATH)$(PATHSEP)dllistb.cpp

vbdref.obj:	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp

pod.obj:	$(POD_PATH)$(PATHSEP)pod.cpp $(POD_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(POD_PATH)$(PATHSEP)pod.cpp

persist.obj:	$(PERSIST_PATH)$(PATHSEP)persist.cpp $(PERSIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(PERSIST_PATH)$(PATHSEP)persist.cpp

mtank.obj:	$(MTANK_PATH)$(PATHSEP)mtank.cpp $(MTANK_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(MTANK_PATH)$(PATHSEP)mtank.cpp

chslist.obj:	$(CHSLIST_PATH)$(PATHSEP)chslist.cpp $(CHSLIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CHSLIST_PATH)$(PATHSEP)chslist.cpp

config.obj:	$(CONFIG_PATH)$(PATHSEP)config.cpp $(CONFIG_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CONFIG_PATH)$(PATHSEP)config.cpp

strutil.obj:	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp $(STRUTIL_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp

asprint.obj:	$(ASPRINT_PATH)$(PATHSEP)asprint.cpp $(ASPRINT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(ASPRINT_PATH)$(PATHSEP)asprint.cpp

mtank_sh.obj:	$(MTANK_PATH)$(PATHSEP)mtank_sh.cpp $(MTANK_SH_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(MTANK_PATH)$(PATHSEP)mtank_sh.cpp

btwalk.obj:	$(BTREE_PATH)$(PATHSEP)btwalk.cpp $(BTWALK_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)btwalk.cpp

float64.obj:	$(DTYPES_PATH)$(PATHSEP)float64.cpp $(FLOAT64_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)float64.cpp

pscript.obj:	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp $(PSCRIPT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp

cdate.obj:	$(CDATE_PATH)$(PATHSEP)cdate.cpp $(CDATE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CDATE_PATH)$(PATHSEP)cdate.cpp

uint16.obj:	$(DTYPES_PATH)$(PATHSEP)uint16.cpp $(UINT16_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint16.cpp

terminal.obj:	$(TERMINAL_PATH)$(PATHSEP)terminal.cpp $(TERMINAL_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(TERMINAL_PATH)$(PATHSEP)terminal.cpp

# Make the executable
OBJECTS = ehandler.obj int32.obj vbdfile.obj asprint.obj persist.obj \
	ustring.obj pod.obj sllistb.obj chslist.obj config.obj vbdref.obj \
	cacheb.obj chptrb.obj btree.obj mnode.obj bucket.obj cache.obj \
	entrykey.obj dllistb.obj pscript.obj strutil.obj btwalk.obj \
	bnodeb.obj bstreeb.obj rbtreeb.obj twalk.obj float64.obj cdate.obj \
	uint16.obj mtank.obj mtank_sh.obj uint32.obj crc32.obj \
	terminal.obj main.obj vbdstats.obj

$(PROJECT).exe:	$(OBJECTS)
	$(LINKER) $(LINK_FLAGS) $(OBJECTS) /OUT:$@ 
# ===============================================================

# Install the binaries to the bin directory
# ===============================================================
install:
	@echo Installing $(PROJECT) binaries to the bin directory...
	@if exist $(PROJECT).exe copy $(PROJECT).exe $(INSTALL_DIR)
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .RES files from working directory...
	if exist *.res del *.res 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


