// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: groc_sh.h
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 12/16/1997 
// Date Last Modified: 03/18/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

General purpose search functions used with the grocery list
database.
*/
// ----------------------------------------------------------- //
#ifndef __GROC_SH_HPP__
#define __GROC_SH_HPP__

#include "grocery.h"
#include "dllist.h"
#include "btwalk.h"

enum GrocDBItem { // Database items used in global database searches
  NAME,
  BRAND,
  STORE
};

// Variable used to count the number of object found during a search
extern int ObjectsFound;

// Global data structures used to organize and store btree nodes
extern DLList<InMemCopy> GrocDB_SH_DLList; // Doubly Linked
extern DLList<InMemCopy> *dllist;         // Doubly Linked
extern DNode<InMemCopy> *dllistptr;       // DLList node pointer

void BtreeSearch(Btree *btx, int item, Grocery &grocery,
		 UString &str, int find_all = 0); 

void BtreeKeySearch(EntryKey &e, int item, Grocery &grocery, UString &str,
		    int find_all);

#endif  // __GROC_SH_HPP__ 
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

