// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: groc_sh.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 12/16/1997 
// Date Last Modified: 03/18/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

General purpose search functions used with the grocery list
database.
*/
// ----------------------------------------------------------- //
#include "groc_sh.h"
#include "btwalker.h"

// Global data structures used to organize and store btree nodes
DLList<InMemCopy> GrocDB_SH_DLList;            // Doubly Linked
DLList<InMemCopy> *dllist = &GrocDB_SH_DLList; // Doubly Linked
DNode<InMemCopy> *dllistptr = 0;               // DLList node pointer

// Variable used to count the number of object found during a search
int ObjectsFound = 0;

void BtreeSearch(Btree *btx, int item, Grocery &grocery,
		 UString &str, int find_all) 
{
  CachePointer nxt(*btx->GetCache());
  BtreeWalkerb tw(btx, btINORDER);
  int i, j;
  nxt = btx->GetRoot();
  DLList<EntryKey> list; // Short temporary list used to sort keys 
  DNode<EntryKey> *ptr;  
  
  while((__LWORD__)nxt != 0) {
    nxt = tw.Next();
    if((__LWORD__)nxt) {
      if(nxt->left != 0) {
	for(i = 0; i < nxt->cnt; i++) {
	  list.StoreNode(nxt->entry[i]);
	}
	continue; 
      }

      if(!list.IsEmpty()) {
	ptr = list.GetFront();
	for(i = 0, j = 0; i < nxt->cnt; i++) {
	  while(!list.IsHeader(ptr)) {
	    if(FullCompare(ptr->Data, nxt->entry[i].key) < 0) {
	      BtreeKeySearch(ptr->Data, item, grocery, str, find_all); 
	      list.Delete(ptr);
	    }
	    ptr = ptr->GetNext(); 
	  }
	}
	for(; j < nxt->cnt; j++) {
	  BtreeKeySearch(nxt->entry[j], item, grocery, str, find_all);
	}
      }
      else {
	for(i = 0; i < nxt->cnt; i++) {
	  BtreeKeySearch(nxt->entry[i], item, grocery, str, find_all); 
	}
      }
    }
  }
}

void BtreeKeySearch(EntryKey &e, int item, Grocery &grocery, UString &str,
		     int find_all)
{
  int offset;
  UString buf;
  
  if(item == NAME) {
    buf = e.key;
    if(find_all == 0) { // Search for single match
      int result = CaseICmp(buf, str);
      if(result == 0) { 
	InMemCopy inmemcopy(e.key, e.object_address, e.class_id);
	dllist->StoreNode(inmemcopy);
	ObjectsFound++;
      }
    }
    else { // Search for all matches
      offset = buf.Find(str.c_str(), 0);
      if(offset != UString::NoMatch) {
	InMemCopy inmemcopy(e.key, e.object_address, e.class_id);
	dllist->StoreNode(inmemcopy);
	ObjectsFound++;
      }
    }
  }
  else {
    grocery.ReadObject(e.object_address);
    switch(item) {
      case BRAND:
	buf = grocery.GetBrand();
	break;
      case STORE:
	buf = grocery.GetStore();
	break;
      default:
	return;
    }
    if(find_all == 0) { // Search for single match
      int result = CaseICmp(buf, str);
      if(result == 0) { 
	InMemCopy inmemcopy(e.key, e.object_address, e.class_id);
	dllist->StoreNode(inmemcopy);
	ObjectsFound++;
      }
    }
    else { // Search for all matches
      offset = buf.Find(str.c_str(), 0);
      if(offset != UString::NoMatch) {
	InMemCopy inmemcopy(e.key, e.object_address, e.class_id);
	dllist->StoreNode(inmemcopy);
	ObjectsFound++;
      }
    }
  }
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

