// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: grocery.h 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/17/1997  
// Date Last Modified: 03/18/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

This is a test program used to test the (P)ersistent base class
in a practical database application.
*/
// ----------------------------------------------------------- //   
#ifndef __GROCERY_HPP
#define __GROCERY_HPP

#include "persist.h"
#include "float64.h"

// Object type id
const INT32 GroceryID = 1001;

// Class version
const INT32 GroceryVersion = 1025;

typedef UString    ItemName;
typedef UString    BrandName;
typedef UString    Store;
typedef FLOAT64    Price;
typedef INT32      Quantity;
typedef __SBYTE__  Purchasing;
typedef FLOAT64    LineTotal;

class Grocery : public Persistent
{
public:
  Grocery(POD *pod);
  Grocery(const POD *pod);
  Grocery();
  Grocery(const Grocery &ob) { Copy(ob); }
  void operator=(const Grocery &ob) { Copy(ob); }
  ~Grocery() { }
  
public:
  void SaveChanges();
  void SetName(const char *s) { name = s; }
  void SetName(const UString &s) { name = s; }
  void SetBrand(const UString &s) { brand = s; }
  void SetBrand(const char *s) { brand = s; }
  void SetStore(const char *s) { store = s; }
  void SetStore(const UString &s) { store = s; }
  void SetPrice(Price p) { price = p; }
  void SetQuantity(Quantity q) { quantity = q; }
  void SetPurchasing(Purchasing p) { purchasing = p; }
  void SetLineTotal(LineTotal t) { line_total = t; }
  char *GetName() { return name.c_str(); }
  char *GetBrand() { return brand.c_str(); }
  char *GetStore() { return store.c_str(); }
  const char *GetName() const { return name.c_str(); }
  const char *GetBrand() const { return brand.c_str(); }
  const char *GetStore() const { return store.c_str(); }
  Price GetPrice() { return price; }
  Price GetPrice() const { return price; }
  Quantity GetQuantity() { return quantity; }
  Quantity GetQuantity() const { return quantity; }
  Purchasing GetPurchasing() { return purchasing; }
  Purchasing GetPurchasing() const { return purchasing; }
  LineTotal GetLineTotal() { return line_total; }
  LineTotal GetLineTotal() const { return line_total; }
  
public:
  void Copy(const Grocery &ob);
  int FullCompare(const Grocery &ob);
  
private: // Base class interface
  virtual FAU Write();
  virtual void Read(FAU Address);
  virtual FAU Find();
  virtual FAU Delete();
  virtual FAU Remove();
  
public: // Base class interface
  virtual INT32 GetClassID() const { return GroceryID; }
  virtual const char *GetClassName() { return "Class Grocery"; }
  virtual unsigned ObjectLength();
  virtual void SetObjectAddress(FAU addr) { objectaddress = addr; }
  virtual FAU GetObjectAddress() { return objectaddress; }
  virtual int CompareIndex();
  virtual int RebuildIndexFile(const char *fname);
  
public: // Overloaded operators
  friend int operator==(const Grocery &a, const Grocery &b);
  friend int operator!=(const Grocery &a, const Grocery &b);
  friend int operator>(const Grocery &a, const Grocery &b);
  friend int operator>=(const Grocery &a, const Grocery &b);
  friend int operator<(const Grocery &a, const Grocery &b);
  friend int operator<=(const Grocery &a, const Grocery &b);

private:
  ItemName   name;
  BrandName  brand;
  Store      store;
  Price      price;
  Quantity   quantity;
  Purchasing purchasing;
  LineTotal  line_total;
};

#endif  // __GROCERY_HPP //
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
