#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the WX windows program
# C/C++ Compiler Used: HP C++ A.10.24  compiled for HP-UX 10.20 
# Produced By: Doug Gaer      ^^^^^^^
# File Creation Date: 12/16/1997 
# Date Last Modified: 03/30/1998
#
# NOTE: If using the template classes this program will not 
# compile under HP C++ A.10.09. The template version of the 
# Bucket class uses a template parameter as base class, which 
# was not allowed in this version of HP C++. To get the current 
# version number enter the following command:
# 
# % what /opt/CC/bin/CC
# ***************************************************************
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v    -- Echo compilation
#       g    -- Enable debugging
#	+w   -- Turn on all warnings
#       +eh  -- Enable C++ exception handling
#	+a1  -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
#
#	+DAportable -- Generate code compatible across PA-RISC 1.1 
#	and 2.0 HP workstations and servers, use the option.  
#
#	+DSmodel --  Use the instruction scheduler tuned to the model
#	specified. model can be a model number, PA-RISC architecture 
#	designation or PA-RISC processor name. See the file:
#	/opt/langtools/lib/sched.models for a list of model numbers and 
#	processor names.  
#
#	+Oopt --  Invoke optimizations selected by opt. Defined values 
#	for opt are:
#
#	0    Perform minimal optimizations.  
#	1    Perform optimizations within basic blocks only.
#	2    Perform level 1 and global optimizations. Same as -O.
#	3    Perform level 2 as well as interprocedural global opts.
#	4    Perform level 3 as well as doing link time optimizations.
#	Also sends +Oprocelim and +Ofastaccess to the linker.
#
# Linker flags 
#	-lm       -- Needed for math library
# ---------------------------------------------------------------
SHELL = /bin/sh

# Define this macro in the main makefile for this application
# Name for the executable
PROJECT = ccindexw

# Define this macro in the main makefile for this application
# Installation directory for the application and config files
INSTALL_DIR = ../bin

# Define the $(WXDIR) macro in the main makefile for this application
# My directory path for the wxWindows GUI library version 1.68B
WXDIR = $(WXWIN)

# All common wxWindows UNIX compiler flags and options are now in
# this central makefile.
include $(WXDIR)/src/make.env

# Define the $(VBDDIR) macro in the main makefile for this application
# Setup path for VBD Base installation directory
# My directory path for the VBD class library.
VBDDIR = $(VBDPATH)

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
APP_PATH = .
CCINDEX_PATH = ..$(PATHSEP)src
QUEUE_PATH = $(VBDDIR)$(PATHSEP)src
STACK_PATH = $(VBDDIR)$(PATHSEP)src
BTREE_PATH = $(VBDDIR)$(PATHSEP)src
CACHE_PATH = $(VBDDIR)$(PATHSEP)src
EHANDLER_PATH = $(VBDDIR)$(PATHSEP)src
DTYPES_PATH = $(VBDDIR)$(PATHSEP)src
REFCOUNT_PATH = $(VBDDIR)$(PATHSEP)src
USTRING_PATH = $(VBDDIR)$(PATHSEP)src
VBDFILE_PATH = $(VBDDIR)$(PATHSEP)src
SLLISTB_PATH = $(VBDDIR)$(PATHSEP)src
STRUTIL_PATH = $(VBDDIR)$(PATHSEP)src
CONFIG_PATH = $(VBDDIR)$(PATHSEP)src
CHSLIST_PATH = $(VBDDIR)$(PATHSEP)src
POD_PATH = $(VBDDIR)$(PATHSEP)src
PERSIST_PATH = $(VBDDIR)$(PATHSEP)src
PLACENEW_PATH = $(VBDDIR)$(PATHSEP)src
DLLISTB_PATH = $(VBDDIR)$(PATHSEP)src
PSCRIPT_PATH = $(VBDDIR)$(PATHSEP)src
CRC32_PATH = $(VBDDIR)$(PATHSEP)src
ASPRINT_PATH = $(VBDDIR)$(PATHSEP)src

ADD_INC_PATHS = -I$(VBDDIR)$(PATHSEP)include -I..$(PATHSEP)src

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = -D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = -D__RECLAIM_FIRST_FIT__ 

# Use this DEFMACS macro to compile without using template classes
DEFMACS = -D__NOT_USING_TEMPLATE_CLASS__ -D__BTREE_MNODE__ \
-D__wxWIN168B__ -D__USE_VBDREFCOUNT__ -D__UNIX__ \
$(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS # -D__USE_MSW_PRINTING__ 

# Define macros for compiler and linker
AC     = cc   # ANSI c compiler
CPP    = CC   # C++ compiler
LINKER = ld   # Linker

# Define compiler and linker flags macros
COMPILE_ONLY = -c
OUTPUT = -o
COMPILE_FLAGS= $(CPPFLAGS) $(ADD_INC_PATHS) $(DEFMACS) +DAportable
LINK_FLAGS = $(LDFLAGS) 
LINK_LIBS = $(MOTIFLDLIBS)

VBDSTATS_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

CRC32_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)crc32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)crc32tab.h 

UINT32_DEP =  $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h

BUCKET_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

CACHE_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

CACHEB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

CHPTRB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

MNODE_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h

ENTRYKEY_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)strutil.h
 
BTREE_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

POD_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)pod.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

PERSIST_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)pod.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)persist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h 

EHANDLER_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h 

VBDFILE_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)crc32.h 

INT32_DEP =  $(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h

VBDREF_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdref.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h

USTRING_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)ustring.h


SLLISTB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h

CCINDEX_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(CCINDEX_PATH)$(PATHSEP)ccindex.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)persist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)pod.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdref.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ustring.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)strutil.h 

ASPRINT_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)asprint.h

WINMAIN_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(CCINDEX_PATH)$(PATHSEP)ccindex.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)persist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)pod.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdref.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ustring.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chslist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)config.h \
	$(CCINDEX_PATH)$(PATHSEP)version.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)asprint.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btwalk.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)queue.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)stack.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)strutil.h \
	$(CCINDEX_PATH)$(PATHSEP)dbconfig.h \
	$(CCINDEX_PATH)$(PATHSEP)ccidx_sh.h  \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdstats.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btwalker.h  \
	$(APP_PATH)$(PATHSEP)winmain.h

CCIDX_SH_DEP = $(CCINDEX_PATH)$(PATHSEP)ccindex.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)persist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)pod.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdref.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btwalk.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)queue.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)stack.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ustring.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btwalker.h 

CONFIG_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)chslist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)config.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h

STRUTIL_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)strutil.h 

DLLISTB_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)dllistb.h

CHSLIST_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)chslist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h

BTWALK_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btwalk.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ustring.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)uint32.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)strutil.h	

BTWALKER_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)bucket.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)bucketb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cache.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)chptrb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cactype.h\
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)cacheptr.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btree.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)ehandler.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)vbdfile.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)refcount.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)placenew.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)int32.h  \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dtypes.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)mnode.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)btreeprt.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)entrykey.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)sllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllistb.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)dllist.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)stack.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)queue.h \
	$(VBDDIR)$(PATHSEP)include$(PATHSEP)strutil.h 

PSCRIPT_DEP = $(VBDDIR)$(PATHSEP)include$(PATHSEP)pscript.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

btwalker.o:	$(BTREE_PATH)$(PATHSEP)btwalker.cpp $(BTWALKER_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)btwalker.cpp

vbdstats.o:	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp $(VBDSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp

uint32.o:	$(DTYPES_PATH)$(PATHSEP)uint32.cpp $(UINT31_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint32.cpp

crc32.o:	$(CRC32_PATH)$(PATHSEP)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CRC32_PATH)$(PATHSEP)crc32.cpp

bucket.o:	$(CACHE_PATH)$(PATHSEP)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)bucket.cpp

cache.o:	$(CACHE_PATH)$(PATHSEP)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)cache.cpp

cacheb.o:	$(CACHE_PATH)$(PATHSEP)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)cacheb.cpp

chptrb.o:	$(CACHE_PATH)$(PATHSEP)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)chptrb.cpp

mnode.o:	$(BTREE_PATH)$(PATHSEP)mnode.cpp $(MNODE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)mnode.cpp

entrykey.o:	$(BTREE_PATH)$(PATHSEP)entrykey.cpp $(ENTRYKEY_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)entrykey.cpp

btree.o:	$(BTREE_PATH)$(PATHSEP)btree.cpp $(BTREE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)btree.cpp

ehandler.o:	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp

vbdfile.o:	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp

winmain.o:	$(APP_PATH)$(PATHSEP)winmain.cpp $(WINMAIN_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(APP_PATH)$(PATHSEP)winmain.cpp

ustring.o:	$(USTRING_PATH)$(PATHSEP)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(USTRING_PATH)$(PATHSEP)ustring.cpp

int32.o:	$(DTYPES_PATH)$(PATHSEP)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)int32.cpp

sllistb.o:	$(SLLISTB_PATH)$(PATHSEP)sllistb.cpp $(SLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.cpp

dllistb.o:	$(DLLISTB_PATH)$(PATHSEP)dllistb.cpp $(DLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DLLISTB_PATH)$(PATHSEP)dllistb.cpp

vbdref.o:	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp

pod.o:	$(POD_PATH)$(PATHSEP)pod.cpp $(POD_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(POD_PATH)$(PATHSEP)pod.cpp

persist.o:	$(PERSIST_PATH)$(PATHSEP)persist.cpp $(PERSIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(PERSIST_PATH)$(PATHSEP)persist.cpp

ccindex.o:	$(CCINDEX_PATH)$(PATHSEP)ccindex.cpp $(CCINDEX_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CCINDEX_PATH)$(PATHSEP)ccindex.cpp

chslist.o:	$(CHSLIST_PATH)$(PATHSEP)chslist.cpp $(CHSLIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CHSLIST_PATH)$(PATHSEP)chslist.cpp

config.o:	$(CONFIG_PATH)$(PATHSEP)config.cpp $(CONFIG_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CONFIG_PATH)$(PATHSEP)config.cpp

strutil.o:	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp $(STRUTIL_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp

asprint.o:	$(ASPRINT_PATH)$(PATHSEP)asprint.cpp $(ASPRINT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(ASPRINT_PATH)$(PATHSEP)asprint.cpp

ccidx_sh.o:	$(CCINDEX_PATH)$(PATHSEP)ccidx_sh.cpp $(CCIDX_SH_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CCINDEX_PATH)$(PATHSEP)ccidx_sh.cpp

btwalk.o:	$(BTREE_PATH)$(PATHSEP)btwalk.cpp $(BTWALK_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)btwalk.cpp

pscript.o:	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp $(PSCRIPT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp

# Make the executable
OBJECTS = ehandler.o int32.o vbdfile.o asprint.o persist.o \
	ustring.o pod.o ccindex.o sllistb.o chslist.o \
	config.o vbdref.o cacheb.o chptrb.o btree.o \
	mnode.o bucket.o cache.o entrykey.o dllistb.o \
	pscript.o strutil.o btwalk.o ccidx_sh.o winmain.o \
	uint32.o crc32.o vbdstats.o btwalker.o

$(PROJECT):	$(OBJECTS) $(WXLIB)
	$(CPP) $(COMPILE_FLAGS) $(OBJECTS) $(OUTPUT) $(PROJECT) \
	$(LINK_FLAGS) $(LINK_LIBS) 

# ===============================================================

# Install the binaries and config files to the bin directory
# ===============================================================
install:
	echo Installing $(PROJECT) binaries to the bin directory
	cp $(PROJECT) $(INSTALL_DIR)/. 
# ===============================================================

# ===============================================================
# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing template repository from working directory...
	rm -r -f ptrepository

	echo Removing the EXECUTABLE file from working directory
	rm -f $(PROJECT)
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
