// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: ccindex.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/17/1997  
// Date Last Modified: 03/17/1999
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The CCIndex class is a persistent string VBD database used
to store various name and address information in a 3" X 5"
index card file format. All the string members can grow and
shrink as needed.
*/
// ----------------------------------------------------------- //   
#include "ccindex.h"
#include "strutil.h"

unsigned CCIndex::ObjectLength()
{
  unsigned len = StringFileLength(card_name) + \
    StringFileLength(company_name) + \
    StringFileLength(department_name) + \
    StringFileLength(phone_number) + \
    StringFileLength(fax_number)  + \
    StringFileLength(cell_number)  + \
    StringFileLength(beeper_number)  + \
    StringFileLength(email_address)  + \
    StringFileLength(street_address)  + \
    StringFileLength(internet_urls)  + \
    StringFileLength(comments_block);

  return len;
}

FAU CCIndex::Write()
{
  ObjectHeader oh;

  FAU addr = pod->OpenDatabase()->Alloc(ObjectLength() + sizeof(ObjectHeader));

  if(!addr) return 0;
  oh.ClassID = GetClassID();
  oh.ObjectID = addr;

  WriteObjHeader(oh);
  WriteString(card_name);
  WriteString(company_name);
  WriteString(department_name);
  WriteString(phone_number);
  WriteString(fax_number);
  WriteString(cell_number);
  WriteString(beeper_number);
  WriteString(email_address);
  WriteString(street_address);
  WriteString(internet_urls);
  WriteString(comments_block);
  objectaddress = addr;  

  // Add the entry to the Index file
  if (UsingIndex()) {
    EntryKey key(card_name.c_str(), oh.ObjectID, oh.ClassID);
    AddKey(key);
  }
  return addr;
}

void CCIndex::Read(FAU Address)
{
  ObjectHeader oh;

  ReadObjHeader(oh, Address);
  if(oh.ClassID != GetClassID()) return; // Incorrect object type

  ReadString(card_name);
  ReadString(company_name);
  ReadString(department_name);
  ReadString(phone_number);
  ReadString(fax_number);
  ReadString(cell_number);
  ReadString(beeper_number);
  ReadString(email_address);
  ReadString(street_address);
  ReadString(internet_urls);
  ReadString(comments_block);
  objectaddress = oh.ObjectID;
}

FAU CCIndex::Find()
// Find object by seaching the database for its primary data members
{
  CCIndex ccindex;

  ccindex.card_name = this->card_name; 
  ccindex.company_name = this->company_name; 
  ccindex.department_name = this->department_name; 
  ccindex.phone_number = this->phone_number;
  ccindex.fax_number = this->fax_number;
  ccindex.cell_number = this->cell_number;
  ccindex.beeper_number = this->beeper_number;
  ccindex.email_address = this->email_address;
  ccindex.street_address = this->street_address;
  ccindex.internet_urls = this->internet_urls;
  ccindex.comments_block = this->comments_block;

  int rv; // Return value
 
  // Search the index file for this entry
  if(UsingIndex()) {
    EntryKey e(this->card_name.c_str());
    rv = FindKey(e);
    if(rv) { // Found the object in the index file
      Read(e.object_address);
      objectaddress = e.object_address;
      return e.object_address;
    }
    else
      return 0;
  }

  FAU oa;          // Object Address
  VBHeader vb;     // Variable Block Header
  ObjectHeader oh; // Object Header
  
  FAU vbdfileEOF = pod->OpenDatabase()->GetEOF();
  FAU addr = 0;
  addr = pod->OpenDatabase()->FindFirstVB(addr); // Search the entire file

  if(addr == 0) return 0; // No variable blocks found in file
  
  while(1) { 
    if(addr >= vbdfileEOF) break;
    pod->OpenDatabase()->Read(&vb, sizeof(VBHeader), addr);
    if(vb.CkWord == CheckWord) {
      if((__SBYTE__)vb.Status == NormalVB) {
	oa = addr + sizeof(VBHeader);
	ReadObjHeader(oh, oa);
	if(oh.ClassID == GetClassID()) { 
	  Read(oa);
	  if(card_name == ccindex.card_name) {
	    objectaddress = oa;
	    return oa; // Found unique data member
	  }
	}
      }
      addr = addr + vb.Length; // Goto the next variable block
    }
    else {
      addr = pod->OpenDatabase()->VBSearch(addr); 
      if(!addr) break;
    }
  }

  // Reset the objects data
  this->card_name = ccindex.card_name;
  this->company_name = ccindex.company_name;
  this->department_name = ccindex.department_name;
  this->phone_number = ccindex.phone_number;
  this->fax_number = ccindex.fax_number;
  this->cell_number = ccindex.cell_number;
  this->beeper_number = ccindex.beeper_number;
  this->email_address = ccindex.email_address;
  this->street_address = ccindex.street_address;
  this->internet_urls = ccindex.internet_urls;
  this->comments_block = ccindex.comments_block;
  
  return 0; // Could not find 
}

void CCIndex::Copy(const CCIndex &ob)
{
  card_name = ob.card_name;
  company_name = ob.company_name;
  department_name = ob.department_name;
  phone_number = ob.phone_number;
  fax_number = ob.fax_number;
  cell_number = ob.cell_number;
  beeper_number = ob.beeper_number;
  email_address = ob.email_address;
  street_address = ob.street_address;
  internet_urls = ob.internet_urls;
  comments_block = ob.comments_block;
  objectaddress = ob.objectaddress;
}

int CCIndex::FullCompare(const CCIndex &ob)
{
  if(card_name != ob.card_name) return 0;
  if(company_name != ob.company_name) return 0;
  if(department_name != ob.department_name) return 0;
  if(phone_number != ob.phone_number) return 0;
  if(fax_number != ob.fax_number) return 0;
  if(cell_number != ob.cell_number) return 0;
  if(beeper_number != ob.beeper_number) return 0;
  if(email_address != ob.email_address) return 0;
  if(street_address != ob.street_address) return 0;
  if(internet_urls != ob.internet_urls) return 0;
  if(comments_block != ob.comments_block) return 0;
  return 1;
}

int operator==(const CCIndex &a, const CCIndex &b)
{
  return CaseICmp(a.GetCardName(), b.GetCardName()) == 0;
}

int operator!=(const CCIndex &a, const CCIndex &b)
{
  return CaseICmp(a.GetCardName(), b.GetCardName()) != 0;
}

int operator>(const CCIndex &a, const CCIndex &b)
{
  return CaseICmp(a.GetCardName(), b.GetCardName()) > 0;
}

int operator>=(const CCIndex &a, const CCIndex &b)
{
  return CaseICmp(a.GetCardName(), b.GetCardName()) >= 0;
}
  
int operator<(const CCIndex &a, const CCIndex &b)
{
  return CaseICmp(a.GetCardName(), b.GetCardName()) < 0;
}
  
int operator<=(const CCIndex &a, const CCIndex &b)
{
  return CaseICmp(a.GetCardName(), b.GetCardName()) <= 0;
}

FAU CCIndex::Delete()
{
  if(UsingIndex()) {
    EntryKey e(this->card_name.c_str());
    int rv = FindKey(e);
    if(rv) {  // Found the object in the index file
      FAU addr = e.object_address;
      DeleteObject(e.object_address); // Delete from the data file
      RemoveKey(e);                   // Remove from the index file
      return addr;
    }
    else
      return 0; // Could not delete
  }

  FAU addr = Find();
  if(!addr) return 0; // Object does not exist
  DeleteObject(addr);
  return addr;
}

FAU CCIndex::Remove()
{
  if(UsingIndex()) {
    EntryKey e(this->card_name.c_str());
    int rv = FindKey(e);
    if(rv) {  // Found the object in the index file
      FAU addr = e.object_address;
      RemoveObject(e.object_address); // Remove from the data file
      RemoveKey(e);                   // Remove from the index file
      return addr;
    }
    else
      return 0; // Could not remove
  }

  FAU addr = Find();
  if(!addr) return 0; // Object does not exist
  RemoveObject(addr);
  return addr;
}

int CCIndex::CompareIndex()
// Compares the data file to the index file.
// Returns true if data and index file match.
{
  if(!UsingIndex()) return 0;

  CCIndex ccindex(pod);
  EntryKey key;
  
  FAU oa;          // Object Address
  VBHeader vb;     // Variable Block Header
  ObjectHeader oh; // Object Header
  
  int objects = 0; // Keeps track of good variable blocks
  int matches = 0; // Keep track of matches
  
  FAU vbdfileEOF = pod->OpenDatabase()->GetEOF();
  FAU addr = 0;
  addr = pod->OpenDatabase()->FindFirstVB(addr); // Search the entire file

  if(addr == 0) { // No variable blocks found in file
#ifdef CPP_EXCEPTIONS
    throw CNoObjectsExist();
#else
    Error->SignalException(EHandler::NoObjectsExist, EHandler::DISPLAY);
    return 0;
#endif
  }
  
  while(1) { 
    if(addr >= vbdfileEOF) break;
    pod->OpenDatabase()->Read(&vb, sizeof(VBHeader), addr);
    if(vb.CkWord == CheckWord) {
      if((__SBYTE__)vb.Status == NormalVB) {
	oa = addr + sizeof(VBHeader);
	ReadObjHeader(oh, oa);
	if(oh.ClassID == GetClassID()) { 
	  objects++; // Increment the object count
	  ccindex.Read(oa);
	  key.SetStrKey(ccindex.GetCardName());
	  key.SetOA(oa);
	  key.SetCID(oh.ClassID);
	  int rv = FindKey(key, 1);
	  if(rv) matches++; // Index and data file match
	}
      }
      addr = addr + vb.Length; // Goto the next variable block
    }
    else {
      addr = pod->OpenDatabase()->VBSearch(addr); 
      if(!addr) break;
    }
  }

  return objects == matches;
}

int CCIndex::RebuildIndexFile(const char *fname)
{
  if(!UsingIndex()) return 0;

  int rv; // (R)eturn (V)alue
  int CacheSize = 15;

  VBDFilePtr f(new VBDFile);
  Btree btx(CacheSize);
  f->Create(fname, sizeof(BtreeHeader));
  btx.Connect(f, 1);
  
  CCIndex ccindex(pod);
  EntryKey key;
  
  FAU oa;          // Object Address
  VBHeader vb;     // Variable Block Header
  ObjectHeader oh; // Object Header
  
  int objects = 0; // Keeps track of good variable blocks
  int inserts = 0; // Keep track of inserts
  
  FAU vbdfileEOF = pod->OpenDatabase()->GetEOF();
  FAU addr = 0;
  addr = pod->OpenDatabase()->FindFirstVB(addr); // Search the entire file

  if(addr == 0) { // No variable blocks found in file
#ifdef CPP_EXCEPTIONS
    throw CNoObjectsExist();
#else
    Error->SignalException(EHandler::NoObjectsExist, EHandler::DISPLAY);
    return 0;
#endif
  }
  
  while(1) { 
    if(addr >= vbdfileEOF) break;
    pod->OpenDatabase()->Read(&vb, sizeof(VBHeader), addr);
    if(vb.CkWord == CheckWord) {
      if((__SBYTE__)vb.Status == NormalVB) {
	oa = addr + sizeof(VBHeader);
	ReadObjHeader(oh, oa);
	if(oh.ClassID == GetClassID()) { 
	  objects++; // Increment the object count
	  ccindex.Read(oa);
	  key.SetStrKey(ccindex.GetCardName());
	  key.SetOA(oa);
	  key.SetCID(oh.ClassID);
	  rv = btx.Add(key);
	  if(!rv) { 
#ifdef CPP_EXCEPTIONS
	    throw CAssertError();
#else
	  Error->SignalException(EHandler::AssertError);
#endif
	  }
	  else
	    inserts++; // Index and data file match
	}
      }
      addr = addr + vb.Length; // Goto the next variable block
    }
    else {
      addr = pod->OpenDatabase()->VBSearch(addr); 
      if(!addr) break;
    }
  }

  return objects == inserts;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

