/* Power Render Rendering Interface */

#ifndef _PRRENDER_
#define _PRRENDER_

#ifdef __cplusplus
  extern "C" {
#endif


/* Texture division values for perspective texture mapping */
#define TEXTURE_DIVISION_1   0
#define TEXTURE_DIVISION_2   1
#define TEXTURE_DIVISION_4   2
#define TEXTURE_DIVISION_8   3
#define TEXTURE_DIVISION_16  4
#define TEXTURE_DIVISION_32  5
#define TEXTURE_DIVISION_64  6
#define TEXTURE_DIVISION_128 7
#define TEXTURE_DIVISION_256 8


/* Types of Elements available: */
/* The first letter indicates the primitive:
   T - Triangle
   S - Sprite
*/
extern PR_DWORD PR_FogShadeTable;
extern PR_DWORD PR_FogMaxShade;

#define NULL_TYPE                 0  /* Rejected immediately */

#define T_WIREFRAME               1  /* Wireframe (constant color) */

#define T_CFLAT                   2  /* Flat shaded (constant color) */
#define T_FLAT                    3  /* Flat shaded (light sourced) */

#define T_CGOURAUD                4  /* Gouraud shaded (constant color) */
#define T_GOURAUD                 5  /* Gouraud shaded (light sourced) */

#define T_LTEXTURED               6  /* Low Res Texture Mapped (non wrapping) */
#define T_LXTEXTURED              7  /* Low Res Xray Texture Mapped (non wrapping) */
#define T_TEXTURED                8  /* Texture Mapped (Non Wrapping) */
#define T_WTEXTURED               9  /* Texture Mapped (Wrapping) */
#define T_XTEXTURED              10  /* Xray Texture Mapped (Non Wrapping) */
#define T_XWTEXTURED             11  /* Xray Texture Mapped (Wrapping) */

#define T_LCFLAT_TEXTURED        12  /* Low Res Flat shaded Texture Mapped (non wrapping) */
#define T_LXCFLAT_TEXTURED       13  /* Low Res Xray Flat shaded Texture Mapped (non wrapping) */
#define T_CFLAT_TEXTURED         14  /* Flat shaded Texture Mapped (contant, non wrapping) */
#define T_WCFLAT_TEXTURED        15  /* Flat shaded Texture Mapped (contant, wrapping) */
#define T_XCFLAT_TEXTURED        16  /* Xray Flat shaded Texture Mapped (contant, non wrapping) */
#define T_XWCFLAT_TEXTURED       17  /* Xray Flat shaded Texture Mapped (contant, wrapping) */

#define T_FLAT_TEXTURED          18  /* Flat shaded Texture Mapped (light sourced, non wrapping) */
#define T_WFLAT_TEXTURED         19  /* Flat shaded Texture Mapped (light sourced, wrapping) */
#define T_XFLAT_TEXTURED         20  /* Xray Flat shaded Texture Mapped (light sourced, non wrapping) */
#define T_XWFLAT_TEXTURED        21  /* Xray Flat shaded Texture Mapped (light sourced, wrapping) */
#define T_LFLAT_TEXTURED         22  /* Low Res Flat shaded Texture Mapped (light sourced, non wrapping) */
#define T_LXFLAT_TEXTURED        23  /* Low Res Xray Flat shaded Texture Mapped (light sourced, non wrapping) */

#define T_LCGOURAUD_TEXTURED     24  /* Low Res Gouraud shaded Texture Mapped (constant, non wrapping) */
#define T_LXCGOURAUD_TEXTURED    25  /* Low Res Xray Gouraud shaded Texture Mapped (constant, non wrapping) */
#define T_CGOURAUD_TEXTURED8     26  /* Gouraud shaded Texture Mapped (constant, non wrapping) */
#define T_WCGOURAUD_TEXTURED8    27  /* Gouraud shaded Texture Mapped (constant, wrapping) */
#define T_XCGOURAUD_TEXTURED8    28  /* Xray Gouraud shaded Texture Mapped (constant, non wrapping) */
#define T_XWCGOURAUD_TEXTURED8   29  /* Xray Gouraud shaded Texture Mapped (constant, wrapping) */

#define T_LGOURAUD_TEXTURED      30  /* Low Res Gouraud shaded Texture Mapped (light sourced, non wrapping) */
#define T_LXGOURAUD_TEXTURED     31  /* Low Res Xray Gouraud shaded Texture Mapped (light sourced, non wrapping) */
#define T_GOURAUD_TEXTURED8      32  /* Gouraud shaded Texture Mapped (light sourced, non wrapping) */
#define T_WGOURAUD_TEXTURED8     33  /* Gouraud shaded Texture Mapped (light sourced, wrapping) */
#define T_XGOURAUD_TEXTURED8     34  /* Xray Gouraud shaded Texture Mapped (light sourced, non wrapping) */
#define T_XWGOURAUD_TEXTURED8    35  /* Xray Gouraud shaded Texture Mapped (light sourced, wrapping) */



#define T_LTRANSLUCENT_TEXTURED  36  /* Low Res Translucent Texture Mapped (non wrapping) */
#define T_LXTRANSLUCENT_TEXTURED 37  /* Low Res Xray Translucent Texture Mapped (non wrapping) */
#define T_TRANSLUCENT_TEXTURED   38  /* Translucent Texture Mapped (non wrapping) */
#define T_WTRANSLUCENT_TEXTURED  39  /* Translucent Texture Mapped (wrapping) */
#define T_XTRANSLUCENT_TEXTURED  40  /* Xray Translucent Texture Mapped (non wrapping) */
#define T_XWTRANSLUCENT_TEXTURED 41  /* Xray Translucent Texture Mapped (wrapping) */


/* Perspective correct */
#define T_PCGOURAUD              42   /* Gouraud shaded (constant color) */
#define T_PGOURAUD               43   /* Gouraud shaded (light sourced) */

#define T_PTEXTURED              44   /* Texture Mapped (Non Wrapping) */
#define T_PWTEXTURED             45   /* Texture Mapped (Wrapping) */
#define T_PXTEXTURED             46   /* Xray Texture Mapped (Non Wrapping) */
#define T_PXWTEXTURED            47   /* Xray Texture Mapped (Wrapping) */

#define T_PCFLAT_TEXTURED        48   /* Flat shaded Texture Mapped (contant, non wrapping) */
#define T_PWCFLAT_TEXTURED       49   /* Flat shaded Texture Mapped (contant, wrapping) */
#define T_PXCFLAT_TEXTURED       50   /* Xray Flat shaded Texture Mapped (contant, non wrapping) */
#define T_PXWCFLAT_TEXTURED      51   /* Xray Flat shaded Texture Mapped (contant, wrapping) */

#define T_PFLAT_TEXTURED         52   /* Flat shaded Texture Mapped (light sourced, non wrapping) */
#define T_PWFLAT_TEXTURED        53   /* Flat shaded Texture Mapped (light sourced, wrapping) */
#define T_PXFLAT_TEXTURED        54   /* Xray Flat shaded Texture Mapped (light sourced, non wrapping) */
#define T_PXWFLAT_TEXTURED       55   /* Xray Flat shaded Texture Mapped (light sourced, wrapping) */

#define T_PCGOURAUD_TEXTURED8    56   /* Gouraud shaded Texture Mapped (constant, non wrapping) */
#define T_PWCGOURAUD_TEXTURED8   57   /* Gouraud shaded Texture Mapped (constant, wrapping) */
#define T_PXCGOURAUD_TEXTURED8   58   /* Xray Gouraud shaded Texture Mapped (constant, non wrapping) */
#define T_PXWCGOURAUD_TEXTURED8  59   /* Xray Gouraud shaded Texture Mapped (constant, wrapping) */

#define T_PGOURAUD_TEXTURED8     60   /* Gouraud shaded Texture Mapped (light sourced, non wrapping) */
#define T_PWGOURAUD_TEXTURED8    61   /* Gouraud shaded Texture Mapped (light sourced, wrapping) */
#define T_PXGOURAUD_TEXTURED8    62   /* Xray Gouraud shaded Texture Mapped (light sourced, non wrapping) */
#define T_PXWGOURAUD_TEXTURED8   63   /* Xray Gouraud shaded Texture Mapped (light sourced, wrapping) */

#define T_PTRANSLUCENT_TEXTURED   64  /* Translucent Texture Mapped (non wrapping) */
#define T_PWTRANSLUCENT_TEXTURED  65  /* Translucent Texture Mapped (wrapping) */
#define T_PXTRANSLUCENT_TEXTURED  66  /* Xray Translucent Texture Mapped (non wrapping) */
#define T_PXWTRANSLUCENT_TEXTURED 67  /* Xray Translucent Texture Mapped (wrapping) */

#define T_SOURCETRANSFORM         68  /* Source Transformed */
#define T_LIGHTMAP_ADD            69  /* Additive Lightmap */
#define T_LIGHTMAP_TIMES          70  /* Multiplicative Lightmap */

#define MAXMETHOD 70



void PR_AddElementVGA (PR_FACE *elemptr, PR_VERTEX *pointlist,
                    PR_VERTEX_DATA *pointdata, PR_DWORD count);
/* Adds a face to the rendering list if it is visible */


void PR_AddTriangle (PR_RPOINT *v1, PR_RPOINT *v2, PR_RPOINT *v3);


void PR_RenderEntity (PR_ENTITY *entity);
/* Adds visible faces from the entity to the rendering list */


void PR_RenderFrameVGA (void);
/* Renders all faces in the rendering list to the viewport */


void PR_RenderSegment (PR_ENTITY *entity, PR_SEGMENT *seg);
/* Adds visible faces from the segment to the rendering list */


void PR_SetFogColorVGA (PR_DWORD col);

void PR_SetFogStateVGA (PR_DWORD state);
/* Sets the global fog rendering state (0 or 1) */

void PR_SetFogRangeVGA (PR_REAL near_dist, PR_REAL far_dist);
/* Sets the range of fog */


void PR_ComputeVertexLighting8bit (PR_VERTEX *vptr1, 
                               PR_VERTEX *vptr2, 
                               PR_VERTEX *vptr3,
                               PR_VERTEX_DATA *vptr1data,
                               PR_VERTEX_DATA *vptr2data,
                               PR_VERTEX_DATA *vptr3data,
                               PR_RPOINT *renderpoly1,
                               PR_RPOINT *renderpoly2,
                               PR_RPOINT *renderpoly3,
                               PR_FACE *elemptr,
                               PR_MATERIAL *mat,
                               PR_UCHAR MipShift);

extern PR_DWORD ADDPRIV_setup_state;
extern PR_DWORD ADDPRIV_setup_data;


void PR_ClipAndRenderTri (PR_RPOINT *a,
                          PR_RPOINT *b,
                          PR_RPOINT *c,
                          PR_DWORD clipcode);
/* -----------------------------------------------------------------------
   Function:   PR_ClipAndRenderTri
   Purpose:    Clips a triangle and adds it to the rendering list
   Parameters: a - first vertex
               b - second vertex
               c - third vertex
               clipcode - Tells which planes need to be clipped against
   Return:
   ----------------------------------------------------------------------- */


void PR_AddTriangle (PR_RPOINT *v1, PR_RPOINT *v2, PR_RPOINT *v3);

#ifdef __cplusplus
}
#endif

#endif

