/* Power Render Math Interface */

#ifndef _PRMATH_
#define _PRMATH_

#ifdef __cplusplus
  extern "C" {
#endif


PR_REAL PR_Distance2D (PR_REAL x1, PR_REAL y1, PR_REAL x2, PR_REAL y2);
/* -----------------------------------------------------------------------
   Function:   PR_Distance2D
   Purpose:    Returns the distance between two 2D coordinates 
   Parameters: x1,y1 - Location of first coordinate
               x2,y2 - Location of second coordiante
   Return:     2D distance between points
   ----------------------------------------------------------------------- */


PR_REAL PR_Distance3D (PR_REAL x1, PR_REAL y1, PR_REAL z1,
                       PR_REAL x2, PR_REAL y2, PR_REAL z2);
/* -----------------------------------------------------------------------
   Function:   PR_Distance3D
   Purpose:    Returns the distance between two 3D coordinates 
   Parameters: x1,y1,z1 - Location of first point
               x2,y2,z1 - Location of second point
   Return:     3D Distance between points
   ----------------------------------------------------------------------- */


void PR_Normalize (PR_POINT *vector);
/* -----------------------------------------------------------------------
   Function:   PR_Normalize
   Purpose:    Normalizes a vector 
   Parameters: vector - Pointer to the vector
   Return:     None
   ----------------------------------------------------------------------- */


#define PR_PI 3.14159265358979323846

#define RADIANS(val) val*PR_PI/180.0

#define PR_VecDotProduct(A, B)  ((A).x*(B).x+(A).y*(B).y+(A).z*(B).z)

#define PR_VecLength(A) (sqrt((A).x*(A).x+(A).y*(A).y+(A).z*(A).z))

#define PR_VecAdd(C, A, B)  { (C).x=(A).x+(B).x; \
                              (C).y=(A).y+(B).y; \
                              (C).z=(A).z+(B).z; }

#define PR_VecSubtract(C, A, B)  { (C).x=(A).x-(B).x; \
                                   (C).y=(A).y-(B).y; \
                                   (C).z=(A).z-(B).z; }

#define PR_VecScalarMultiply(C, a, A)  { (C).x=(a)*(A).x; \
                                         (C).y=(a)*(A).y; \
                                         (C).z=(a)*(A).z; }

/* C = a*A + B */
#define PR_VecAddS(C, a, A, B)  { (C).x=(a)*(A).x+(B).x; \
                               (C).y=(a)*(A).y+(B).y; \
                               (C).z=(a)*(A).z+(B).z; }

/* C = a*A + b*B */
#define PR_VecComb(C, a, A, b, B)   { (C).x=(a)*(A).x+(b)*(B).x; \
                                   (C).y=(a)*(A).y+(b)*(B).y; \
                                   (C).z=(a)*(A).z+(b)*(B).z; }

/* C = A X B */
#define PR_VecCrossProduct(C, A, B)      { (C).x=(A).y*(B).z-(A).z*(B).y; \
                                           (C).y=(A).z*(B).x-(A).x*(B).z; \
                                           (C).z=(A).x*(B).y-(A).y*(B).x; }

#define PR_VecMax(C, A, B)          { (C).x=(((A).x>(B).x)?(A).x:(B).x); \
                                      (C).y=(((A).y>(B).y)?(A).y:(B).y); \
                                      (C).z=(((A).z>(B).z)?(A).z:(B).z); }

#define PR_VecMin(C, A, B)          { (C).x=(((A).x<(B).x)?(A).x:(B).x); \
                                      (C).y=(((A).y<(B).y)?(A).y:(B).y); \
                                      (C).z=(((A).z<(B).z)?(A).z:(B).z); }

#define Max(A,B) (A > B) ? A : B;
#define Min(A,B) (A < B) ? A : B;


#ifdef __cplusplus
}
#endif

#endif
